/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import mods.waterstrainer.inventory.ContainerWormBin;
import mods.waterstrainer.tileentity.TileEntityWormBin;
import mods.waterstrainer.util.APIUtils;
import mods.waterstrainer.util.WaterStrainerUtils;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.lwjgl.opengl.GL11;

public class GuiWormBin
extends ContainerScreen<ContainerWormBin> {
    private static final ResourceLocation guiTexture = new ResourceLocation("waterstrainer", "textures/gui/worm_bin.png");
    private final TileEntityWormBin tile;
    private final PlayerInventory playerInventory;

    public GuiWormBin(ContainerWormBin container, PlayerInventory playerInventory, ITextComponent text) {
        super((Container)container, playerInventory, text);
        this.playerInventory = playerInventory;
        this.tile = container.wormBin;
        this.field_147000_g = 139;
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        int progress;
        this.func_230446_a_(matrix);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrix, mouseX, mouseY);
        Slot slot = this.getSlotUnderMouse();
        if (slot != null) {
            int slotIndex = slot.field_75222_d;
            if (slot.func_75216_d()) {
                return;
            }
            if (slotIndex == 0) {
                this.func_238652_a_(matrix, (ITextComponent)new StringTextComponent("Food Slot"), mouseX, mouseY);
            } else if (slotIndex == 1) {
                this.func_238652_a_(matrix, (ITextComponent)new StringTextComponent("Worm Slot"), mouseX, mouseY);
            } else if (slotIndex == 2) {
                this.func_238652_a_(matrix, (ITextComponent)new StringTextComponent("Fertilizer Slot"), mouseX, mouseY);
            }
        }
        if (this.isMouseHovering(mouseX, mouseY, this.field_147003_i + 93, this.field_147009_r + 23, 3, 16)) {
            progress = this.getProgressPercentageWorm();
            this.func_238652_a_(matrix, (ITextComponent)new StringTextComponent(progress + "%"), mouseX, mouseY);
        } else if (this.isMouseHovering(mouseX, mouseY, this.field_147003_i + 136, this.field_147009_r + 23, 3, 16)) {
            progress = this.getProgressPercentageFertilizer();
            this.func_238652_a_(matrix, (ITextComponent)new StringTextComponent(progress + "%"), mouseX, mouseY);
        } else if (this.isMouseHovering(mouseX, mouseY, this.field_147003_i + 155, this.field_147009_r + 5, 16, 16) && !APIUtils.isJEILoaded()) {
            this.func_243308_b(matrix, Arrays.asList(new StringTextComponent("Show Recipes"), new StringTextComponent("This function is only available if you"), new StringTextComponent(WaterStrainerUtils.ctext("have #BLUE#Just Enough Items (JEI)#RESET# installed."))), mouseX, mouseY);
        }
    }

    protected void func_230451_b_(MatrixStack matrix, int mouseX, int mouseY) {
        String s = this.tile.func_145748_c_().getString();
        this.field_230712_o_.func_238421_b_(matrix, s, (float)(this.field_146999_f / 2 - this.field_230712_o_.func_78256_a(s) / 2), 6.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(matrix, this.playerInventory.func_145748_c_().getString(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(guiTexture);
        int k = this.field_147003_i;
        int l = this.field_147009_r;
        this.func_238474_b_(matrix, k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.tile.inv.getStackInSlot(0).func_190926_b()) {
            this.func_238474_b_(matrix, k + 38, l + 23, 176, 0, 16, 16);
        }
        if (this.tile.inv.getStackInSlot(1).func_190926_b()) {
            this.func_238474_b_(matrix, k + 98, l + 23, 176, 32, 16, 16);
        }
        if (this.tile.inv.getStackInSlot(2).func_190926_b()) {
            this.func_238474_b_(matrix, k + 118, l + 23, 176, 16, 16, 16);
        }
        int length = this.getProgressBarLengthWorm();
        this.func_238474_b_(matrix, k + 94, l + 37 - length, 192, 13 - length, 1, length + 1);
        length = this.getProgressBarLengthFertilizer();
        this.func_238474_b_(matrix, k + 137, l + 37 - length, 192, 13 - length, 1, length + 1);
    }

    public boolean isMouseHovering(int mouse_x, int mouse_y, int x, int y, int xsize, int ysize) {
        return mouse_x >= x && mouse_x < x + xsize && mouse_y >= y && mouse_y < y + ysize;
    }

    private int getProgressPercentageWorm() {
        int min = ((ContainerWormBin)this.field_147002_h).getMinWorm();
        int max = 4;
        return min > 0 && max > 0 ? (int)(100.0f / (float)max * (float)min) : 0;
    }

    private int getProgressBarLengthWorm() {
        return (int)(0.14f * (float)this.getProgressPercentageWorm());
    }

    private int getProgressPercentageFertilizer() {
        int min = ((ContainerWormBin)this.field_147002_h).getMinFertilizer();
        int max = 20;
        return min > 0 && max > 0 ? (int)(100.0f / (float)max * (float)min) : 0;
    }

    private int getProgressBarLengthFertilizer() {
        return (int)(0.14f * (float)this.getProgressPercentageFertilizer());
    }
}

