/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.tileentity;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mods.waterstrainer.Config;
import mods.waterstrainer.WaterStrainer;
import mods.waterstrainer.block.BlockStrainerBase;
import mods.waterstrainer.inventory.ContainerStrainer;
import mods.waterstrainer.item.IIsBait;
import mods.waterstrainer.item.ItemBaitPot;
import mods.waterstrainer.item.ItemStrainer;
import mods.waterstrainer.util.LootTable;
import mods.waterstrainer.util.WaterStrainerUtils;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TileEntityStrainer
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public InventoryHandler inv = this.initInventory();
    private int curIdleTime = 0;
    private int maxIdleTime = Config.IDLE_TIME * 20;
    private static Random rand = new Random();
    private final IIntArray syncValues = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return TileEntityStrainer.this.curIdleTime;
                }
                case 1: {
                    return TileEntityStrainer.this.maxIdleTime;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityStrainer.this.curIdleTime = value;
                    break;
                }
                case 1: {
                    TileEntityStrainer.this.maxIdleTime = value;
                }
            }
        }

        public int func_221478_a() {
            return 2;
        }
    };
    private final LazyOptional<IItemHandler> capItemHandler = LazyOptional.of(() -> this.createCapabilityHandler());

    public TileEntityStrainer() {
        super(WaterStrainer.tile_strainer_base);
    }

    private InventoryHandler initInventory() {
        return new InventoryHandler(this);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.inv = this.initInventory();
        this.inv.deserializeNBT(nbt);
        this.curIdleTime = nbt.func_74762_e("CurIdleTime");
        this.maxIdleTime = nbt.func_74762_e("MaxIdleTime");
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_197643_a(this.inv.serializeNBT());
        nbt.func_74768_a("CurIdleTime", this.curIdleTime);
        nbt.func_74768_a("MaxIdleTime", this.maxIdleTime);
        return nbt;
    }

    protected IItemHandler createCapabilityHandler() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inv}){

            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return (slot < 1 || slot > 27) && this.isItemValid(slot, stack) ? super.insertItem(slot, stack, simulate) : stack;
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return slot >= 1 && slot <= 27 ? super.extractItem(slot, amount, simulate) : ItemStack.field_190927_a;
            }
        };
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.capItemHandler);
    }

    public ItemStack getStrainer() {
        return this.inv.getStackInSlot(0);
    }

    public float calculateEfficiencyBonus() {
        float efficiency = 0.0f;
        ItemStack strainer = this.getStrainer();
        if (Config.MISC_ENABLE_EFFICIENCY) {
            Biome biome;
            BiomeManager biomeManager;
            int level;
            FluidState liquid;
            if (strainer.func_77973_b() instanceof ItemStrainer) {
                efficiency += (float)((ItemStrainer)strainer.func_77973_b()).getEfficiencyBonus();
            }
            if ((liquid = this.field_145850_b.func_204610_c(this.field_174879_c.func_177984_a())) != null && (level = liquid.func_206882_g()) > 0) {
                efficiency -= (float)(Math.max(0, 6 - level) * 4);
            }
            BlockPos pos = this.field_174879_c;
            for (int curZ = pos.func_177952_p() - 1; curZ < pos.func_177952_p() + 2; ++curZ) {
                for (int curX = pos.func_177958_n() - 1; curX < pos.func_177958_n() + 2; ++curX) {
                    if (curX == pos.func_177958_n() && curZ == pos.func_177952_p() || !(this.field_145850_b.func_180495_p(new BlockPos(curX, pos.func_177956_o(), curZ)).func_177230_c() instanceof BlockStrainerBase)) continue;
                    efficiency -= 15.0f;
                }
            }
            World world = this.func_145831_w();
            if (world != null && (biomeManager = world.func_225523_d_()) != null && (biome = biomeManager.func_226836_a_(pos)) != null) {
                if (biome.func_201856_r() == Biome.Category.OCEAN) {
                    efficiency += 10.0f;
                } else if (biome.func_201856_r() == Biome.Category.BEACH) {
                    efficiency += 15.0f;
                } else if (biome.func_201856_r() == Biome.Category.RIVER) {
                    efficiency += 20.0f;
                }
            }
        }
        return efficiency += (float)(ItemStrainer.getEnchantmentLevel(strainer, Enchantments.field_185305_q) * 5);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.curIdleTime;
            if (this.field_145850_b.func_82737_E() % 20L == 10L) {
                List items;
                if (this.getStrainer().func_190926_b()) {
                    this.curIdleTime = 0;
                }
                if ((items = this.func_145831_w().func_175647_a(ItemEntity.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 2), (double)(this.field_174879_c.func_177952_p() + 1)), EntityPredicates.field_94557_a)).size() > 0) {
                    WaterStrainerUtils.addEntityItemToInventory((ItemEntity)items.get(0), this.inv, 1, 27);
                    this.func_70296_d();
                }
            }
            if (this.curIdleTime >= this.maxIdleTime) {
                this.curIdleTime = 0;
                int min = Config.IDLE_TIME - Config.IDLE_TIME_DEVIATION;
                int max = Config.IDLE_TIME + Config.IDLE_TIME_DEVIATION;
                this.maxIdleTime = (rand.nextInt(max - min + 1) + min) * 20;
                float efficiency = this.calculateEfficiencyBonus();
                if (efficiency > 0.0f) {
                    this.maxIdleTime = (int)((float)this.maxIdleTime / ((efficiency + 100.0f) / 100.0f));
                } else if (efficiency < 0.0f) {
                    this.maxIdleTime = (int)((float)this.maxIdleTime * (((efficiency *= -1.0f) + 100.0f) / 100.0f));
                }
                ItemStack strainerStack = this.getStrainer();
                if (strainerStack.func_77973_b() instanceof ItemStrainer) {
                    ItemStrainer strainerItem = (ItemStrainer)strainerStack.func_77973_b();
                    if (BlockStrainerBase.isStrainerInLiquid(this.field_145850_b, this.field_174879_c)) {
                        ItemStack loot;
                        boolean requiresBait;
                        boolean bl = requiresBait = strainerItem.TYPE.category == ItemStrainer.StrainerCategory.FISHER;
                        if (requiresBait && !this.hasBait()) {
                            return;
                        }
                        int maxRolls = Config.MISC_ENABLE_ENCHANTING ? ItemStrainer.getEnchantmentLevel(strainerStack, Enchantments.field_151370_z) + 1 : 1;
                        LootTable.Category cat = null;
                        for (int roll = 0; roll < maxRolls; ++roll) {
                            LootTable.Category tempCat = strainerItem.LOOT_TABLE.getRandomCategoryFromTable();
                            if (tempCat == null || cat != null && tempCat.rarity >= cat.rarity) continue;
                            boolean breakLoop = cat != null;
                            cat = tempCat;
                            if (breakLoop) break;
                        }
                        ItemStack itemStack = loot = cat != null ? cat.getRandomLootFromCategory() : ItemStack.field_190927_a;
                        if (!loot.func_190926_b()) {
                            if (loot.func_77973_b() == Items.field_151134_bR) {
                                loot = EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)new ItemStack((IItemProvider)Items.field_151122_aG), (int)(rand.nextInt(10) + 1), (boolean)true);
                            }
                            int stackSize = loot.func_190916_E();
                            if ((loot = WaterStrainerUtils.addItemToInventory(loot, this.inv, 1, 27)).func_190926_b() || stackSize != loot.func_190916_E()) {
                                if (ItemStrainer.generateBonusItem(ItemStrainer.getEnchantmentLevel(strainerStack, Enchantments.field_185308_t)) && !(loot = strainerItem.LOOT_TABLE.getRandomLootFromTable()).func_190926_b()) {
                                    if (loot.func_77973_b() == Items.field_151134_bR) {
                                        loot = EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)new ItemStack((IItemProvider)Items.field_151122_aG), (int)(rand.nextInt(10) + 1), (boolean)true);
                                    }
                                    WaterStrainerUtils.addItemToInventory(loot, this.inv, 1, 27);
                                }
                                if (requiresBait) {
                                    this.consumeBait();
                                }
                                if (strainerStack.func_77984_f()) {
                                    if (!ItemStrainer.preventDamage(ItemStrainer.getEnchantmentLevel(strainerStack, Enchantments.field_185307_s))) {
                                        strainerStack.func_196085_b(strainerStack.func_77952_i() + 1);
                                    }
                                    if (strainerStack.func_77952_i() >= strainerStack.func_77958_k()) {
                                        this.inv.setStackInSlot(0, ItemStack.field_190927_a);
                                    }
                                }
                            }
                            this.func_70296_d();
                        }
                    }
                }
            }
        }
    }

    private boolean hasBait() {
        ItemStack bait = this.inv.getStackInSlot(28);
        return !bait.func_190926_b() && bait.func_77973_b() instanceof IIsBait;
    }

    private void consumeBait() {
        ItemStack bait = this.inv.getStackInSlot(28);
        if (bait.func_77973_b() instanceof IIsBait && !((IIsBait)bait.func_77973_b()).infiniteBait()) {
            ItemStack pot = this.inv.getStackInSlot(29);
            if (pot.func_77973_b() instanceof ItemBaitPot && rand.nextInt(2) == 0) {
                pot.func_196085_b(pot.func_77952_i() + 1);
                if (pot.func_77952_i() >= pot.func_77958_k()) {
                    this.inv.setStackInSlot(29, ItemStack.field_190927_a);
                }
                return;
            }
            bait.func_190918_g(1);
        }
    }

    public Container createMenu(int id, PlayerInventory invIn, PlayerEntity playerIn) {
        return new ContainerStrainer(id, invIn, this.func_174877_v(), this.syncValues);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("block.waterstrainer.strainer_base");
    }

    public class InventoryHandler
    extends ItemStackHandler {
        private final TileEntityStrainer tile;

        private InventoryHandler(TileEntityStrainer te) {
            super(30);
            this.tile = te;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (slot == 0) {
                BlockStrainerBase.updateModel(this.tile);
            }
            this.tile.func_70296_d();
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (slot >= 0 && slot <= 0) {
                return stack.func_77973_b() instanceof ItemStrainer;
            }
            if (slot >= 28 && slot <= 28) {
                return stack.func_77973_b() instanceof IIsBait;
            }
            if (slot >= 29 && slot <= 29) {
                return stack.func_77973_b() instanceof ItemBaitPot;
            }
            return true;
        }
    }
}

