/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.worldblender.biome;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.telepathicgrunt.worldblender.WorldBlender;
import net.telepathicgrunt.worldblender.biome.biomes.BlendedBiome;
import net.telepathicgrunt.worldblender.biome.biomes.FrozenOceanBlendedBiome;
import net.telepathicgrunt.worldblender.biome.biomes.MountainousBlendedBiome;
import net.telepathicgrunt.worldblender.biome.biomes.OceanBlendedBiome;
import net.telepathicgrunt.worldblender.biome.biomes.VanillaEntriesHolderBiome;
import net.telepathicgrunt.worldblender.biome.biomes.surfacebuilder.BlendedSurfaceBuilder;

public class WBBiomes {
    public static Set<Biome> biomes = new HashSet<Biome>();
    public static final SurfaceBuilder<SurfaceBuilderConfig> FEATURE_SURFACE_BUILDER = new BlendedSurfaceBuilder(SurfaceBuilderConfig::func_215455_a);
    public static Biome BLENDED_BIOME = new BlendedBiome();
    public static Biome MOUNTAINOUS_BLENDED_BIOME = new MountainousBlendedBiome();
    public static Biome OCEAN_BLENDED_BIOME = new OceanBlendedBiome();
    public static Biome FROZEN_OCEAN_BLENDED_BIOME = new FrozenOceanBlendedBiome();
    public static Biome VANILLA_TEMP_BIOME = new VanillaEntriesHolderBiome();

    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        IForgeRegistry registry = event.getRegistry();
        WBBiomes.initBiome((IForgeRegistry<Biome>)registry, BLENDED_BIOME, "Blended Biome", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.RARE);
        WBBiomes.initBiome((IForgeRegistry<Biome>)registry, MOUNTAINOUS_BLENDED_BIOME, "Mountain Blended Biome", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.RARE);
        WBBiomes.initBiome((IForgeRegistry<Biome>)registry, OCEAN_BLENDED_BIOME, "Ocean Blended Biome", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.RARE);
        WBBiomes.initBiome((IForgeRegistry<Biome>)registry, FROZEN_OCEAN_BLENDED_BIOME, "Frozen Ocean Blended Biome", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.RARE);
    }

    private static Biome initBiome(IForgeRegistry<Biome> registry, Biome biome, String name, BiomeManager.BiomeType biomeType, BiomeDictionary.Type ... types) {
        WorldBlender.register(registry, biome, name);
        biomes.add(biome);
        return biome;
    }
}

