/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.worldblender.biome.biomes.surfacebuilder;

import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.telepathicgrunt.worldblender.configs.WBConfig;
import net.telepathicgrunt.worldblender.the_blender.ConfigBlacklisting;

public class BlendedSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    private static List<SurfaceBuilderConfig> configList;
    private static PerlinNoiseGenerator perlinGen;
    public static long perlinSeed;

    public BlendedSurfaceBuilder(Function<Dynamic<?>, ? extends SurfaceBuilderConfig> config) {
        super(config);
    }

    public void buildSurface(Random random, IChunk chunk, Biome biome, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        SurfaceBuilder.field_215396_G.func_205610_a_(random, chunk, biome, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)configList.get(this.weightedIndex(x, z)));
    }

    public static void resetSurfaceList() {
        configList = new ArrayList<SurfaceBuilderConfig>();
        configList.add(field_215394_E);
        configList.add(field_215395_F);
        if (((Boolean)WBConfig.SERVER.allowVanillaSurfaces.get()).booleanValue() && ((Boolean)WBConfig.SERVER.allowVanillaBiomeImport.get()).booleanValue()) {
            configList.add(field_215425_v);
            configList.add(field_215423_t);
            configList.add(field_215392_C);
            configList.add(field_215391_B);
            configList.add(field_215393_D);
            configList.add(new SurfaceBuilderConfig(Blocks.field_196604_cC.func_176223_P(), Blocks.field_150346_d.func_176223_P(), Blocks.field_150351_n.func_176223_P()));
            configList.add(field_215428_y);
            configList.add(field_215422_s);
            configList.add(field_215424_u);
        }
        for (int i = configList.size() - 1; i > 1; --i) {
            if (!ConfigBlacklisting.isBiomeNotAllowed(ConfigBlacklisting.BlacklistType.SURFACE_BLOCK, configList.get(i).func_204108_a().func_177230_c().getRegistryName())) continue;
            configList.remove(i);
        }
    }

    public boolean containsConfig(SurfaceBuilderConfig configIn) {
        return configList.stream().anyMatch(configEntry -> configEntry.func_204108_a() == configIn.func_204108_a() && configEntry.func_204109_b() == configIn.func_204109_b() && configEntry.func_204110_c() == configIn.func_204110_c());
    }

    public void addConfig(SurfaceBuilderConfig configIn) {
        configList.add(configIn);
    }

    private int weightedIndex(int x, int z) {
        int listSize = configList.size();
        int chosenConfigIndex = 2;
        for (int configIndex = 0; configIndex < listSize; ++configIndex) {
            if (configIndex == 0) {
                if (!(Math.abs(perlinGen.func_215464_a((double)x / 240.0, (double)z / 240.0, true)) < 0.035)) continue;
                chosenConfigIndex = 0;
                break;
            }
            if (configIndex == 1) {
                if (!(Math.abs(perlinGen.func_215464_a((double)x / 240.0, (double)z / 240.0, true)) < 0.06)) continue;
                chosenConfigIndex = 1;
                break;
            }
            double offset = 200.0 * (double)configIndex;
            double scaling = 200.0 + (double)configIndex * 4.0;
            double threshold = 0.6 / (double)listSize + Math.min((double)configIndex / 150.0, 0.125);
            if (!(Math.abs(perlinGen.func_215464_a(((double)x + offset) / scaling, ((double)z + offset) / scaling, true)) < threshold)) continue;
            chosenConfigIndex = configIndex;
            break;
        }
        return Math.min(chosenConfigIndex, listSize - 1);
    }

    public static void setPerlinSeed(long seed) {
        if (perlinGen == null) {
            perlinGen = new PerlinNoiseGenerator((Random)new SharedSeedRandom(seed), 1);
            perlinSeed = seed;
        }
    }
}

