/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.worldblender.blocks;

import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.telepathicgrunt.worldblender.WorldBlender;
import net.telepathicgrunt.worldblender.blocks.WBBlocks;
import net.telepathicgrunt.worldblender.blocks.WBPortalTileEntity;
import net.telepathicgrunt.worldblender.configs.WBConfig;
import org.apache.logging.log4j.Level;

@Mod.EventBusSubscriber(modid="world_blender", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WBPortalSpawning {
    @SubscribeEvent
    public static void BlockRightClickEvent(PlayerInteractEvent.RightClickBlock event) {
        BlockPos.MutableBlockPos cornerOffset;
        boolean eightChestsFound;
        World world = event.getWorld();
        BlockPos position = event.getPos();
        if (world.func_175624_G() == WorldBlender.WBWorldType) {
            return;
        }
        ForgeRegistry registry = (ForgeRegistry)ForgeRegistries.ITEMS;
        ResourceLocation activationItem = new ResourceLocation(WBConfig.activationItem);
        if (!registry.containsKey(activationItem)) {
            WorldBlender.LOGGER.log(Level.INFO, "World Blender: Warning, the activation item set in the config does not exist. Please make sure it is a valid resource location to a real item as the portal cannot be created now.");
            StringTextComponent message = new StringTextComponent("\u00a7eWorld Blender: \u00a7fWarning, the activation item set in the config does not exist. Please make sure it is a valid resource location to a real item as the portal cannot be created now.");
            event.getPlayer().func_145747_a((ITextComponent)message);
            return;
        }
        if (event.getPlayer().func_70093_af() && event.getPlayer().func_184614_ca().func_77973_b() == registry.getRaw(activationItem) && world.func_180495_p(position).func_177230_c().getTags().contains(Tags.Blocks.CHESTS.func_199886_b()) && (eightChestsFound = WBPortalSpawning.checkForValidChests(world, position, cornerOffset = new BlockPos.MutableBlockPos(1, 1, 1)))) {
            int index;
            ChestTileEntity chestTileEntity;
            HashSet<Item> uniqueBlocksSet = new HashSet<Item>();
            HashSet<Item> invalidItemSet = new HashSet<Item>();
            HashSet<Item> duplicateBlockSlotSet = new HashSet<Item>();
            for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)position, (BlockPos)position.func_177971_a((Vec3i)cornerOffset))) {
                chestTileEntity = (ChestTileEntity)world.func_175625_s(blockpos);
                for (index = 0; index < chestTileEntity.func_70302_i_(); ++index) {
                    Item item2 = chestTileEntity.func_70301_a(index).func_77973_b();
                    if (Block.func_149634_a((Item)item2) != Blocks.field_150350_a) {
                        if (uniqueBlocksSet.contains(item2)) {
                            duplicateBlockSlotSet.add(item2);
                            continue;
                        }
                        uniqueBlocksSet.add(item2);
                        continue;
                    }
                    invalidItemSet.add(item2);
                }
            }
            if (uniqueBlocksSet.size() >= WBConfig.uniqueBlocksNeeded) {
                for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)position, (BlockPos)position.func_177971_a((Vec3i)cornerOffset))) {
                    if (WBConfig.consumeChests) {
                        chestTileEntity = (ChestTileEntity)world.func_175625_s(blockpos);
                        for (index = chestTileEntity.func_70302_i_(); index >= 0; --index) {
                            chestTileEntity.func_70304_b(index);
                        }
                    } else {
                        world.func_175655_b(blockpos, true);
                    }
                    world.func_180501_a(blockpos, ((Block)WBBlocks.WORLD_BLENDER_PORTAL.get()).func_176223_P(), 3);
                    WBPortalTileEntity wbtile = (WBPortalTileEntity)world.func_175625_s(blockpos);
                    wbtile.triggerCooldown();
                    event.getPlayer().func_184607_cu().func_190918_g(1);
                }
            } else if (!event.getWorld().field_72995_K && event.getPlayer().func_184600_cs() == event.getHand()) {
                String msg = "\u00a7eWorld Blender: \u00a7fThere are not enough unique block items in the chests. (stacks or duplicates are ignored) You need \u00a7c" + WBConfig.uniqueBlocksNeeded + "\u00a7f block items to make the portal but there is only \u00a7a" + uniqueBlocksSet.size() + "\u00a7f unique block items right now.";
                if (invalidItemSet.size() != 0) {
                    ArrayList invalidItemString = new ArrayList();
                    invalidItemSet.remove(Items.field_190931_a);
                    invalidItemSet.stream().forEach(item -> invalidItemString.add(item.func_200296_o().getString()));
                    msg = msg + "\u00a7f Also, here is a list of non-block items that were found and should be removed: \u00a76" + String.join((CharSequence)", ", invalidItemString);
                }
                if (duplicateBlockSlotSet.size() != 0) {
                    ArrayList duplicateSlotString = new ArrayList();
                    duplicateBlockSlotSet.remove(Items.field_190931_a);
                    duplicateBlockSlotSet.stream().forEach(blockitem -> duplicateSlotString.add(blockitem.func_200296_o().getString()));
                    msg = msg + "\u00a7f There are some slots that contains the same blocks and should be removed. These blocks are: \u00a76" + String.join((CharSequence)", ", duplicateSlotString);
                }
                WorldBlender.LOGGER.log(Level.INFO, msg);
                StringTextComponent message = new StringTextComponent(msg);
                event.getPlayer().func_145747_a((ITextComponent)message);
            }
        }
    }

    private static boolean checkForValidChests(World world, BlockPos position, BlockPos.MutableBlockPos offset) {
        boolean eightChestsFound = true;
        while (offset.func_177958_n() >= -1) {
            while (offset.func_177956_o() >= -1) {
                while (offset.func_177952_p() >= -1) {
                    for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)position, (BlockPos)position.func_177971_a((Vec3i)offset))) {
                        if (world.func_180495_p(blockpos).func_177230_c().getTags().contains(Tags.Blocks.CHESTS.func_199886_b())) continue;
                        eightChestsFound = false;
                        break;
                    }
                    if (eightChestsFound) {
                        return true;
                    }
                    eightChestsFound = true;
                    offset.func_189534_c(Direction.NORTH, 2);
                }
                offset.func_189534_c(Direction.SOUTH, 4);
                offset.func_189534_c(Direction.DOWN, 2);
            }
            offset.func_189534_c(Direction.UP, 4);
            offset.func_189534_c(Direction.WEST, 2);
        }
        return false;
    }
}

