/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.worldblender.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.telepathicgrunt.worldblender.blocks.WBBlocks;
import net.telepathicgrunt.worldblender.networking.MessageHandler;

public class WBPortalTileEntity
extends TileEntity
implements ITickableTileEntity {
    private float teleportCooldown = 300.0f;
    private boolean removeable = true;

    public WBPortalTileEntity() {
        super((TileEntityType)WBBlocks.WORLD_BLENDER_PORTAL_TILE.get());
    }

    public void func_73660_a() {
        boolean isCoolingDown = this.isCoolingDown();
        if (isCoolingDown) {
            this.teleportCooldown -= 1.0f;
        }
        if (isCoolingDown != this.isCoolingDown()) {
            this.func_70296_d();
        }
    }

    public void teleportEntity(Entity entity, BlockPos destPos, ServerWorld destinationWorld, ServerWorld originalWorld) {
        this.triggerCooldown();
        if (entity instanceof PlayerEntity) {
            ((ServerPlayerEntity)entity).func_200619_a(destinationWorld, (double)destPos.func_177958_n() + 0.5, (double)destPos.func_177956_o() + 1.0, (double)destPos.func_177952_p() + 0.5, entity.field_70177_z, entity.field_70125_A);
        } else {
            Entity entity2 = entity.func_200600_R().func_200721_a((World)destinationWorld);
            if (entity2 != null) {
                entity2.func_180432_n(entity);
                entity2.func_174828_a(destPos, entity.field_70177_z, entity.field_70125_A);
                entity2.func_213317_d(entity.func_213322_ci());
                destinationWorld.func_217460_e(entity2);
            }
            entity.remove(false);
            this.field_145850_b.func_217381_Z().func_76319_b();
            originalWorld.func_82742_i();
            destinationWorld.func_82742_i();
            this.field_145850_b.func_217381_Z().func_76319_b();
        }
    }

    public boolean isCoolingDown() {
        return this.teleportCooldown > 0.0f;
    }

    public float getCoolDown() {
        return this.teleportCooldown;
    }

    public void setCoolDown(float cooldown) {
        this.teleportCooldown = cooldown;
    }

    public void triggerCooldown() {
        this.teleportCooldown = 300.0f;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        MessageHandler.UpdateTECooldownPacket.sendToClient(this.field_174879_c, this.getCoolDown());
    }

    public boolean isRemoveable() {
        return this.removeable;
    }

    public void makeNotRemoveable() {
        this.removeable = false;
        this.func_70296_d();
    }

    public CompoundNBT func_189515_b(CompoundNBT data) {
        super.func_189515_b(data);
        data.func_74776_a("Cooldown", this.teleportCooldown);
        data.func_74757_a("Removeable", this.removeable);
        return data;
    }

    public void func_145839_a(CompoundNBT data) {
        super.func_145839_a(data);
        this.teleportCooldown = data.func_74764_b("Cooldown") ? data.func_74760_g("Cooldown") : 300.0f;
        this.removeable = data.func_74767_n("Removeable");
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getParticleAmount() {
        int visibleFaces = 0;
        for (Direction direction : Direction.values()) {
            visibleFaces += this.shouldRenderFace(direction) ? 1 : 0;
        }
        return visibleFaces;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderFace(Direction direction) {
        return Block.func_176225_a((BlockState)this.func_195044_w(), (IBlockReader)this.field_145850_b, (BlockPos)this.func_174877_v(), (Direction)direction);
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }
}

