/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.worldblender.blocks;

import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.FloatBuffer;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.telepathicgrunt.worldblender.blocks.WBPortalTileEntity;

@OnlyIn(value=Dist.CLIENT)
public class WBPortalTileEntityRenderer
extends TileEntityRenderer<WBPortalTileEntity> {
    public static final ResourceLocation MAIN_TEXTURE = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    public static final ResourceLocation ADDITIVE_TEXTURE = new ResourceLocation("textures/misc/forcefield.png");
    private static final Random RANDOM = new Random(31100L);
    private static final FloatBuffer MODELVIEW = GLAllocation.func_74529_h((int)16);
    private static final FloatBuffer PROJECTION = GLAllocation.func_74529_h((int)16);
    private final FloatBuffer buffer = GLAllocation.func_74529_h((int)16);

    public void render(WBPortalTileEntity tileEntity, double x, double y, double z, float partialTicks, int destroyStage) {
        RANDOM.setSeed(31100L);
        double d0 = x * x + y * y + z * z;
        int i = this.getPasses(d0);
        GlStateManager.disableLighting();
        RANDOM.setSeed(31100L);
        GlStateManager.getMatrix((int)2982, (FloatBuffer)MODELVIEW);
        GlStateManager.getMatrix((int)2983, (FloatBuffer)PROJECTION);
        float coolDownEffect = tileEntity.isCoolingDown() ? 0.7f - tileEntity.getCoolDown() / 1200.0f : 0.85f;
        boolean flag = false;
        GameRenderer gamerenderer = Minecraft.func_71410_x().field_71460_t;
        for (int j = 0; j < i; ++j) {
            GlStateManager.pushMatrix();
            if (j == 0) {
                this.func_147499_a(MAIN_TEXTURE);
                GlStateManager.enableBlend();
                GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }
            if (j >= 1) {
                this.func_147499_a(ADDITIVE_TEXTURE);
                flag = true;
                gamerenderer.func_191514_d(true);
            }
            if (j == 1) {
                GlStateManager.enableBlend();
                GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            }
            GlStateManager.texGenMode((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9216);
            GlStateManager.texGenMode((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9216);
            GlStateManager.texGenMode((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9216);
            GlStateManager.texGenParam((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9474, (FloatBuffer)this.getBuffer(1.0f, 0.0f, 0.0f, 0.0f));
            GlStateManager.texGenParam((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9474, (FloatBuffer)this.getBuffer(0.0f, 1.0f, 0.0f, 0.0f));
            GlStateManager.texGenParam((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9474, (FloatBuffer)this.getBuffer(0.0f, 0.0f, 1.0f, 0.0f));
            GlStateManager.enableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.S);
            GlStateManager.enableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.T);
            GlStateManager.enableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.R);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5890);
            GlStateManager.pushMatrix();
            GlStateManager.loadIdentity();
            GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.0f);
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)1.0f);
            float f2 = j + 1;
            GlStateManager.translatef((float)(17.0f / f2), (float)((2.0f + f2 / 1.5f) * ((float)(Util.func_211177_b() % 800000L) / 800000.0f)), (float)0.0f);
            GlStateManager.rotatef((float)((f2 * f2 * 4321.0f + f2 * 9.0f) * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.scalef((float)(4.5f - f2 / 4.0f), (float)(4.5f - f2 / 4.0f), (float)1.0f);
            GlStateManager.multMatrix((FloatBuffer)PROJECTION);
            GlStateManager.multMatrix((FloatBuffer)MODELVIEW);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            float red = RANDOM.nextFloat() * 3.85f * 1.5f / (float)(18 - i) * coolDownEffect + tileEntity.getCoolDown() / 2800.0f;
            float green = RANDOM.nextFloat() * 3.3f * 1.5f / (float)(18 - i) * coolDownEffect;
            float blue = RANDOM.nextFloat() * 2.95f * 1.5f / (float)(18 - i) * coolDownEffect;
            if (tileEntity.shouldRenderFace(Direction.SOUTH)) {
                bufferbuilder.func_181662_b(x, y, z + 1.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y, z + 1.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y + 1.0, z + 1.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b(x, y + 1.0, z + 1.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            }
            if (tileEntity.shouldRenderFace(Direction.NORTH)) {
                bufferbuilder.func_181662_b(x, y + 1.0, z).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y + 1.0, z).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y, z).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b(x, y, z).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            }
            if (tileEntity.shouldRenderFace(Direction.EAST)) {
                bufferbuilder.func_181662_b(x + 1.0, y + 1.0, z).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y + 1.0, z + 1.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y, z + 1.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y, z).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            }
            if (tileEntity.shouldRenderFace(Direction.WEST)) {
                bufferbuilder.func_181662_b(x, y, z).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b(x, y, z + 1.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b(x, y + 1.0, z + 1.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b(x, y + 1.0, z).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            }
            if (tileEntity.shouldRenderFace(Direction.DOWN)) {
                bufferbuilder.func_181662_b(x, y, z).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y, z).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y, z + 1.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b(x, y, z + 1.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            }
            if (tileEntity.shouldRenderFace(Direction.UP)) {
                bufferbuilder.func_181662_b(x, y + 1.0, z + 1.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y + 1.0, z + 1.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y + 1.0, z).func_181666_a(red, green, blue, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b(x, y + 1.0, z).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5888);
            this.func_147499_a(MAIN_TEXTURE);
        }
        GlStateManager.disableBlend();
        GlStateManager.disableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.S);
        GlStateManager.disableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.T);
        GlStateManager.disableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.R);
        GlStateManager.enableLighting();
        if (flag) {
            gamerenderer.func_191514_d(false);
        }
    }

    private FloatBuffer getBuffer(float p_147525_1_, float p_147525_2_, float p_147525_3_, float p_147525_4_) {
        this.buffer.clear();
        this.buffer.put(p_147525_1_).put(p_147525_2_).put(p_147525_3_).put(p_147525_4_);
        this.buffer.flip();
        return this.buffer;
    }

    protected int getPasses(double distanceAway) {
        if (distanceAway > 36864.0) {
            return 1;
        }
        if (distanceAway > 25600.0) {
            return 2;
        }
        if (distanceAway > 16384.0) {
            return 3;
        }
        if (distanceAway > 9216.0) {
            return 4;
        }
        if (distanceAway > 4096.0) {
            return 5;
        }
        if (distanceAway > 1024.0) {
            return 6;
        }
        if (distanceAway > 576.0) {
            return 7;
        }
        return distanceAway > 256.0 ? 8 : 9;
    }
}

