/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.worldblender.dimension;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerWorld;
import net.telepathicgrunt.worldblender.dimension.WBWorldSavedData;
import net.telepathicgrunt.worldblender.features.WBFeatures;

public class AltarManager {
    private boolean altarMade = false;
    private final ServerWorld world;

    public AltarManager(ServerWorld serverWorld) {
        this.world = serverWorld;
        this.altarMade = WBWorldSavedData.get((World)serverWorld).getWBAltarState();
    }

    public boolean getState() {
        return this.altarMade;
    }

    public void tick() {
        boolean flag = this.isWorldOriginTicking();
        if (!this.altarMade && flag) {
            WBFeatures.WB_PORTAL_ALTAR.func_212245_a((IWorld)this.world, this.world.func_72863_F().field_186029_c, this.world.field_73012_v, new BlockPos(0, 255, 0), (IFeatureConfig)IFeatureConfig.field_202429_e);
            this.altarMade = true;
            this.saveWBAltarData((World)this.world);
        }
    }

    private boolean isWorldOriginTicking() {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                IChunk ichunk = this.world.func_217353_a(x, z, ChunkStatus.field_222617_m, false);
                if (!(ichunk instanceof Chunk)) {
                    return false;
                }
                ChunkHolder.LocationType chunkholder$locationtype = ((Chunk)ichunk).func_217321_u();
                if (chunkholder$locationtype.func_219065_a(ChunkHolder.LocationType.TICKING)) continue;
                return false;
            }
        }
        return true;
    }

    public void saveWBAltarData(World world) {
        WBWorldSavedData.get(world).setWBAltarState(this.altarMade);
        WBWorldSavedData.get(world).func_76185_a();
    }
}

