/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.worldblender.dimension;

import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;
import net.telepathicgrunt.worldblender.dimension.WBDimension;

public class WBWorldSavedData
extends WorldSavedData {
    private static final String ALTAR_DATA = "world_blenderAltarMade";
    private static final WBWorldSavedData CLIENT_DUMMY = new WBWorldSavedData();
    private boolean wbAltarMade;
    private boolean dragonDataSaved;
    private boolean dragonKilled;
    private boolean dragonPreviouslyKilled;
    private boolean dragonIsRespawning;
    private boolean generatedInitialFight;
    private BlockPos endAltarPosition;
    private UUID dragonUUID;

    public WBWorldSavedData() {
        super(ALTAR_DATA);
    }

    public WBWorldSavedData(String s) {
        super(s);
    }

    public static WBWorldSavedData get(World world) {
        if (!(world instanceof ServerWorld)) {
            return CLIENT_DUMMY;
        }
        ServerWorld wbWorld = ((ServerWorld)world).func_73046_m().func_71218_a(WBDimension.worldblender());
        DimensionSavedDataManager storage = wbWorld.func_217481_x();
        return (WBWorldSavedData)storage.func_215752_a(WBWorldSavedData::new, ALTAR_DATA);
    }

    public void func_76184_a(CompoundNBT data) {
        this.wbAltarMade = data.func_74767_n("wbAltarMade");
        this.dragonDataSaved = data.func_74767_n("dragonDataSaved");
        this.dragonKilled = data.func_74767_n("dragonKilled");
        this.dragonPreviouslyKilled = data.func_74767_n("dragonPreviouslyKilled");
        this.dragonIsRespawning = data.func_74767_n("dragonIsRespawning");
        this.generatedInitialFight = data.func_74767_n("generatedInitialFight");
        this.endAltarPosition = new BlockPos(data.func_74762_e("endAltarPositionX"), data.func_74762_e("endAltarPositionY"), data.func_74762_e("endAltarPositionZ"));
        this.dragonUUID = data.func_186857_a("dragonUUID");
    }

    public CompoundNBT func_189551_b(CompoundNBT data) {
        data.func_74757_a("wbAltarMade", this.wbAltarMade);
        data.func_74757_a("dragonDataSaved", this.dragonDataSaved);
        data.func_74757_a("dragonKilled", this.dragonKilled);
        data.func_74757_a("dragonPreviouslyKilled", this.dragonPreviouslyKilled);
        data.func_74757_a("dragonIsRespawning", this.dragonIsRespawning);
        data.func_74757_a("generatedInitialFight", this.generatedInitialFight);
        if (this.endAltarPosition != null) {
            data.func_74768_a("endAltarPositionX", this.endAltarPosition.func_177958_n());
            data.func_74768_a("endAltarPositionY", this.endAltarPosition.func_177956_o());
            data.func_74768_a("endAltarPositionZ", this.endAltarPosition.func_177952_p());
        }
        if (this.dragonUUID != null) {
            data.func_186854_a("dragonUUID", this.dragonUUID);
        }
        return data;
    }

    public void setWBAltarState(boolean state) {
        this.wbAltarMade = state;
    }

    public boolean getWBAltarState() {
        return this.wbAltarMade;
    }

    public boolean isDragonKilled() {
        return this.dragonKilled;
    }

    public void setDragonKilled(boolean dragonKilled) {
        this.dragonKilled = dragonKilled;
    }

    public UUID getDragonUUID() {
        return this.dragonUUID;
    }

    public void setDragonUUID(UUID dragonUUID) {
        this.dragonUUID = dragonUUID;
    }

    public boolean isDragonDataSaved() {
        return this.dragonDataSaved;
    }

    public void setDragonDataSaved(boolean dragonDataSaved) {
        this.dragonDataSaved = dragonDataSaved;
    }

    public boolean isDragonPreviouslyKilled() {
        return this.dragonPreviouslyKilled;
    }

    public void setDragonPreviouslyKilled(boolean dragonPreviouslyKilled) {
        this.dragonPreviouslyKilled = dragonPreviouslyKilled;
    }

    public boolean isDragonRespawning() {
        return this.dragonIsRespawning;
    }

    public void setDragonRespawning(boolean dragonIsRespawning) {
        this.dragonIsRespawning = dragonIsRespawning;
    }

    public BlockPos getEndAltarPosition() {
        return this.endAltarPosition;
    }

    public void setEndAltarPosition(BlockPos endAltarPosition) {
        this.endAltarPosition = endAltarPosition;
    }

    public boolean isInitialFightGenerated() {
        return this.generatedInitialFight;
    }

    public void setGeneratedInitialFight(boolean generatedInitialFightIn) {
        this.generatedInitialFight = generatedInitialFightIn;
    }
}

