/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.worldblender.features;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.tileentity.BarrelTileEntity;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import net.telepathicgrunt.worldblender.WorldBlender;
import org.apache.logging.log4j.Level;

public class DDDungeonFeature
extends Feature<NoFeatureConfig> {
    private String[] entrance = new String[]{"entrance_1", "entrance_2", "entrance_3", "entrance_4", "entrance_5", "entrance_6", "entrance_7", "entrance_8"};
    private String[] end = new String[]{"deadend_1", "deadend_2", "deadend_3", "deadend_4", "deadend_5", "deadend_6", "deadend_7", "deadend_8", "coffin_1", "advice_room_1", "restroom_1", "shoutout_1", "spawner_1", "redspuzzle_1", "deathtrap_1", "keyroom_1"};
    private String[] corner = new String[]{"corner_1", "corner_2", "corner_3", "corner_4", "corner_5", "corner_6", "corner_7", "corner_8", "redstrap_3", "longcorner_1", "longcorner_2", "longcorner_3", "longcorner_4", "longcorner_5", "skullcorner", "mazenotfound_1"};
    private String[] hallway = new String[]{"hallway_1", "hallway_2", "hallway_3", "hallway_4", "hallway_5", "hallway_6", "advice_room_3", "tempt_1", "redstrap_2", "extrahall_1", "extrahall_2", "extrahall_3", "coalhall_1", "moohall", "mazenotfound_3"};
    private String[] threeway = new String[]{"threeway_1", "threeway_2", "threeway_3", "threeway_4", "threeway_5", "advice_room_2", "redstrap_4", "morethree_1", "morethree_2", "morethree_3", "tetris_1", "mazenotfound_2"};
    private String[] fourway = new String[]{"fourway_1", "fourway_2", "fourway_3", "fourway_4", "fourway_5", "fourway_6", "fourway_7", "fourway_8", "fourway_9", "combat_1", "combat_1", "redstrap_1"};
    private String[] hardrooms = new String[]{"swimmaze_1", "combat_2", "combat_3", "combat_4", "combat_5", "disco_3", "tetris_2", "tetris_3", "tempt_2", "tempt_3", "tempt_4", "coalhall_3", "coalhall_4", "coalhall_5", "extrahall_3", "extrahall_4", "extrahall_5", "coffin_2", "coffin_3", "coffin_4", "coffin_5", "restroom_2", "restroom_3", "restroom_4", "restroom_5", "shoutout_2", "redspuzzle_2", "redspuzzle_3", "redspuzzle_4", "deathtrap_2", "deathtrap_3", "deathtrap_4", "keytrap_1", "keytrap_2", "keytrap_3", "keytrap_4", "keytrap_5", "keyroom_2", "keyroom_3", "keyroom_4", "spawner_2", "spawner_3", "spawner_4", "spawner_5", "spawner_6"};
    private String[][] roomTypes = new String[][]{this.entrance, this.end, this.corner, this.hallway, this.threeway, this.fourway, this.hardrooms};
    protected long seed;
    protected OctavesNoiseGenerator noiseGen;

    public void setSeed(long seed) {
        if (this.noiseGen == null) {
            this.noiseGen = new OctavesNoiseGenerator((Random)new SharedSeedRandom(seed), 1);
        }
        this.seed = seed;
    }

    public DDDungeonFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> changedBlock, Random rand, BlockPos position, NoFeatureConfig config) {
        String roomName;
        int zChunk;
        double noise = this.noiseGen.func_215460_a((double)position.func_177958_n() * 0.018, (double)position.func_177952_p() * 0.018, 0.0625, 0.0625);
        WorldBlender.LOGGER.warn((Object)noise);
        if (noise < 0.25) {
            return false;
        }
        int xChunk = position.func_177958_n() >> 4;
        if (xChunk % 2 == (zChunk = position.func_177952_p() >> 4) % 2) {
            roomName = this.fourway[rand.nextInt(this.fourway.length)];
        } else {
            String[] roomGroup = this.roomTypes[rand.nextInt(this.roomTypes.length)];
            roomName = roomGroup[rand.nextInt(roomGroup.length)];
        }
        TemplateManager templatemanager = ((ServerWorld)world.func_201672_e()).func_217485_w().func_186340_h();
        Template template = templatemanager.func_200219_b(new ResourceLocation("dimdungeons:" + roomName));
        if (template == null) {
            WorldBlender.LOGGER.warn("dimdungeons's " + roomName + " NTB does not exist!");
            return false;
        }
        BlockPos finalPosition = new BlockPos((double)(xChunk << 4), 20.0 + noise * 5.0, (double)(zChunk << 4));
        PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a((ChunkPos)null);
        placementsettings.func_186223_a(placementsettings.func_186213_g());
        Rotation rot = Rotation.func_222466_a((Random)rand);
        if (rot == Rotation.COUNTERCLOCKWISE_90) {
            placementsettings.func_186220_a(Rotation.COUNTERCLOCKWISE_90);
            finalPosition = finalPosition.func_177982_a(0, 0, template.func_186259_a().func_177952_p() - 1);
        } else if (rot == Rotation.CLOCKWISE_90) {
            placementsettings.func_186220_a(Rotation.CLOCKWISE_90);
            finalPosition = finalPosition.func_177982_a(template.func_186259_a().func_177958_n() - 1, 0, 0);
        } else if (rot == Rotation.CLOCKWISE_180) {
            placementsettings.func_186220_a(Rotation.CLOCKWISE_180);
            finalPosition = finalPosition.func_177982_a(template.func_186259_a().func_177958_n() - 1, 0, template.func_186259_a().func_177952_p() - 1);
        } else {
            placementsettings.func_186220_a(Rotation.NONE);
        }
        try {
            template.func_186253_b(world, finalPosition, placementsettings);
        }
        catch (Exception e) {
            WorldBlender.LOGGER.log(Level.WARN, "CRASHED WHILE MAKING dimdungeons:" + roomName + " AND ERROR IS: " + e.getCause() + e.getStackTrace());
            return false;
        }
        for (Template.BlockInfo template$blockinfo : template.func_215381_a(finalPosition, placementsettings, Blocks.field_185779_df)) {
            StructureMode structuremode;
            if (template$blockinfo.field_186244_c == null || (structuremode = StructureMode.valueOf((String)template$blockinfo.field_186244_c.func_74779_i("mode"))) != StructureMode.DATA) continue;
            DDDungeonFeature.handleDataBlock(template$blockinfo.field_186244_c.func_74779_i("metadata"), template$blockinfo.field_186242_a, world, world.func_201674_k(), placementsettings.func_186213_g());
        }
        WorldBlender.LOGGER.log(Level.WARN, "dimdungeons's " + roomName + " built at " + finalPosition.func_177958_n() + ", " + finalPosition.func_177956_o() + ", " + finalPosition.func_177952_p());
        return true;
    }

    protected static void handleDataBlock(String name, BlockPos pos, IWorld world, Random rand, MutableBoundingBox bb) {
        if ("LockIt".equals(name)) {
            DDDungeonFeature.LockDispensersAround(world, pos);
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        } else if ("LockItStoneBrick".equals(name)) {
            DDDungeonFeature.LockDispensersAround(world, pos);
            world.func_180501_a(pos, Blocks.field_196696_di.func_176223_P(), 2);
        } else if ("ReturnPortal".equals(name)) {
            DDDungeonFeature.LockDispensersAround(world, pos);
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        } else if ("FortuneTeller".equals(name)) {
            world.func_180501_a(pos, Blocks.field_196696_di.func_176223_P(), 2);
            DDDungeonFeature.faceContainerTowardsAir(world, pos.func_177977_b());
            DDDungeonFeature.LockDispensersAround(world, pos.func_177977_b());
        } else if ("ChestLoot1".equals(name)) {
            int lucky = rand.nextInt(100);
            if (lucky < 80) {
                DDDungeonFeature.fillChestBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_1"), world, rand);
            } else {
                DDDungeonFeature.fillChestBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_2"), world, rand);
            }
        } else if ("ChestLoot2".equals(name)) {
            DDDungeonFeature.fillChestBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_2"), world, rand);
        } else if ("ChestLootLucky".equals(name)) {
            int lucky = rand.nextInt(100);
            if (lucky < 30) {
                DDDungeonFeature.fillChestBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_lucky"), world, rand);
            } else {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                world.func_180501_a(pos.func_177977_b(), Blocks.field_150350_a.func_176223_P(), 2);
            }
        } else if ("SetTrappedLoot".equals(name)) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            ChestTileEntity te = (ChestTileEntity)world.func_175625_s(pos.func_177977_b());
            if (te != null) {
                te.func_174888_l();
                te.func_189404_a(new ResourceLocation("dimdungeons:chests/chestloot_1"), rand.nextLong());
            }
        } else if ("BarrelLoot1".equals(name)) {
            int lucky = rand.nextInt(100);
            if (lucky < 80) {
                DDDungeonFeature.fillBarrelBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_1"), world, rand);
            } else {
                DDDungeonFeature.fillBarrelBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_2"), world, rand);
            }
        } else if ("PlaceL2Key".equals(name)) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        } else if ("SummonWitch".equals(name)) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            DDDungeonFeature.spawnEnemyHere(pos, "witch", world);
        } else if ("SummonWaterEnemy".equals(name)) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            int chance = rand.nextInt(100);
            if (chance < 80) {
                DDDungeonFeature.spawnEnemyHere(pos, "guardian", world);
            } else {
                DDDungeonFeature.spawnEnemyHere(pos, "drowned", world);
            }
        } else if ("SummonEnderman".equals(name)) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            DDDungeonFeature.spawnEnemyHere(pos, "enderman", world);
        } else if ("SummonEnemy1".equals(name)) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            int chance = rand.nextInt(100);
            if (chance < 16) {
                DDDungeonFeature.spawnEnemyHere(pos, "zombie", world);
            } else if (chance < 32) {
                DDDungeonFeature.spawnEnemyHere(pos, "husk", world);
            } else if (chance < 48) {
                DDDungeonFeature.spawnEnemyHere(pos, "drowned", world);
            } else if (chance < 64) {
                DDDungeonFeature.spawnEnemyHere(pos, "spider", world);
            }
        } else if ("SummonEnemy2".equals(name)) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            int chance = rand.nextInt(100);
            if (chance < 20) {
                DDDungeonFeature.spawnEnemyHere(pos, "wither_skeleton", world);
            } else if (chance < 40) {
                DDDungeonFeature.spawnEnemyHere(pos, "stray", world);
            } else if (chance < 60) {
                DDDungeonFeature.spawnEnemyHere(pos, "skeleton", world);
            } else if (chance < 80) {
                DDDungeonFeature.spawnEnemyHere(pos, "pillager", world);
            }
        } else {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        }
    }

    private static void spawnEnemyHere(BlockPos pos, String casualName, IWorld world) {
        MobEntity mob = null;
        if ("witch".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200759_ay.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else if ("enderman".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200803_q.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 2), (double)pos.func_177952_p());
        } else if ("guardian".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200761_A.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else if ("zombie".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200725_aD.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else if ("husk".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200763_C.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else if ("drowned".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_204724_o.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else if ("skeleton".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200741_ag.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else if ("wither_skeleton".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200722_aA.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else if ("stray".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200750_ap.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else if ("spider".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200748_an.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else if ("pillager".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_220350_aJ.func_200721_a(world.func_201672_e());
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else {
            System.out.println("DungeonChunkGenerator: Attempting to spawn unrecognized enemy: " + casualName);
            return;
        }
        mob.func_98053_h(false);
        mob.func_200203_b((ITextComponent)new TranslationTextComponent("enemy.dimdungeons." + casualName, new Object[0]));
        mob.func_213390_a(pos, 8);
        mob.func_174828_a(pos, 0.0f, 0.0f);
        mob.func_110163_bv();
        mob.func_213386_a(world, world.func_175649_E(pos), SpawnReason.STRUCTURE, (ILivingEntityData)null, (CompoundNBT)null);
        world.func_217376_c((Entity)mob);
    }

    private static void fillChestBelow(BlockPos pos, ResourceLocation lootTable, IWorld world, Random rand) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        DDDungeonFeature.faceContainerTowardsAir(world, pos.func_177977_b());
        TileEntity te = world.func_175625_s(pos.func_177977_b());
        if (te instanceof ChestTileEntity) {
            ((ChestTileEntity)te).func_174888_l();
            ((ChestTileEntity)te).func_189404_a(lootTable, rand.nextLong());
        }
    }

    private static void fillBarrelBelow(BlockPos pos, ResourceLocation lootTable, IWorld world, Random rand) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        TileEntity te = world.func_175625_s(pos.func_177977_b());
        if (te instanceof BarrelTileEntity) {
            ((BarrelTileEntity)te).func_174888_l();
            ((BarrelTileEntity)te).func_189404_a(lootTable, rand.nextLong());
        }
    }

    private static void LockDispensersAround(IWorld world, BlockPos pos) {
    }

    private static void faceContainerTowardsAir(IWorld world, BlockPos pos) {
        BlockState bs = world.func_180495_p(pos);
        if (bs.func_177230_c() == Blocks.field_150367_z || bs.func_177230_c() == Blocks.field_150486_ae) {
            if (world.func_180495_p(pos.func_177978_c()).func_177230_c() == Blocks.field_150350_a) {
                // empty if block
            }
            if (world.func_180495_p(pos.func_177968_d()).func_177230_c() == Blocks.field_150350_a) {
                // empty if block
            }
            if (world.func_180495_p(pos.func_177976_e()).func_177230_c() == Blocks.field_150350_a) {
                // empty if block
            }
            if (world.func_180495_p(pos.func_177974_f()).func_177230_c() == Blocks.field_150350_a) {
                // empty if block
            }
            world.func_180501_a(pos, bs, 2);
        }
    }
}

