/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.worldblender.generation;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.LongFunction;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.telepathicgrunt.worldblender.biome.WBBiomes;
import net.telepathicgrunt.worldblender.generation.layer.QuadBiomeLayer;

public class WBBiomeProvider
extends BiomeProvider {
    private final Layer genBiomes;

    public WBBiomeProvider(long seed, WorldType worldType) {
        this.genBiomes = WBBiomeProvider.buildOverworldProcedure(seed, worldType);
    }

    public WBBiomeProvider(World world) {
        this(world.func_72905_C(), world.func_72912_H().func_76067_t());
        QuadBiomeLayer.setSeed(world.func_72905_C());
    }

    public static Layer buildOverworldProcedure(long seed, WorldType typeIn) {
        IAreaFactory layerArea = WBBiomeProvider.buildOverworldProcedure(typeIn, (long p_215737_2_) -> new LazyAreaLayerContext(25, seed, p_215737_2_));
        return new Layer(layerArea);
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> buildOverworldProcedure(WorldType worldTypeIn, LongFunction<C> contextFactory) {
        IAreaFactory layer = QuadBiomeLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)contextFactory.apply(200L));
        layer = ZoomLayer.FUZZY.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2000L), layer);
        layer = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1001L), layer);
        layer = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1002L), layer);
        return layer;
    }

    public Set<Biome> func_201538_a(int centerX, int centerZ, int sideLength) {
        int i = centerX - sideLength >> 2;
        int k = centerZ - sideLength >> 2;
        int l = centerX + sideLength >> 2;
        int j1 = centerZ + sideLength >> 2;
        int k1 = l - i + 1;
        int i2 = j1 - k + 1;
        HashSet set = Sets.newHashSet();
        Collections.addAll(set, this.genBiomes.func_202833_a(i, k, k1, i2));
        return set;
    }

    @Nullable
    public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
        int i = x - range >> 2;
        int j = z - range >> 2;
        int k = x + range >> 2;
        int l = z + range >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        Biome[] abiome = this.genBiomes.func_202833_a(i, j, i1, j1);
        BlockPos blockpos = null;
        int k1 = 0;
        for (int l1 = 0; l1 < i1 * j1; ++l1) {
            int i2 = i + l1 % i1 << 2;
            int j2 = j + l1 / i1 << 2;
            if (!biomes.contains(abiome[l1])) continue;
            if (blockpos == null || random.nextInt(k1 + 1) == 0) {
                blockpos = new BlockPos(i2, 0, j2);
            }
            ++k1;
        }
        return blockpos;
    }

    public boolean func_205004_a(Structure<?> structureIn) {
        return this.field_205005_a.computeIfAbsent(structureIn, structure -> {
            for (Biome biome : WBBiomes.biomes) {
                if (!biome.func_201858_a(structure)) continue;
                return true;
            }
            return false;
        });
    }

    public Set<BlockState> func_205706_b() {
        if (this.field_205707_b.isEmpty()) {
            for (Biome biome : WBBiomes.biomes) {
                this.field_205707_b.add(biome.func_203944_q().func_204108_a());
            }
        }
        return this.field_205707_b;
    }

    public Biome func_201545_a(int x, int y) {
        return this.genBiomes.func_215738_a(x, y);
    }

    public Biome[] func_201537_a(int x, int z, int width, int length, boolean cacheFlag) {
        return this.genBiomes.func_202833_a(x, z, width, length);
    }
}

