/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.worldblender.generation.layer;

import java.util.Random;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.layer.traits.IAreaTransformer0;
import net.telepathicgrunt.worldblender.biome.WBBiomes;

public enum QuadBiomeLayer implements IAreaTransformer0
{
    INSTANCE;

    private static final int BLENDED_BIOME_ID;
    private static final int MOUNTAINOUS_BLENDED_BIOME_ID;
    private static final int OCEAN_BLENDED_BIOME_ID;
    private static final int FROZEN_OCEAN_BLENDED_BIOME_ID;
    private static PerlinNoiseGenerator perlinGen;

    public int func_215735_a(INoiseRandom noise, int x, int z) {
        double perlinNoise = perlinGen.func_215464_a((double)x * 0.04, (double)z * 0.04, false);
        if (perlinNoise > 0.4) {
            return MOUNTAINOUS_BLENDED_BIOME_ID;
        }
        if (perlinNoise > -0.6) {
            return BLENDED_BIOME_ID;
        }
        return (double)noise.func_202696_a(100) / 800.0 + perlinNoise % 0.4 > -0.2 ? OCEAN_BLENDED_BIOME_ID : FROZEN_OCEAN_BLENDED_BIOME_ID;
    }

    public static void setSeed(long seed) {
        if (perlinGen == null) {
            SharedSeedRandom sharedseedrandom = new SharedSeedRandom(seed);
            perlinGen = new PerlinNoiseGenerator((Random)sharedseedrandom, 1);
        }
    }

    static {
        BLENDED_BIOME_ID = Registry.field_212624_m.func_148757_b((Object)WBBiomes.BLENDED_BIOME);
        MOUNTAINOUS_BLENDED_BIOME_ID = Registry.field_212624_m.func_148757_b((Object)WBBiomes.MOUNTAINOUS_BLENDED_BIOME);
        OCEAN_BLENDED_BIOME_ID = Registry.field_212624_m.func_148757_b((Object)WBBiomes.OCEAN_BLENDED_BIOME);
        FROZEN_OCEAN_BLENDED_BIOME_ID = Registry.field_212624_m.func_148757_b((Object)WBBiomes.FROZEN_OCEAN_BLENDED_BIOME);
    }
}

