/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.worldblender.networking;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.telepathicgrunt.worldblender.blocks.WBPortalTileEntity;

public class MessageHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel DEFAULT_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("world_blender", "networking"), () -> "1", "1"::equals, "1"::equals);

    public static void init() {
        int channelID = -1;
        DEFAULT_CHANNEL.registerMessage(++channelID, UpdateTECooldownPacket.class, UpdateTECooldownPacket::compose, UpdateTECooldownPacket::parse, UpdateTECooldownPacket.Handler::handle);
    }

    public static class UpdateTECooldownPacket {
        private float cooldown = 0.0f;
        private BlockPos pos = null;

        public static void sendToClient(BlockPos pos, float cooldown) {
            DEFAULT_CHANNEL.sendToServer((Object)new UpdateTECooldownPacket(pos, cooldown));
        }

        public UpdateTECooldownPacket(BlockPos pos, float cooldownIn) {
            this.pos = pos;
            this.cooldown = cooldownIn;
        }

        public static UpdateTECooldownPacket parse(PacketBuffer buf) {
            return new UpdateTECooldownPacket(buf.func_179259_c(), buf.readFloat());
        }

        public static void compose(UpdateTECooldownPacket pkt, PacketBuffer buf) {
            buf.func_179255_a(pkt.pos);
            buf.writeFloat(pkt.cooldown);
        }

        public static class Handler {
            public static void handle(UpdateTECooldownPacket pkt, Supplier<NetworkEvent.Context> ctx) {
                Minecraft.func_71410_x().func_213165_a(() -> {
                    WBPortalTileEntity te = (WBPortalTileEntity)Minecraft.func_71410_x().field_71441_e.func_175625_s(pkt.pos);
                    te.setCoolDown(pkt.cooldown);
                });
                ctx.get().setPacketHandled(true);
            }
        }
    }
}

