/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.worldblender.the_blender;

import java.util.Arrays;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.telepathicgrunt.worldblender.configs.WBConfig;

public class ConfigBlacklisting {
    private static List<String> blanketBL;
    private static List<String> featureBL;
    private static List<String> structureBL;
    private static List<String> carverBL;
    private static List<String> spawnBL;
    private static List<String> surfaceBL;

    public static void setupBlackLists() {
        blanketBL = ConfigBlacklisting.parseConfigAndAssignEntries(WBConfig.blanketBlacklist);
        featureBL = ConfigBlacklisting.parseConfigAndAssignEntries(WBConfig.blacklistedFeatures);
        structureBL = ConfigBlacklisting.parseConfigAndAssignEntries(WBConfig.blacklistedStructures);
        carverBL = ConfigBlacklisting.parseConfigAndAssignEntries(WBConfig.blacklistedCarvers);
        spawnBL = ConfigBlacklisting.parseConfigAndAssignEntries(WBConfig.blacklistedSpawns);
        surfaceBL = ConfigBlacklisting.parseConfigAndAssignEntries(WBConfig.blacklistedBiomeSurfaces);
    }

    private static List<String> parseConfigAndAssignEntries(String configEntry) {
        String[] entriesArray = configEntry.split(",");
        Arrays.parallelSetAll(entriesArray, i -> entriesArray[i].trim().toLowerCase().replace(' ', '_'));
        return Arrays.asList(entriesArray);
    }

    private static boolean matchFound(String blacklistedEntry, ResourceLocation resourceLocationToCheck) {
        if (resourceLocationToCheck == null || blacklistedEntry.isEmpty()) {
            return false;
        }
        if (blacklistedEntry.contains(":")) {
            return blacklistedEntry.equals(resourceLocationToCheck.toString());
        }
        if (blacklistedEntry.contains("*")) {
            return blacklistedEntry.substring(0, blacklistedEntry.length() - 1).equals(resourceLocationToCheck.func_110624_b().toString());
        }
        return resourceLocationToCheck.func_110623_a().toString().contains(blacklistedEntry);
    }

    public static boolean isBiomeNotAllowed(BlacklistType type, ResourceLocation biomeRL) {
        List<String> listToUse;
        switch (type) {
            case BLANKET: {
                listToUse = blanketBL;
                break;
            }
            case FEATURE: {
                listToUse = featureBL;
                break;
            }
            case STRUCTURE: {
                listToUse = structureBL;
                break;
            }
            case CARVER: {
                listToUse = carverBL;
                break;
            }
            case SPAWN: {
                listToUse = spawnBL;
                break;
            }
            case SURFACE_BLOCK: {
                listToUse = surfaceBL;
                break;
            }
            default: {
                return false;
            }
        }
        boolean isNotAllowed = listToUse.stream().anyMatch(banEntry -> ConfigBlacklisting.matchFound(banEntry, biomeRL));
        return isNotAllowed;
    }

    public static enum BlacklistType {
        BLANKET,
        FEATURE,
        STRUCTURE,
        CARVER,
        SPAWN,
        SURFACE_BLOCK;

    }
}

