/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.worldblender.the_blender;

import com.mojang.datafixers.types.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityClassification;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.MultipleWithChanceRandomFeatureConfig;
import net.minecraft.world.gen.feature.SingleRandomFeature;
import net.minecraft.world.gen.feature.TwoFeatureChoiceConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.registries.ForgeRegistries;
import net.telepathicgrunt.worldblender.biome.WBBiomes;
import net.telepathicgrunt.worldblender.biome.biomes.surfacebuilder.BlendedSurfaceBuilder;
import net.telepathicgrunt.worldblender.configs.WBConfig;
import net.telepathicgrunt.worldblender.the_blender.ConfigBlacklisting;
import net.telepathicgrunt.worldblender.the_blender.VanillaFeatureGrouping;

public class PerformBiomeBlending {
    private static List<ConfiguredFeature<?>> grassyFlowerList = new ArrayList();
    private static List<ConfiguredFeature<?>> bambooList = new ArrayList();

    public static void setupBiomes() {
        BlendedSurfaceBuilder.resetSurfaceList();
        grassyFlowerList = new ArrayList();
        bambooList = new ArrayList();
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            if (WBBiomes.biomes.contains(biome) || (!biome.getRegistryName().func_110624_b().equals("minecraft") ? !WBConfig.allowModdedBiomeImport : !WBConfig.allowVanillaBiomeImport) || ConfigBlacklisting.isBiomeNotAllowed(ConfigBlacklisting.BlacklistType.BLANKET, biome.getRegistryName())) continue;
            PerformBiomeBlending.addBiomeFeatures(biome, bambooList, grassyFlowerList);
            PerformBiomeBlending.addBiomeStructures(biome);
            PerformBiomeBlending.addBiomeCarvers(biome);
            PerformBiomeBlending.addBiomeNaturalMobs(biome);
            PerformBiomeBlending.addBiomeSurfaceConfig(biome);
        }
        for (ConfiguredFeature configuredFeature : grassyFlowerList) {
            if (WBBiomes.BLENDED_BIOME.func_203607_a(GenerationStage.Decoration.VEGETAL_DECORATION).stream().anyMatch(addedConfigFeature -> PerformBiomeBlending.serializeAndCompareFeature(addedConfigFeature, grassyFlowerFeature))) continue;
            WBBiomes.biomes.forEach(blendedBiome -> blendedBiome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, grassyFlowerFeature));
        }
        if (!WBConfig.disallowLaggyVanillaFeatures) {
            for (ConfiguredFeature configuredFeature : bambooList) {
                if (WBBiomes.BLENDED_BIOME.func_203607_a(GenerationStage.Decoration.VEGETAL_DECORATION).stream().anyMatch(addedConfigFeature -> PerformBiomeBlending.serializeAndCompareFeature(addedConfigFeature, bambooFeature))) continue;
                WBBiomes.biomes.forEach(blendedBiome -> blendedBiome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, bambooFeature));
            }
        }
    }

    private static void addBiomeFeatures(Biome biome, List<ConfiguredFeature<?>> bambooList, List<ConfiguredFeature<?>> grassyFlowerList) {
        for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
            List configuredFeatureList = biome.func_203607_a(stage);
            for (int i = 0; i < configuredFeatureList.size(); ++i) {
                ConfiguredFeature configuredFeature = (ConfiguredFeature)configuredFeatureList.get(i);
                if (WBBiomes.BLENDED_BIOME.func_203607_a(stage).stream().anyMatch(addedConfigFeature -> PerformBiomeBlending.serializeAndCompareFeature(addedConfigFeature, configuredFeature))) continue;
                if (configuredFeature.field_222738_b instanceof DecoratedFeatureConfig) {
                    ConfiguredFeature insideFeature = ((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a;
                    if (ConfigBlacklisting.isBiomeNotAllowed(ConfigBlacklisting.BlacklistType.FEATURE, insideFeature.field_222737_a.getRegistryName()) || insideFeature.field_222737_a == Feature.field_202291_ak && ((MultipleWithChanceRandomFeatureConfig)insideFeature.field_222738_b).field_202454_a.stream().anyMatch(buriedFeature -> ConfigBlacklisting.isBiomeNotAllowed(ConfigBlacklisting.BlacklistType.FEATURE, buriedFeature.field_222737_a.getRegistryName())) || insideFeature.field_222737_a == Feature.field_202292_al && ((MultipleRandomFeatureConfig)insideFeature.field_222738_b).field_202449_a.stream().anyMatch(buriedFeature -> ConfigBlacklisting.isBiomeNotAllowed(ConfigBlacklisting.BlacklistType.FEATURE, buriedFeature.field_214842_a.getRegistryName())) || insideFeature.field_222737_a == Feature.field_204620_ao && ((SingleRandomFeature)insideFeature.field_222738_b).field_204628_a.stream().anyMatch(buriedFeature -> ConfigBlacklisting.isBiomeNotAllowed(ConfigBlacklisting.BlacklistType.FEATURE, buriedFeature.field_222737_a.getRegistryName())) || insideFeature.field_222737_a == Feature.field_202293_am && (ConfigBlacklisting.isBiomeNotAllowed(ConfigBlacklisting.BlacklistType.FEATURE, ((TwoFeatureChoiceConfig)insideFeature.field_222738_b).field_202445_a.field_222737_a.getRegistryName()) || ConfigBlacklisting.isBiomeNotAllowed(ConfigBlacklisting.BlacklistType.FEATURE, ((TwoFeatureChoiceConfig)insideFeature.field_222738_b).field_202447_c.field_222737_a.getRegistryName()))) continue;
                }
                if (WBBiomes.VANILLA_TEMP_BIOME.func_203607_a(stage).stream().anyMatch(vanillaConfigFeature -> PerformBiomeBlending.serializeAndCompareFeature(vanillaConfigFeature, configuredFeature))) {
                    if (!((Boolean)WBConfig.SERVER.allowVanillaFeatures.get()).booleanValue()) continue;
                    if (configuredFeature.field_222738_b instanceof DecoratedFeatureConfig && (((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.field_222737_a == Feature.field_214520_L || ((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.field_222737_a == Feature.field_204620_ao || ((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.field_222737_a == Feature.field_202291_ak || ((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.field_222737_a == Feature.field_214519_I || ((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.field_222737_a == Feature.field_214484_aL)) {
                        grassyFlowerList.add(configuredFeature);
                        continue;
                    }
                    if (configuredFeature.field_222738_b instanceof DecoratedFeatureConfig && ((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.field_222737_a == Feature.field_214482_aJ) {
                        bambooList.add(configuredFeature);
                        continue;
                    }
                    if (WBConfig.disallowLaggyVanillaFeatures && VanillaFeatureGrouping.lavaAndFirefeatures.get(stage).stream().anyMatch(vanillaConfigFeature -> PerformBiomeBlending.serializeAndCompareFeature(vanillaConfigFeature, configuredFeature))) continue;
                    WBBiomes.biomes.forEach(blendedBiome -> blendedBiome.func_203611_a(stage, configuredFeature));
                    continue;
                }
                if (!((Boolean)WBConfig.SERVER.allowModdedFeatures.get()).booleanValue()) continue;
                if (configuredFeature.field_222738_b instanceof DecoratedFeatureConfig && (((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.field_222737_a == Feature.field_214520_L || ((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.field_222737_a == Feature.field_204620_ao || ((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.field_222737_a == Feature.field_202291_ak || ((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.field_222737_a == Feature.field_214519_I || ((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.field_222737_a == Feature.field_214484_aL)) {
                    grassyFlowerList.add(configuredFeature);
                    continue;
                }
                if (configuredFeature.field_222738_b instanceof DecoratedFeatureConfig && ((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.field_222737_a == Feature.field_214482_aJ) {
                    bambooList.add(configuredFeature);
                    continue;
                }
                if (stage == GenerationStage.Decoration.VEGETAL_DECORATION && (configuredFeature.field_222738_b instanceof DecoratedFeatureConfig && ((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.field_222737_a == Feature.field_202293_am || ((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.field_222737_a == Feature.field_202292_al)) {
                    WBBiomes.biomes.forEach(blendedBiome -> ((List)blendedBiome.field_201872_ah.get(stage)).add(0, configuredFeature));
                    continue;
                }
                WBBiomes.biomes.forEach(blendedBiome -> blendedBiome.func_203611_a(stage, configuredFeature));
            }
        }
    }

    private static void addBiomeStructures(Biome biome) {
        for (Structure structure : biome.field_201874_aj.keySet()) {
            if (WBBiomes.BLENDED_BIOME.field_201874_aj.keySet().stream().anyMatch(struct -> struct == structure) || ConfigBlacklisting.isBiomeNotAllowed(ConfigBlacklisting.BlacklistType.STRUCTURE, structure.getRegistryName())) continue;
            if (WBBiomes.VANILLA_TEMP_BIOME.field_201874_aj.keySet().stream().anyMatch(vanillaStructure -> vanillaStructure.getClass().equals(structure.getClass()))) {
                if (!((Boolean)WBConfig.SERVER.allowVanillaStructures.get()).booleanValue()) continue;
                WBBiomes.biomes.forEach(blendedBiome -> {
                    IFeatureConfig cfr_ignored_0 = (IFeatureConfig)blendedBiome.field_201874_aj.put(structure, biome.field_201874_aj.get(structure));
                });
                for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
                    for (ConfiguredFeature configuredFeature : biome.func_203607_a(stage)) {
                        if (!configuredFeature.field_222737_a.getClass().equals(((IFeatureConfig)biome.field_201874_aj.get(structure)).getClass())) continue;
                        WBBiomes.biomes.forEach(blendedBiome -> blendedBiome.func_203611_a(stage, configuredFeature));
                    }
                }
                continue;
            }
            if (!((Boolean)WBConfig.SERVER.allowModdedStructures.get()).booleanValue()) continue;
            WBBiomes.biomes.forEach(blendedBiome -> {
                IFeatureConfig cfr_ignored_0 = (IFeatureConfig)blendedBiome.field_201874_aj.put(structure, biome.field_201874_aj.get(structure));
            });
            for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
                for (ConfiguredFeature configuredFeature : biome.func_203607_a(stage)) {
                    if (!configuredFeature.field_222737_a.getClass().equals(((IFeatureConfig)biome.field_201874_aj.get(structure)).getClass())) continue;
                    WBBiomes.biomes.forEach(blendedBiome -> blendedBiome.func_203611_a(stage, configuredFeature));
                }
            }
        }
    }

    private static void addBiomeCarvers(Biome biome) {
        for (GenerationStage.Carving carverStage : GenerationStage.Carving.values()) {
            for (ConfiguredCarver carver : biome.func_203603_a(carverStage)) {
                if (ConfigBlacklisting.isBiomeNotAllowed(ConfigBlacklisting.BlacklistType.CARVER, carver.field_222732_a.getRegistryName()) || WBBiomes.BLENDED_BIOME.func_203603_a(carverStage).stream().anyMatch(config -> config.field_222732_a == carver.field_222732_a)) continue;
                if (carver.field_222732_a.getRegistryName() != null && carver.field_222732_a.getRegistryName().func_110624_b().equals("minecraft")) {
                    if (!((Boolean)WBConfig.SERVER.allowVanillaCarvers.get()).booleanValue()) continue;
                    WBBiomes.biomes.forEach(blendedBiome -> blendedBiome.func_203609_a(carverStage, carver));
                    continue;
                }
                if (!((Boolean)WBConfig.SERVER.allowModdedCarvers.get()).booleanValue()) continue;
                WBBiomes.biomes.forEach(blendedBiome -> blendedBiome.func_203609_a(carverStage, carver));
            }
        }
    }

    private static void addBiomeNaturalMobs(Biome biome) {
        for (EntityClassification entityClass : EntityClassification.values()) {
            for (Biome.SpawnListEntry spawnEntry : biome.func_76747_a(entityClass)) {
                if (ConfigBlacklisting.isBiomeNotAllowed(ConfigBlacklisting.BlacklistType.SPAWN, spawnEntry.field_200702_b.getRegistryName()) || WBBiomes.BLENDED_BIOME.func_76747_a(entityClass).stream().anyMatch(spawn -> spawn.field_200702_b == spawnEntry.field_200702_b)) continue;
                if (spawnEntry.field_200702_b.getRegistryName() != null && spawnEntry.field_200702_b.getRegistryName().func_110624_b().equals("minecraft")) {
                    if (!((Boolean)WBConfig.SERVER.allowVanillaSpawns.get()).booleanValue()) continue;
                    WBBiomes.biomes.forEach(blendedBiome -> blendedBiome.func_201866_a(entityClass, spawnEntry));
                    continue;
                }
                if (!((Boolean)WBConfig.SERVER.allowModdedSpawns.get()).booleanValue()) continue;
                WBBiomes.biomes.forEach(blendedBiome -> blendedBiome.func_201866_a(entityClass, spawnEntry));
            }
        }
    }

    private static void addBiomeSurfaceConfig(Biome biome) {
        if (biome.getRegistryName() != null && biome.getRegistryName().func_110624_b().equals("minecraft") ? (Boolean)WBConfig.SERVER.allowVanillaSurfaces.get() == false : (Boolean)WBConfig.SERVER.allowModdedSurfaces.get() == false) {
            return;
        }
        SurfaceBuilderConfig surfaceConfig = (SurfaceBuilderConfig)biome.func_203944_q();
        if (ConfigBlacklisting.isBiomeNotAllowed(ConfigBlacklisting.BlacklistType.SURFACE_BLOCK, surfaceConfig.func_204108_a().func_177230_c().getRegistryName())) {
            return;
        }
        if (!((BlendedSurfaceBuilder)WBBiomes.FEATURE_SURFACE_BUILDER).containsConfig(surfaceConfig)) {
            ((BlendedSurfaceBuilder)WBBiomes.FEATURE_SURFACE_BUILDER).addConfig(surfaceConfig);
        }
    }

    private static boolean serializeAndCompareFeature(ConfiguredFeature<?> feature1, ConfiguredFeature<?> feature2) {
        block3: {
            try {
                Map feature1Map = (Map)feature1.func_222735_a((DynamicOps)NBTDynamicOps.field_210820_a).getMapValues().get();
                Map feature2Map = (Map)feature2.func_222735_a((DynamicOps)NBTDynamicOps.field_210820_a).getMapValues().get();
                if (feature1Map != null && feature2Map != null) {
                    return feature1Map.equals(feature2Map);
                }
            }
            catch (Exception e) {
                if (!(feature1.field_222738_b instanceof DecoratedFeatureConfig) || !(feature2.field_222738_b instanceof DecoratedFeatureConfig) || ((DecoratedFeatureConfig)feature1.field_222738_b).field_214689_a.field_222737_a != ((DecoratedFeatureConfig)feature2.field_222738_b).field_214689_a.field_222737_a) break block3;
                return true;
            }
        }
        return false;
    }
}

