/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.worldblender.the_blender;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.telepathicgrunt.worldblender.WorldBlender;

public class ResourceLocationPrinting {
    public static void printAllResourceLocations() {
        try (PrintStream printStream = new PrintStream("resourceLocationDump.txt");){
            ResourceLocationPrinting.printOutSection(printStream, ForgeRegistries.BIOMES, "BIOMES", registryEdgeCases.OTHER);
            printStream.println("");
            ResourceLocationPrinting.printOutSection(printStream, ForgeRegistries.FEATURES, "FEATURES", registryEdgeCases.FEATURES);
            printStream.println("");
            ResourceLocationPrinting.printOutSection(printStream, ForgeRegistries.FEATURES, "STRUCTURES", registryEdgeCases.STRUCTURES);
            printStream.println("");
            ResourceLocationPrinting.printOutSection(printStream, ForgeRegistries.WORLD_CARVERS, "CARVERS", registryEdgeCases.OTHER);
            printStream.println("");
            ResourceLocationPrinting.printOutSection(printStream, ForgeRegistries.ENTITIES, "ENTITIES", registryEdgeCases.OTHER);
            printStream.println("");
            ResourceLocationPrinting.printOutSection(printStream, ForgeRegistries.BLOCKS, "BLOCKS", registryEdgeCases.OTHER);
        }
        catch (FileNotFoundException e) {
            WorldBlender.LOGGER.warn("FAILED TO CREATE AND WRITE TO resourceLocationDump.txt. SEE STACKTRACE AND SHOW IT TO MOD MAKER.");
            e.printStackTrace();
        }
    }

    private static <T extends IForgeRegistryEntry<T>> void printOutSection(PrintStream printStream, IForgeRegistry<T> registry, String section, registryEdgeCases registryCase) {
        String previousNameSpace = "minecraft";
        printStream.println("######################################################################");
        printStream.println("######      " + section + " RESOURCE LOCATION (IDs)        ######");
        printStream.println("");
        for (IForgeRegistryEntry forgeEntry : registry.getValues()) {
            if (registryCase != registryEdgeCases.FEATURES ? registryCase == registryEdgeCases.STRUCTURES && !(forgeEntry instanceof Structure) : forgeEntry instanceof Structure) continue;
            ResourceLocation forgeRL = ((ForgeRegistryEntry)forgeEntry).getRegistryName();
            if (forgeRL == null) continue;
            previousNameSpace = ResourceLocationPrinting.printSpacingBetweenMods(printStream, previousNameSpace, forgeRL.func_110624_b());
            printStream.println(forgeRL.toString());
        }
    }

    private static String printSpacingBetweenMods(PrintStream printStream, String previousModID, String currentModID) {
        if (!currentModID.isEmpty() && !previousModID.equals(currentModID)) {
            printStream.println("");
            return currentModID;
        }
        return previousModID;
    }

    private static enum registryEdgeCases {
        FEATURES,
        STRUCTURES,
        OTHER;

    }
}

