/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.client;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CanvasRenderer
implements AutoCloseable {
    private final TextureManager textureManager;
    private final Map<String, Instance> loadedCanvases = Maps.newHashMap();

    public CanvasRenderer(TextureManager textureManagerIn) {
        this.textureManager = textureManagerIn;
    }

    public void updateMapTexture(NBTTagCompound textureData) {
        this.getMapRendererInstance(textureData).updateCanvasTexture(textureData);
    }

    public void renderCanvas(NBTTagCompound textureData) {
        if (textureData != null && textureData.func_74764_b("name")) {
            this.getMapRendererInstance(textureData).render();
        }
    }

    private Instance getMapRendererInstance(NBTTagCompound textureData) {
        Instance instance = this.loadedCanvases.get(textureData.func_74779_i("name"));
        if (instance == null) {
            instance = new Instance(textureData);
            this.loadedCanvases.put(textureData.func_74779_i("name"), instance);
        } else {
            int currentVersion = textureData.func_74762_e("v");
            if (instance.version != currentVersion) {
                instance.updateCanvasTexture(textureData);
            }
        }
        return instance;
    }

    @Nullable
    public Instance getMapInstanceIfExists(String name) {
        return this.loadedCanvases.get(name);
    }

    public void clearLoadedMaps() {
        for (Instance instance : this.loadedCanvases.values()) {
            instance.close();
        }
        this.loadedCanvases.clear();
    }

    @Override
    public void close() {
        this.clearLoadedMaps();
    }

    @SideOnly(value=Side.CLIENT)
    class Instance
    implements AutoCloseable {
        int version = 0;
        private final DynamicTexture canvasTexture = new DynamicTexture(16, 16);
        private final ResourceLocation location;

        private Instance(NBTTagCompound canvasData) {
            this.location = CanvasRenderer.this.textureManager.func_110578_a("canvas/" + canvasData.func_74779_i("name"), this.canvasTexture);
            this.updateCanvasTexture(canvasData);
        }

        private void updateCanvasTexture(NBTTagCompound textureData) {
            this.version = textureData.func_74762_e("v");
            int[] pixels = textureData.func_74759_k("pixels");
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    int k = j + i * 16;
                    this.canvasTexture.func_110565_c()[k] = pixels[k];
                }
            }
            this.canvasTexture.func_110564_a();
        }

        public void render() {
            GlStateManager.func_179140_f();
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float f = 0.0078125f;
            GlStateManager.func_179152_a((float)f, (float)f, (float)f);
            GlStateManager.func_179109_b((float)-64.0f, (float)-64.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            CanvasRenderer.this.textureManager.func_110577_a(this.location);
            GlStateManager.func_179118_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_181662_b(0.0, 128.0, (double)-0.01f).func_187315_a(0.0, 1.0).func_181675_d();
            bufferbuilder.func_181662_b(128.0, 128.0, (double)-0.01f).func_187315_a(1.0, 1.0).func_181675_d();
            bufferbuilder.func_181662_b(128.0, 0.0, (double)-0.01f).func_187315_a(1.0, 0.0).func_181675_d();
            bufferbuilder.func_181662_b(0.0, 0.0, (double)-0.01f).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179141_d();
        }

        @Override
        public void close() {
        }
    }
}

