/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.client;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import xerca.xercapaint.client.BasePalette;
import xerca.xercapaint.common.CanvasType;
import xerca.xercapaint.common.PaletteUtil;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.packets.CanvasUpdatePacket;

@SideOnly(value=Side.CLIENT)
public class GuiCanvasEdit
extends BasePalette {
    private static final ResourceLocation noteGuiTextures = new ResourceLocation("xercapaint", "textures/gui/palette.png");
    private int canvasX = 240;
    private int canvasY = 40;
    private int canvasWidth;
    private int canvasHeight;
    private final int brushMeterX = 420;
    private final int brushMeterY = 120;
    private int canvasPixelScale;
    private int canvasPixelWidth;
    private int canvasPixelHeight;
    private int brushSize = 0;
    private boolean touchedCanvas = false;
    private boolean undoStarted = false;
    private final EntityPlayer editingPlayer;
    private CanvasType canvasType;
    private boolean isSigned = false;
    private int[] pixels;
    private String authorName = "";
    private String canvasTitle = "";
    private String name = "";
    private int version = 0;
    private static final Vec2f[] outlinePoss1 = new Vec2f[]{new Vec2f(0.0f, 199.0f), new Vec2f(12.0f, 199.0f), new Vec2f(34.0f, 199.0f), new Vec2f(76.0f, 199.0f)};
    private static final Vec2f[] outlinePoss2 = new Vec2f[]{new Vec2f(128.0f, 199.0f), new Vec2f(135.0f, 199.0f), new Vec2f(147.0f, 199.0f), new Vec2f(169.0f, 199.0f)};
    private static final int maxUndoLength = 16;
    private Deque<int[]> undoStack = new ArrayDeque<int[]>(16);

    protected GuiCanvasEdit(EntityPlayer player, NBTTagCompound canvasTag, NBTTagCompound paletteTag, ITextComponent title, CanvasType canvasType) {
        super(title, paletteTag);
        paletteX = 40;
        paletteY = 40;
        this.canvasType = canvasType;
        this.canvasPixelScale = canvasType == CanvasType.SMALL ? 10 : 5;
        this.canvasPixelWidth = CanvasType.getWidth(canvasType);
        this.canvasPixelHeight = CanvasType.getHeight(canvasType);
        int canvasPixelArea = this.canvasPixelHeight * this.canvasPixelWidth;
        this.canvasWidth = this.canvasPixelWidth * this.canvasPixelScale;
        this.canvasHeight = this.canvasPixelHeight * this.canvasPixelScale;
        if (canvasType.equals((Object)CanvasType.LONG)) {
            this.canvasY += 40;
        }
        this.editingPlayer = player;
        if (canvasTag != null && !canvasTag.func_82582_d()) {
            int[] nbtPixels = canvasTag.func_74759_k("pixels");
            this.authorName = canvasTag.func_74779_i("author");
            this.canvasTitle = canvasTag.func_74779_i("title");
            this.name = canvasTag.func_74779_i("name");
            this.version = canvasTag.func_74762_e("v");
            this.pixels = Arrays.copyOfRange(nbtPixels, 0, canvasPixelArea);
        } else {
            this.isSigned = false;
        }
        if (this.pixels == null) {
            this.pixels = new int[canvasPixelArea];
            Arrays.fill(this.pixels, basicColors[15].rgbVal());
            long secs = System.currentTimeMillis() / 1000L;
            this.name = "" + player.func_110124_au().toString() + "_" + secs;
        }
    }

    private int getPixelAt(int x, int y) {
        return this.pixels[y * this.canvasPixelWidth + x];
    }

    private void setPixelAt(int x, int y, PaletteUtil.Color color) {
        if (x >= 0 && y >= 0 && x < this.canvasPixelWidth && y < this.canvasPixelHeight) {
            this.pixels[y * this.canvasPixelWidth + x] = color.rgbVal();
        }
    }

    private void setPixelsAt(int mouseX, int mouseY, PaletteUtil.Color color, int brushSize) {
        int pixelHalf = this.canvasPixelScale / 2;
        switch (brushSize) {
            case 0: {
                int x = (mouseX - this.canvasX) / this.canvasPixelScale;
                int y = (mouseY - this.canvasY) / this.canvasPixelScale;
                this.setPixelAt(x, y, color);
                break;
            }
            case 1: {
                int x = (mouseX - this.canvasX + pixelHalf) / this.canvasPixelScale;
                int y = (mouseY - this.canvasY + pixelHalf) / this.canvasPixelScale;
                this.setPixelAt(x, y, color);
                this.setPixelAt(x - 1, y, color);
                this.setPixelAt(x, y - 1, color);
                this.setPixelAt(x - 1, y - 1, color);
                break;
            }
            case 2: {
                int x = (mouseX - this.canvasX + pixelHalf) / this.canvasPixelScale;
                int y = (mouseY - this.canvasY + pixelHalf) / this.canvasPixelScale;
                this.setPixelAt(x - 1, y + 2, color);
                this.setPixelAt(x, y + 2, color);
                this.setPixelAt(x - 2, y + 1, color);
                this.setPixelAt(x - 1, y + 1, color);
                this.setPixelAt(x, y + 1, color);
                this.setPixelAt(x + 1, y + 1, color);
                this.setPixelAt(x - 2, y, color);
                this.setPixelAt(x - 1, y, color);
                this.setPixelAt(x, y, color);
                this.setPixelAt(x + 1, y, color);
                this.setPixelAt(x - 1, y - 1, color);
                this.setPixelAt(x, y - 1, color);
                break;
            }
            case 3: {
                int x = (mouseX - this.canvasX) / this.canvasPixelScale;
                int y = (mouseY - this.canvasY) / this.canvasPixelScale;
                this.setPixelAt(x - 1, y + 2, color);
                this.setPixelAt(x + 0, y + 2, color);
                this.setPixelAt(x + 1, y + 2, color);
                this.setPixelAt(x - 2, y + 1, color);
                this.setPixelAt(x - 1, y + 1, color);
                this.setPixelAt(x + 0, y + 1, color);
                this.setPixelAt(x + 1, y + 1, color);
                this.setPixelAt(x + 2, y + 1, color);
                this.setPixelAt(x - 2, y, color);
                this.setPixelAt(x - 1, y, color);
                this.setPixelAt(x + 0, y, color);
                this.setPixelAt(x + 1, y, color);
                this.setPixelAt(x + 2, y, color);
                this.setPixelAt(x - 2, y - 1, color);
                this.setPixelAt(x - 1, y - 1, color);
                this.setPixelAt(x + 0, y - 1, color);
                this.setPixelAt(x + 1, y - 1, color);
                this.setPixelAt(x + 2, y - 1, color);
                this.setPixelAt(x - 1, y - 2, color);
                this.setPixelAt(x + 0, y - 2, color);
                this.setPixelAt(x + 1, y - 2, color);
            }
        }
    }

    public void func_73866_w_() {
        Mouse.setGrabbed((boolean)true);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float f) {
        int i;
        super.func_73863_a(mouseX, mouseY, f);
        for (i = 0; i < this.canvasPixelHeight; ++i) {
            for (int j = 0; j < this.canvasPixelWidth; ++j) {
                int y = this.canvasY + i * this.canvasPixelScale;
                int x = this.canvasX + j * this.canvasPixelScale;
                GuiCanvasEdit.func_73734_a((int)x, (int)y, (int)(x + this.canvasPixelScale), (int)(y + this.canvasPixelScale), (int)this.getPixelAt(j, i));
            }
        }
        for (i = 0; i < 4; ++i) {
            int y = 120 + i * 9;
            GuiCanvasEdit.func_73734_a((int)420, (int)y, (int)423, (int)(y + 3), (int)this.currentColor.rgbVal());
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(420, 120 + (3 - this.brushSize) * 9, 15, 246, 10, 10);
        this.func_73729_b(420, 120, 0, 220, 9, 36);
        this.renderCursor(mouseX, mouseY);
    }

    public static void setGLColor(PaletteUtil.Color c) {
        GlStateManager.func_179131_c((float)((float)c.r / 255.0f), (float)((float)c.g / 255.0f), (float)((float)c.b / 255.0f), (float)1.0f);
    }

    private void renderCursor(int mouseX, int mouseY) {
        if (this.isCarryingColor) {
            GuiCanvasEdit.setGLColor(this.carriedColor);
            this.func_73729_b(mouseX - 4, mouseY - 4, 9, 247, 6, 9);
        } else if (this.isCarryingWater) {
            GuiCanvasEdit.setGLColor(waterColor);
            this.func_73729_b(mouseX - 4, mouseY - 4, 9, 247, 6, 9);
        } else {
            if (this.inCanvas(mouseX, mouseY)) {
                int x = 0;
                int y = 0;
                int outlineSize = 0;
                int pixelHalf = this.canvasPixelScale / 2;
                if (this.brushSize == 0) {
                    x = (mouseX - this.canvasX) / this.canvasPixelScale * this.canvasPixelScale + this.canvasX - 1;
                    y = (mouseY - this.canvasY) / this.canvasPixelScale * this.canvasPixelScale + this.canvasY - 1;
                    outlineSize = this.canvasPixelScale + 2;
                }
                if (this.brushSize == 1) {
                    x = ((mouseX - this.canvasX + pixelHalf) / this.canvasPixelScale - 1) * this.canvasPixelScale + this.canvasX - 1;
                    y = ((mouseY - this.canvasY + pixelHalf) / this.canvasPixelScale - 1) * this.canvasPixelScale + this.canvasY - 1;
                    outlineSize = this.canvasPixelScale * 2 + 2;
                }
                if (this.brushSize == 2) {
                    x = ((mouseX - this.canvasX + pixelHalf) / this.canvasPixelScale - 2) * this.canvasPixelScale + this.canvasX - 1;
                    y = ((mouseY - this.canvasY + pixelHalf) / this.canvasPixelScale - 2) * this.canvasPixelScale + this.canvasY - 1;
                    outlineSize = this.canvasPixelScale * 4 + 2;
                }
                if (this.brushSize == 3) {
                    x = ((mouseX - this.canvasX) / this.canvasPixelScale - 2) * this.canvasPixelScale + this.canvasX - 1;
                    y = ((mouseY - this.canvasY) / this.canvasPixelScale - 2) * this.canvasPixelScale + this.canvasY - 1;
                    outlineSize = this.canvasPixelScale * 5 + 2;
                }
                Vec2f textureVec = this.canvasPixelScale == 10 ? outlinePoss1[this.brushSize] : outlinePoss2[this.brushSize];
                GlStateManager.func_179131_c((float)0.3f, (float)0.3f, (float)0.3f, (float)1.0f);
                this.func_73729_b(x, y, (int)textureVec.field_189982_i, (int)textureVec.field_189983_j, outlineSize, outlineSize);
            }
            GuiCanvasEdit.func_73734_a((int)mouseX, (int)mouseY, (int)(mouseX + 3), (int)(mouseY + 3), (int)this.currentColor.rgbVal());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int trueBrushY = 247 - 9 * this.brushSize;
            this.func_73729_b(mouseX, mouseY, 0, trueBrushY, 9, 9);
        }
    }

    public void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int wheelState = Mouse.getEventDWheel();
        if (wheelState != 0) {
            int maxBrushSize = 3;
            this.brushSize += wheelState > 0 ? 1 : -1;
            if (this.brushSize > 3) {
                this.brushSize = 0;
            } else if (this.brushSize < 0) {
                this.brushSize = 3;
            }
        }
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        int selectedSize;
        this.undoStarted = true;
        this.touchedCanvas = false;
        if (this.undoStack.size() >= 16) {
            this.undoStack.removeLast();
        }
        this.undoStack.push((int[])this.pixels.clone());
        if (this.inCanvas(mouseX, mouseY)) {
            this.touchedCanvas = true;
            this.setPixelsAt(mouseX, mouseY, this.currentColor, this.brushSize);
            this.dirty = true;
        }
        if (this.inBrushMeter(mouseX, mouseY) && (selectedSize = 3 - (mouseY - 120) / 9) >= 0) {
            this.brushSize = selectedSize;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    @Override
    public void func_146286_b(int posX, int posY, int mouseButton) {
        if (this.undoStarted && !this.touchedCanvas) {
            this.undoStarted = false;
            this.undoStack.removeFirst();
        }
        super.func_146286_b(posX, posY, mouseButton);
    }

    public void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.inCanvas(mouseX, mouseY)) {
            this.touchedCanvas = true;
            this.setPixelsAt(mouseX, mouseY, this.currentColor, this.brushSize);
            this.dirty = true;
        }
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    private boolean inCanvas(int x, int y) {
        return x < this.canvasX + this.canvasWidth && x >= this.canvasX && y < this.canvasY + this.canvasHeight && y >= this.canvasY;
    }

    private boolean inBrushMeter(int x, int y) {
        return x < 429 && x >= 420 && y < 156 && y >= 120;
    }

    public void func_146281_b() {
        if (this.dirty) {
            ++this.version;
            CanvasUpdatePacket pack = new CanvasUpdatePacket(this.pixels, this.isSigned, this.canvasTitle, this.name, this.version, this.customColors, this.canvasType);
            XercaPaint.network.sendToServer((IMessage)pack);
        }
    }
}

