/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemHangingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xerca.xercapaint.common.CanvasType;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.entity.EntityCanvas;
import xerca.xercapaint.common.item.Items;

public class ItemCanvas
extends ItemHangingEntity {
    private CanvasType canvasType;

    ItemCanvas(String name, CanvasType canvasType) {
        super(EntityCanvas.class);
        this.setRegistryName(name);
        this.func_77655_b(name);
        this.func_77637_a(Items.paintTab);
        this.func_77625_d(1);
        this.canvasType = canvasType;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        XercaPaint.proxy.showCanvasGui(playerIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(hand));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = player.func_184586_b(hand);
        BlockPos blockpos = pos.func_177972_a(facing);
        if (facing != EnumFacing.DOWN && facing != EnumFacing.UP && player.func_175151_a(blockpos, facing, itemstack)) {
            NBTTagCompound tag = itemstack.func_77978_p();
            if (tag == null || !tag.func_74764_b("pixels") || !tag.func_74764_b("name")) {
                return EnumActionResult.SUCCESS;
            }
            EntityCanvas entityCanvas = new EntityCanvas(worldIn, tag, blockpos, facing, this.canvasType);
            if (entityCanvas.func_70518_d()) {
                if (!worldIn.field_72995_K) {
                    entityCanvas.func_184523_o();
                    worldIn.func_72838_d((Entity)entityCanvas);
                }
                itemstack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public int getWidth() {
        return CanvasType.getWidth(this.canvasType);
    }

    public int getHeight() {
        return CanvasType.getHeight(this.canvasType);
    }

    public CanvasType getCanvasType() {
        return this.canvasType;
    }
}

