/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.item.crafting;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import javax.annotation.Nullable;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockPlanks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xerca.xercapaint.common.item.Items;

@MethodsReturnNonnullByDefault
public class RecipeCraftPalette
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private boolean isPlank(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)item;
            return itemBlock.func_179223_d() instanceof BlockPlanks;
        }
        return false;
    }

    private boolean isDye(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemDye;
    }

    private boolean isPlankRow(InventoryCrafting inv, int row) {
        int plankCount = 0;
        for (int j = 0; j < inv.func_174922_i(); ++j) {
            int id = row * inv.func_174922_i() + j;
            ItemStack stack = inv.func_70301_a(id);
            if (!this.isPlank(stack)) continue;
            ++plankCount;
        }
        return plankCount == 3;
    }

    private int findPlankRow(InventoryCrafting inv) {
        for (int i = 0; i < inv.func_174923_h(); ++i) {
            if (!this.isPlankRow(inv, i)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    private ArrayList<ItemStack> findDyes(InventoryCrafting inv, int plankRow) {
        ArrayList<ItemStack> dyes = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_174923_h(); ++i) {
            if (i == plankRow) continue;
            for (int j = 0; j < inv.func_174922_i(); ++j) {
                int id = i * inv.func_174922_i() + j;
                ItemStack stack = inv.func_70301_a(id);
                if (this.isDye(stack)) {
                    dyes.add(stack);
                    continue;
                }
                if (stack.func_190926_b()) continue;
                return null;
            }
        }
        return dyes;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        int plankRow = this.findPlankRow(inv);
        if (plankRow < 0) {
            return false;
        }
        ArrayList<ItemStack> dyes = this.findDyes(inv, plankRow);
        return dyes != null && !dyes.isEmpty();
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        int plankRow = this.findPlankRow(inv);
        if (plankRow < 0) {
            return ItemStack.field_190927_a;
        }
        ArrayList<ItemStack> dyes = this.findDyes(inv, plankRow);
        if (dyes == null || dyes.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        byte[] basicColors = new byte[16];
        for (ItemStack dye : dyes) {
            basicColors[dye.func_77960_j()] = 1;
        }
        ItemStack result = new ItemStack((Item)Items.ITEM_PALETTE);
        NBTTagCompound tag = result.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            result.func_77982_d(tag);
        }
        tag.func_74773_a("basic", basicColors);
        return result;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public boolean func_192399_d() {
        return true;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            return new RecipeCraftPalette();
        }
    }
}

