/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.item.crafting;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xerca.xercapaint.common.item.ItemPalette;
import xerca.xercapaint.common.item.Items;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RecipeFillPalette
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private boolean isPalette(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemPalette;
    }

    private boolean isDye(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemDye;
    }

    @Nullable
    private int findPalette(InventoryCrafting inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!this.isPalette(stack)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    private ArrayList<ItemStack> findDyes(InventoryCrafting inv, int paletteId) {
        ArrayList<ItemStack> dyes = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (i == paletteId) continue;
            ItemStack stack = inv.func_70301_a(i);
            if (this.isDye(stack)) {
                dyes.add(stack);
                continue;
            }
            if (stack.func_190926_b()) continue;
            return null;
        }
        return dyes;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        int paletteId = this.findPalette(inv);
        if (paletteId < 0) {
            return false;
        }
        ArrayList<ItemStack> dyes = this.findDyes(inv, paletteId);
        return dyes != null && !dyes.isEmpty();
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        NBTTagCompound orgTag;
        int paletteId = this.findPalette(inv);
        if (paletteId < 0) {
            return ItemStack.field_190927_a;
        }
        ArrayList<ItemStack> dyes = this.findDyes(inv, paletteId);
        if (dyes == null || dyes.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack inputPalette = inv.func_70301_a(paletteId);
        NBTTagCompound orgOldTag = inputPalette.func_77978_p();
        if (orgOldTag == null) {
            orgOldTag = new NBTTagCompound();
            inputPalette.func_77982_d(orgOldTag);
        }
        byte[] basicColors = (orgTag = orgOldTag.func_74737_b()).func_74764_b("basic") ? orgTag.func_74770_j("basic") : new byte[16];
        for (ItemStack dye : dyes) {
            int realColorId = dye.func_77960_j();
            if (basicColors[realColorId] > 0) {
                return ItemStack.field_190927_a;
            }
            basicColors[realColorId] = 1;
        }
        orgTag.func_74773_a("basic", basicColors);
        ItemStack result = new ItemStack((Item)Items.ITEM_PALETTE);
        result.func_77982_d(orgTag);
        return result;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean func_192399_d() {
        return true;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            return new RecipeFillPalette();
        }
    }
}

