/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.packets;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import xerca.xercapaint.common.CanvasType;
import xerca.xercapaint.common.PaletteUtil;

public class CanvasUpdatePacket
implements IMessage {
    private PaletteUtil.CustomColor[] paletteColors;
    private int[] pixels;
    private boolean signed;
    private String title;
    private CanvasType canvasType;
    private String name;
    private int version;
    private boolean messageIsValid;

    public CanvasUpdatePacket(int[] pixels, boolean signed, String title, String name, int version, PaletteUtil.CustomColor[] paletteColors, CanvasType canvasType) {
        this.paletteColors = Arrays.copyOfRange(paletteColors, 0, 12);
        this.signed = signed;
        this.title = title;
        this.name = name;
        this.version = version;
        this.canvasType = canvasType;
        int area = CanvasType.getHeight(canvasType) * CanvasType.getWidth(canvasType);
        this.pixels = Arrays.copyOfRange(pixels, 0, area);
    }

    public CanvasUpdatePacket() {
        this.messageIsValid = false;
    }

    public void toBytes(ByteBuf buf) {
        for (PaletteUtil.CustomColor color : this.paletteColors) {
            color.writeToBuffer(buf);
        }
        buf.writeByte(this.canvasType.ordinal());
        buf.writeInt(this.version);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.title);
        buf.writeBoolean(this.signed);
        for (int p : this.pixels) {
            buf.writeInt(p);
        }
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.paletteColors = new PaletteUtil.CustomColor[12];
            for (int i = 0; i < this.paletteColors.length; ++i) {
                this.paletteColors[i] = new PaletteUtil.CustomColor(buf);
            }
            this.canvasType = CanvasType.fromByte(buf.readByte());
            this.version = buf.readInt();
            this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.title = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.signed = buf.readBoolean();
            int area = CanvasType.getHeight(this.canvasType) * CanvasType.getWidth(this.canvasType);
            this.pixels = new int[area];
            for (int i = 0; i < area; ++i) {
                this.pixels[i] = buf.readInt();
            }
        }
        catch (IndexOutOfBoundsException ioe) {
            System.err.println("Exception while reading CanvasUpdatePacket: " + ioe);
            return;
        }
        this.messageIsValid = true;
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public PaletteUtil.CustomColor[] getPaletteColors() {
        return this.paletteColors;
    }

    public boolean getSigned() {
        return this.signed;
    }

    public String getTitle() {
        return this.title;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMessageValid() {
        return this.messageIsValid;
    }

    public int getVersion() {
        return this.version;
    }

    public CanvasType getCanvasType() {
        return this.canvasType;
    }
}

