/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.packets;

import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import xerca.xercapaint.common.PaletteUtil;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.item.ItemCanvas;
import xerca.xercapaint.common.item.Items;
import xerca.xercapaint.common.packets.CanvasUpdatePacket;

public class CanvasUpdatePacketHandler
implements IMessageHandler<CanvasUpdatePacket, IMessage> {
    public IMessage onMessage(CanvasUpdatePacket message, MessageContext ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return null;
        }
        EntityPlayerMP sendingPlayer = ctx.getServerHandler().field_147369_b;
        if (sendingPlayer == null) {
            System.err.println("EntityPlayerMP was null when CanvasUpdatePacket was received");
            return null;
        }
        WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
        mainThread.func_152344_a(() -> CanvasUpdatePacketHandler.processMessage(message, sendingPlayer));
        return null;
    }

    private static void processMessage(CanvasUpdatePacket msg, EntityPlayerMP pl) {
        ItemStack canvas = pl.func_184614_ca();
        ItemStack palette = pl.func_184592_cb();
        if (canvas.func_77973_b() == Items.ITEM_PALETTE) {
            ItemStack temp = canvas;
            canvas = palette;
            palette = temp;
        }
        if (!canvas.func_190926_b() && canvas.func_77973_b() instanceof ItemCanvas) {
            NBTTagCompound comp = canvas.func_77978_p();
            if (comp == null) {
                comp = new NBTTagCompound();
                canvas.func_77982_d(comp);
            }
            comp.func_74783_a("pixels", msg.getPixels());
            comp.func_74778_a("name", msg.getName());
            comp.func_74768_a("v", msg.getVersion());
            if (msg.getSigned()) {
                comp.func_74778_a("author", pl.func_70005_c_());
                comp.func_74778_a("title", msg.getTitle().trim());
            }
            if (!palette.func_190926_b() && palette.func_77973_b() == Items.ITEM_PALETTE) {
                NBTTagCompound paletteComp = palette.func_77978_p();
                PaletteUtil.writeCustomColorArrayToNBT(paletteComp, msg.getPaletteColors());
            }
            XercaPaint.LOGGER.debug("Handling canvas update: Name: " + msg.getName() + " V: " + msg.getVersion());
        }
    }
}

