/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.packets;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import xerca.xercapaint.common.PaletteUtil;

public class PaletteUpdatePacket
implements IMessage {
    private PaletteUtil.CustomColor[] paletteColors;
    private boolean messageIsValid;

    public PaletteUpdatePacket(PaletteUtil.CustomColor[] paletteColors) {
        this.paletteColors = Arrays.copyOfRange(paletteColors, 0, 12);
    }

    public PaletteUpdatePacket() {
        this.messageIsValid = false;
    }

    public PaletteUtil.CustomColor[] getPaletteColors() {
        return this.paletteColors;
    }

    public boolean isMessageValid() {
        return this.messageIsValid;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.paletteColors = new PaletteUtil.CustomColor[12];
            for (int i = 0; i < this.paletteColors.length; ++i) {
                this.paletteColors[i] = new PaletteUtil.CustomColor(buf);
            }
        }
        catch (IndexOutOfBoundsException ioe) {
            System.err.println("Exception while reading MusicUpdatePacket: " + ioe);
            return;
        }
        this.messageIsValid = true;
    }

    public void toBytes(ByteBuf buf) {
        for (PaletteUtil.CustomColor color : this.paletteColors) {
            color.writeToBuffer(buf);
        }
    }
}

