/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.client;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.entity.EntityCanvas;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
public class RenderEntityCanvas
extends EntityRenderer<EntityCanvas> {
    private static final ResourceLocation backLocation = new ResourceLocation("minecraft", "textures/block/birch_planks.png");
    private final TextureManager textureManager;
    private final Map<String, Instance> loadedCanvases = Maps.newHashMap();

    RenderEntityCanvas(EntityRendererManager renderManager) {
        super(renderManager);
        this.textureManager = Minecraft.func_71410_x().field_71446_o;
    }

    @Nullable
    public ResourceLocation getEntityTexture(EntityCanvas entity) {
        return this.getMapRendererInstance(entity).location;
    }

    public void render(EntityCanvas entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        CompoundNBT tag = entity.getCanvasNBT();
        if (tag != null && tag.func_74764_b("name")) {
            this.getMapRendererInstance(entity).render(entity, entityYaw, matrixStackIn, bufferIn, entity.func_174811_aO());
        }
        super.func_225623_a_((Entity)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    private Instance getMapRendererInstance(EntityCanvas canvas) {
        CompoundNBT textureData = canvas.getCanvasNBT();
        Instance instance = this.loadedCanvases.get(textureData.func_74779_i("name"));
        if (instance == null) {
            instance = new Instance(canvas);
            this.loadedCanvases.put(textureData.func_74779_i("name"), instance);
        } else {
            int currentVersion = textureData.func_74762_e("v");
            if (instance.version < currentVersion) {
                instance.updateCanvasTexture(textureData);
            }
        }
        return instance;
    }

    @Nullable
    public Instance getMapInstanceIfExists(String name) {
        return this.loadedCanvases.get(name);
    }

    public void clearLoadedMaps() {
        for (Instance instance : this.loadedCanvases.values()) {
            instance.close();
        }
        this.loadedCanvases.clear();
    }

    public void close() {
        this.clearLoadedMaps();
    }

    @OnlyIn(value=Dist.CLIENT)
    class Instance
    implements AutoCloseable {
        int version = 0;
        int width;
        int height;
        private final DynamicTexture canvasTexture;
        private final ResourceLocation location;

        private Instance(EntityCanvas canvas) {
            CompoundNBT tag = canvas.getCanvasNBT();
            this.width = canvas.func_82329_d();
            this.height = canvas.func_82330_g();
            this.canvasTexture = new DynamicTexture(this.width, this.height, true);
            this.location = RenderEntityCanvas.this.textureManager.func_110578_a("canvas/" + tag.func_74779_i("name"), this.canvasTexture);
            this.updateCanvasTexture(tag);
        }

        private int swapColor(int color) {
            int i = (color & 0xFF0000) >> 16;
            int j = (color & 0xFF00) >> 8;
            int k = color & 0xFF;
            return k << 16 | j << 8 | i;
        }

        private void updateCanvasTexture(CompoundNBT textureData) {
            this.version = textureData.func_74762_e("v");
            int[] pixels = textureData.func_74759_k("pixels");
            if (pixels.length < this.height * this.width) {
                XercaPaint.LOGGER.warn("Pixels array length (" + pixels.length + ") is smaller than canvas area (" + this.height * this.width + ")");
                return;
            }
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    int k = j + i * this.width;
                    this.canvasTexture.func_195414_e().func_195700_a(j, i, this.swapColor(pixels[k]));
                }
            }
            this.canvasTexture.func_110564_a();
        }

        public void render(EntityCanvas canvas, float yaw, MatrixStack ms, IRenderTypeBuffer buffer, Direction facing) {
            float wScale = (float)this.width / 16.0f;
            float hScale = (float)this.height / 16.0f;
            double x = canvas.func_226277_ct_();
            double y = canvas.func_226278_cu_();
            double z = canvas.func_226281_cx_();
            IVertexBuilder vb = buffer.getBuffer(RenderType.func_228634_a_((ResourceLocation)this.location));
            ms.func_227860_a_();
            float xOffset = facing.func_82601_c();
            float zOffset = facing.func_82599_e();
            float yOffset = -1.0f;
            ms.func_227861_a_((double)zOffset * 0.5 * (double)wScale, -0.5 * (double)hScale, (double)(-xOffset) * 0.5 * (double)wScale);
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - yaw));
            float f = 0.03125f;
            ms.func_227862_a_(f, f, f);
            RenderEntityCanvas.this.textureManager.func_110577_a(this.location);
            int lightmap = WorldRenderer.func_228421_a_((ILightReader)canvas.field_70170_p, (BlockPos)new BlockPos(x, y, z));
            Matrix4f m = ms.func_227866_c_().func_227870_a_();
            Matrix3f mn = ms.func_227866_c_().func_227872_b_();
            vb.func_227888_a_(m, 0.0f, 32.0f * hScale, -1.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(lightmap).func_227887_a_(mn, xOffset, 0.0f, zOffset).func_181675_d();
            vb.func_227888_a_(m, 32.0f * wScale, 32.0f * hScale, -1.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(lightmap).func_227887_a_(mn, xOffset, 0.0f, zOffset).func_181675_d();
            vb.func_227888_a_(m, 32.0f * wScale, 0.0f, -1.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(lightmap).func_227887_a_(mn, xOffset, 0.0f, zOffset).func_181675_d();
            vb.func_227888_a_(m, 0.0f, 0.0f, -1.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(lightmap).func_227887_a_(mn, xOffset, 0.0f, zOffset).func_181675_d();
            vb = buffer.getBuffer(RenderType.func_228634_a_((ResourceLocation)backLocation));
            float sideWidth = 0.0625f;
            RenderEntityCanvas.this.textureManager.func_110577_a(backLocation);
            this.addVertex(vb, m, mn, 0.0, 0.0, 1.0, 0.0f, 0.0f, lightmap, xOffset, 0.0f, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, 1.0, 1.0f, 0.0f, lightmap, xOffset, 0.0f, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, 1.0, 1.0f, 1.0f, lightmap, xOffset, 0.0f, zOffset);
            this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, 1.0, 0.0f, 1.0f, lightmap, xOffset, 0.0f, zOffset);
            this.addVertex(vb, m, mn, 0.0, 0.0, 1.0, 0.0625f, 0.0f, lightmap, xOffset, 0.0f, zOffset);
            this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, 1.0, 0.0625f, 1.0f, lightmap, xOffset, 0.0f, zOffset);
            this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, -1.0, 0.0f, 1.0f, lightmap, xOffset, 0.0f, zOffset);
            this.addVertex(vb, m, mn, 0.0, 0.0, -1.0, 0.0f, 0.0f, lightmap, xOffset, 0.0f, zOffset);
            this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, 1.0, 0.0f, 0.0f, lightmap, xOffset, 0.0f, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, 1.0, 1.0f, 0.0f, lightmap, xOffset, 0.0f, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, -1.0, 1.0f, 0.0625f, lightmap, xOffset, 0.0f, zOffset);
            this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, -1.0, 0.0f, 0.0625f, lightmap, xOffset, 0.0f, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, -1.0, 0.0f, 0.0f, lightmap, xOffset, 0.0f, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, -1.0, 0.0f, 1.0f, lightmap, xOffset, 0.0f, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, 1.0, 0.0625f, 1.0f, lightmap, xOffset, 0.0f, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, 1.0, 0.0625f, 0.0f, lightmap, xOffset, 0.0f, zOffset);
            this.addVertex(vb, m, mn, 0.0, 0.0, -1.0, 0.0f, 1.0f, lightmap, xOffset, 0.0f, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, -1.0, 1.0f, 1.0f, lightmap, xOffset, 0.0f, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, 1.0, 1.0f, 0.9375f, lightmap, xOffset, 0.0f, zOffset);
            this.addVertex(vb, m, mn, 0.0, 0.0, 1.0, 0.0f, 0.9375f, lightmap, xOffset, 0.0f, zOffset);
            ms.func_227865_b_();
        }

        private void addVertex(IVertexBuilder vb, Matrix4f m, Matrix3f mn, double x, double y, double z, float tx, float ty, int lightmap, float xOff, float yOff, float zOff) {
            vb.func_227888_a_(m, (float)x, (float)y, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(tx, ty).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(lightmap).func_227887_a_(mn, xOff, yOff, zOff).func_181675_d();
        }

        @Override
        public void close() {
            this.canvasTexture.close();
        }
    }

    public static class RenderEntityCanvasFactory
    implements IRenderFactory<EntityCanvas> {
        public EntityRenderer<? super EntityCanvas> createRenderFor(EntityRendererManager manager) {
            return new RenderEntityCanvas(manager);
        }
    }
}

