/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.entity;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import xerca.xercapaint.common.CanvasType;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.entity.Entities;
import xerca.xercapaint.common.item.Items;

public class EntityCanvas
extends HangingEntity
implements IEntityAdditionalSpawnData {
    private CompoundNBT canvasNBT;
    private int tickCounter1 = 0;
    private CanvasType canvasType;

    public EntityCanvas(World world, CompoundNBT canvasNBT, BlockPos pos, Direction facing, CanvasType canvasType) {
        super(Entities.CANVAS, world, pos);
        this.canvasNBT = canvasNBT;
        this.canvasType = canvasType;
        this.func_174859_a(facing);
    }

    public EntityCanvas(EntityType<EntityCanvas> entityCanvasEntityType, World world) {
        super(entityCanvasEntityType, world);
    }

    public EntityCanvas(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super(Entities.CANVAS, world);
    }

    public CompoundNBT getCanvasNBT() {
        return this.canvasNBT;
    }

    public int func_82329_d() {
        return CanvasType.getWidth(this.canvasType);
    }

    public int func_82330_g() {
        return CanvasType.getHeight(this.canvasType);
    }

    public void func_110128_b(@Nullable Entity brokenEntity) {
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            ItemStack canvasItem;
            this.func_184185_a(SoundEvents.field_187691_dJ, 1.0f, 1.0f);
            if (brokenEntity instanceof PlayerEntity) {
                PlayerEntity playerentity = (PlayerEntity)brokenEntity;
                if (playerentity.field_71075_bZ.field_75098_d) {
                    return;
                }
            }
            if (this.canvasType == CanvasType.SMALL) {
                canvasItem = new ItemStack((IItemProvider)Items.ITEM_CANVAS);
            } else if (this.canvasType == CanvasType.LARGE) {
                canvasItem = new ItemStack((IItemProvider)Items.ITEM_CANVAS_LARGE);
            } else if (this.canvasType == CanvasType.LONG) {
                canvasItem = new ItemStack((IItemProvider)Items.ITEM_CANVAS_LONG);
            } else if (this.canvasType == CanvasType.TALL) {
                canvasItem = new ItemStack((IItemProvider)Items.ITEM_CANVAS_TALL);
            } else {
                XercaPaint.LOGGER.error("Invalid canvas type");
                return;
            }
            canvasItem.func_77982_d(this.canvasNBT.func_74737_b());
            this.func_199701_a_(canvasItem);
        }
    }

    public void func_70071_h_() {
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        if (this.tickCounter1++ == 50 && !this.field_70170_p.field_72995_K) {
            this.tickCounter1 = 0;
            if (this.func_70089_S() && !this.func_70518_d()) {
                this.func_70106_y();
                this.func_110128_b(null);
            }
        }
    }

    public void func_184523_o() {
    }

    protected void func_174856_o() {
        if (this.canvasType != null) {
            super.func_174856_o();
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70037_a(CompoundNBT tagCompound) {
        this.canvasNBT = tagCompound.func_74775_l("canvas");
        this.canvasType = CanvasType.fromByte(tagCompound.func_74771_c("ctype"));
        super.func_70037_a(tagCompound);
    }

    public void func_213281_b(CompoundNBT tagCompound) {
        tagCompound.func_218657_a("canvas", (INBT)this.canvasNBT);
        tagCompound.func_74774_a("ctype", (byte)this.canvasType.ordinal());
        super.func_213281_b(tagCompound);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_150786_a(this.canvasNBT);
        buffer.writeInt(this.field_174860_b.func_176745_a());
        buffer.writeByte(this.canvasType.ordinal());
        buffer.func_179255_a(this.field_174861_a);
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.canvasNBT = buffer.func_150793_b();
        this.field_174860_b = Direction.func_82600_a((int)buffer.readInt());
        this.canvasType = CanvasType.fromByte(buffer.readByte());
        this.field_174861_a = buffer.func_179259_c();
        this.func_174859_a(this.field_174860_b);
    }
}

