/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.item;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.HangingEntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.lwjgl.system.NonnullDefault;
import xerca.xercapaint.common.CanvasType;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.entity.Entities;
import xerca.xercapaint.common.entity.EntityCanvas;
import xerca.xercapaint.common.item.Items;

@NonnullDefault
public class ItemCanvas
extends HangingEntityItem {
    private CanvasType canvasType;

    ItemCanvas(String name, CanvasType canvasType) {
        super(Entities.CANVAS, new Item.Properties().func_200916_a((ItemGroup)Items.paintTab).func_200917_a(1));
        this.setRegistryName(name);
        this.canvasType = canvasType;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @Nonnull Hand hand) {
        XercaPaint.proxy.showCanvasGui(playerIn);
        return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(hand));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        Direction direction = context.func_196000_l();
        BlockPos pos = blockpos.func_177972_a(direction);
        PlayerEntity playerentity = context.func_195999_j();
        ItemStack itemstack = context.func_195996_i();
        if (playerentity != null && !this.func_200127_a(playerentity, direction, itemstack, pos)) {
            return ActionResultType.FAIL;
        }
        World world = context.func_195991_k();
        CompoundNBT tag = itemstack.func_77978_p();
        if (tag == null || !tag.func_74764_b("pixels") || !tag.func_74764_b("name")) {
            return ActionResultType.SUCCESS;
        }
        EntityCanvas entityCanvas = new EntityCanvas(world, tag, pos, direction, this.canvasType);
        if (entityCanvas.func_70518_d()) {
            if (!world.field_72995_K) {
                entityCanvas.func_184523_o();
                world.func_217376_c((Entity)entityCanvas);
            }
            itemstack.func_190918_g(1);
        }
        return ActionResultType.SUCCESS;
    }

    public int getWidth() {
        return CanvasType.getWidth(this.canvasType);
    }

    public int getHeight() {
        return CanvasType.getHeight(this.canvasType);
    }

    public CanvasType getCanvasType() {
        return this.canvasType;
    }
}

