/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.packets;

import java.util.Arrays;
import net.minecraft.network.PacketBuffer;
import xerca.xercapaint.common.PaletteUtil;

public class PaletteUpdatePacket {
    private PaletteUtil.CustomColor[] paletteColors;
    private boolean messageIsValid;

    public PaletteUpdatePacket(PaletteUtil.CustomColor[] paletteColors) {
        this.paletteColors = Arrays.copyOfRange(paletteColors, 0, 12);
    }

    public PaletteUpdatePacket() {
        this.messageIsValid = false;
    }

    public static void encode(PaletteUpdatePacket pkt, PacketBuffer buf) {
        for (PaletteUtil.CustomColor color : pkt.paletteColors) {
            color.writeToBuffer(buf);
        }
    }

    public static PaletteUpdatePacket decode(PacketBuffer buf) {
        PaletteUpdatePacket result = new PaletteUpdatePacket();
        try {
            result.paletteColors = new PaletteUtil.CustomColor[12];
            for (int i = 0; i < result.paletteColors.length; ++i) {
                result.paletteColors[i] = new PaletteUtil.CustomColor(buf);
            }
        }
        catch (IndexOutOfBoundsException ioe) {
            System.err.println("Exception while reading MusicUpdatePacket: " + ioe);
            return null;
        }
        result.messageIsValid = true;
        return result;
    }

    public PaletteUtil.CustomColor[] getPaletteColors() {
        return this.paletteColors;
    }

    public boolean isMessageValid() {
        return this.messageIsValid;
    }
}

