/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.packets;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fml.network.NetworkEvent;
import xerca.xercapaint.common.PaletteUtil;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.item.ItemCanvas;
import xerca.xercapaint.common.item.Items;
import xerca.xercapaint.common.packets.CanvasUpdatePacket;

public class CanvasUpdatePacketHandler {
    public static void handle(CanvasUpdatePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            System.err.println("EntityPlayerMP was null when CanvasUpdatePacket was received");
            return;
        }
        ctx.get().enqueueWork(() -> CanvasUpdatePacketHandler.processMessage(message, sendingPlayer));
        ctx.get().setPacketHandled(true);
    }

    private static void processMessage(CanvasUpdatePacket msg, ServerPlayerEntity pl) {
        ItemStack canvas = pl.func_184614_ca();
        ItemStack palette = pl.func_184592_cb();
        if (canvas.func_77973_b() == Items.ITEM_PALETTE) {
            ItemStack temp = canvas;
            canvas = palette;
            palette = temp;
        }
        if (!canvas.func_190926_b() && canvas.func_77973_b() instanceof ItemCanvas) {
            CompoundNBT comp = canvas.func_196082_o();
            comp.func_74783_a("pixels", msg.getPixels());
            comp.func_74778_a("name", msg.getName());
            comp.func_74768_a("v", msg.getVersion());
            comp.func_74768_a("generation", 0);
            if (msg.getSigned()) {
                comp.func_74778_a("author", pl.func_200200_C_().getString());
                comp.func_74778_a("title", msg.getTitle().trim());
                comp.func_74768_a("generation", 1);
            }
            if (!palette.func_190926_b() && palette.func_77973_b() == Items.ITEM_PALETTE) {
                CompoundNBT paletteComp = palette.func_196082_o();
                PaletteUtil.writeCustomColorArrayToNBT(paletteComp, msg.getPaletteColors());
            }
            XercaPaint.LOGGER.debug("Handling canvas update: Name: " + msg.getName() + " V: " + msg.getVersion());
        }
    }
}

