/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zawamod.VersionChecker;
import org.zawamod.ZAWAAddon;
import org.zawamod.ZAWAAddonHandler;
import org.zawamod.entity.base.ZAWABaseLand;
import org.zawamod.init.blocks.ZAWABlocks;
import org.zawamod.init.items.ZAWAItems;
import org.zawamod.init.items.type.ItemZAWASpawnEgg;
import org.zawamod.init.items.type.ItemZAWAVial;
import org.zawamod.proxy.CommonProxy;
import scala.util.Random;

@Mod(modid="zawa", name="Zoo and Wild Animals", version="1.8-1.0.0", dependencies="required-before:moon-core@[dev-6.1,);", acceptedMinecraftVersions="[1.8]")
public class ZAWAMain {
    public static VersionChecker versionChecker = new VersionChecker();
    public static boolean haveWarnedVersionOutOfDate = false;
    public static final DamageSource electricFence = new DamageSource("elecfence").func_76348_h();
    public static final DamageSource depression = new DamageSource("depression").func_76348_h();
    public static final Logger logger = LogManager.getLogger((String)"zawa");
    private static ZAWAAddon mod = new ZAWAAddon("zawa");
    @SidedProxy(serverSide="org.zawamod.proxy.CommonProxy", clientSide="org.zawamod.proxy.ClientProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="zawa")
    public static ZAWAMain instance;
    public static final CreativeTabs zawaTabItems;
    public static final CreativeTabs zawaTabDrops;
    public static final CreativeTabs zawaTabDecor;
    public static final CreativeTabs zawaTabPlants;
    public static final CreativeTabs zawaTabEntity;
    public static final CreativeTabs zawaTabBreeding;

    public static void addAnimal(Class<? extends ZAWABaseLand> animal) {
        mod.addAnimalToAddon(animal);
    }

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        ZAWAAddon mc = new ZAWAAddon("minecraft");
        mc.setModelPath("net.minecraft.client.model");
        mc.setRenderPath("net.minecraft.client.renderer.entity");
        mod.setModelPath("org.zawamod.client.model");
        mod.setRenderPath("org.zawamod.client.render");
        ZAWAAddonHandler.addMod(mc);
        ZAWAAddonHandler.addMod(mod);
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        proxy.init(event);
        proxy.registerRenders();
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    static {
        zawaTabItems = new CreativeTabs("zawa_tab_items"){

            public Item func_78016_d() {
                return ZAWAItems.bear_kibble;
            }
        };
        zawaTabDrops = new CreativeTabs("zawa_tab_drops"){

            public Item func_78016_d() {
                return ZAWAItems.fur;
            }
        };
        zawaTabDecor = new CreativeTabs("zawa_tab_decor"){

            public Item func_78016_d() {
                return Item.func_150898_a((Block)ZAWABlocks.bamboo_decortation);
            }
        };
        zawaTabPlants = new CreativeTabs("zawa_tab_plants"){

            public Item func_78016_d() {
                return Item.func_150898_a((Block)ZAWABlocks.staghorn_coral);
            }
        };
        zawaTabEntity = new CreativeTabs("zawa_tab_entity"){

            public Item func_78016_d() {
                ArrayList<Item> item = new ArrayList<Item>();
                for (int i = 0; i < CommonProxy.registeredItems.size(); ++i) {
                    if (!(CommonProxy.registeredItems.get(i) instanceof ItemZAWASpawnEgg)) continue;
                    item.add(CommonProxy.registeredItems.get(i));
                }
                Random rand = new Random();
                int sp = rand.nextInt(item.size());
                return (Item)item.get(sp);
            }
        };
        zawaTabBreeding = new CreativeTabs("zawa_tab_breeding"){

            public Item func_78016_d() {
                ArrayList<Item> item = new ArrayList<Item>();
                for (int i = 0; i < CommonProxy.registeredItems.size(); ++i) {
                    if (!(CommonProxy.registeredItems.get(i) instanceof ItemZAWAVial)) continue;
                    item.add(CommonProxy.registeredItems.get(i));
                }
                Random rand = new Random();
                int sp = rand.nextInt(item.size());
                return (Item)item.get(sp);
            }
        };
    }
}

