/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.base;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.zawamod.ZAWAConfig;
import org.zawamod.ZAWAMain;
import org.zawamod.entity.ai.EntityAINearestAttackableTargetTry;
import org.zawamod.entity.base.ZAWAEnrichmentToy;
import org.zawamod.entity.data.AnimalData;
import org.zawamod.entity.data.EntityDisplayData;
import org.zawamod.entity.data.Gender;
import org.zawamod.gui.type.GuiAnimalData;
import org.zawamod.gui.type.inventory.animal.InventoryAnimal;
import org.zawamod.init.achieve.ZAWAAchievement;
import org.zawamod.init.blocks.ZAWABlocks;
import org.zawamod.init.blocks.type.ZAWAEnrichmentBlock;
import org.zawamod.init.blocks.type.te.foodbarrel.TileEntityFeeder;
import org.zawamod.init.items.ZAWAItems;
import org.zawamod.init.items.type.ZAWAEnrichmentItem;
import org.zawamod.proxy.CommonProxy;
import org.zawamod.util.ZAWARandom;
import org.zawamod.util.ZAWAUtils;

public abstract class ZAWABaseLand
extends EntityAnimal {
    protected AIFight AIFight = new AIFight();
    protected EntityAINearestAttackableTargetTry AINearAtt = new EntityAINearestAttackableTargetTry((EntityCreature)this, EntityPlayer.class, true);
    private boolean needFood = false;
    private double defaultSpeed = 0.0;
    private boolean isSleeping = false;
    private static List<EntityDisplayData> displayData = new ArrayList<EntityDisplayData>();
    protected EntityAIWander wanderAI = new EntityAIWander((EntityCreature)this, 0.7);
    protected AIFight AIFightA = new AIFight();
    protected EntityAINearestAttackableTargetTry AINearAttA = new EntityAINearestAttackableTargetTry((EntityCreature)this, ZAWAEnrichmentToy.class, true);
    public InventoryAnimal animalInv;
    private int[] particle = new int[0];
    private ZAWARandom rando = new ZAWARandom();
    private int socialCount = 0;

    public ZAWABaseLand(World worldIn, double defaultSpeed, boolean held) {
        super(worldIn);
        this.defaultSpeed = defaultSpeed;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.wanderAI);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.9, 32.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.animalInv = new InventoryAnimal(9);
        if (!this.getOriginSpawn()) {
            if (this.rando.nextByte((byte)20) == 4) {
                this.func_70873_a(-24000);
            }
            if (ZAWAConfig.hasVarients) {
                this.setAnimalType(this.func_70681_au().nextInt(this.setVarients()));
                this.onVarientSet();
            } else {
                this.setAnimalType(1);
            }
            if (this.sexualDimorphism()) {
                this.setGender(ZAWAUtils.getGenderFromValue(this.func_70681_au().nextInt(2)));
            }
            if (!this.func_70631_g_()) {
                this.setAnimalTrait(ZAWAUtils.getTraitFromValue(this.func_70681_au().nextInt(AnimalData.Traits.values().length)));
            } else {
                this.setAnimalTrait(AnimalData.Traits.NONE);
            }
        }
        this.setOriginSpawn(true);
    }

    public boolean isTransportable() {
        return true;
    }

    public boolean hasAccessableInventory() {
        return false;
    }

    public boolean socialInteraction() {
        return true;
    }

    public ZAWABaseLand(World worldIn, double defaultSpeed) {
        this(worldIn, defaultSpeed, false);
    }

    public List<EntityDisplayData> bookData() {
        try {
            return displayData;
        }
        catch (Exception e) {
            ZAWAMain.logger.error("ZAWA Failed to setup extra entity data with the given data! Contact the addon developer BEFORE the ZAWA developers : single");
            return null;
        }
    }

    public static void setBookData(EntityDisplayData ... data) {
        try {
            for (EntityDisplayData d : data) {
                displayData.add(d);
            }
        }
        catch (Exception e) {
            ZAWAMain.logger.error("ZAWA Failed to setup extra entity data with the given data! Contact the addon developer BEFORE the ZAWA developers : global");
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)this.field_70130_N * 0.009);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.24f);
    }

    public EntityLivingBase getOwnerEntity() {
        try {
            UUID uuid = UUID.fromString(this.getOwnerId());
            return uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("showDeathMessages") && this.getOwnerEntity() instanceof EntityPlayerMP) {
            if (this.func_145818_k_()) {
                ((EntityPlayerMP)this.getOwnerEntity()).func_145747_a(this.func_110142_aN().func_151521_b());
            } else {
                ((EntityPlayerMP)this.getOwnerEntity()).func_145747_a((IChatComponent)new ChatComponentText("Your " + this.func_110142_aN().func_151521_b().func_150254_d()));
            }
        }
        super.func_70645_a(cause);
    }

    public boolean sexualDimorphism() {
        return false;
    }

    public void onVarientSet() {
    }

    public void setMaxFood(double maxFood) {
        this.getEntityData().func_74780_a("MaxFood", maxFood);
    }

    public double getMaxFood() {
        return this.getEntityData().func_74769_h("MaxFood");
    }

    public void setCurrFood(double currFood) {
        this.getEntityData().func_74780_a("CurrFood", currFood);
    }

    public double getCurrFood() {
        return this.getEntityData().func_74769_h("CurrFood");
    }

    public void setMaxEnrichment(double e) {
        this.getEntityData().func_74780_a("MaxEnrichment", e);
    }

    public double getMaxEnrichment() {
        return this.getEntityData().func_74769_h("MaxEnrichment");
    }

    public void setChested(boolean e) {
        this.getEntityData().func_74757_a("Chested", e);
    }

    public boolean isChested() {
        return this.getEntityData().func_74767_n("Chested");
    }

    public void setOriginSpawn(boolean e) {
        this.getEntityData().func_74757_a("Spawn", e);
    }

    public boolean getOriginSpawn() {
        return this.getEntityData().func_74767_n("Spawn");
    }

    public void setEnrichment(double e) {
        this.getEntityData().func_74780_a("Enrichment", e);
    }

    public double getEnrichment() {
        return this.getEntityData().func_74769_h("Enrichment");
    }

    public boolean getNeedsFood() {
        return this.needFood;
    }

    public static ItemStack getStatItem() {
        return new ItemStack(ZAWAItems.data_book, 1);
    }

    public abstract ItemStack setVial();

    public abstract ItemStack setTameItem();

    public abstract int setVarients();

    public void onTame(EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            --player.field_71071_by.func_70448_g().field_77994_a;
        }
        this.playTameEffect();
        player.func_71029_a((StatBase)ZAWAAchievement.achievementTame);
        this.setZooAnimal(true);
        this.setOwnerId(player.func_110124_au().toString());
        this.field_70714_bg.func_85156_a((EntityAIBase)this.AIFight);
        this.field_70715_bh.func_85156_a((EntityAIBase)this.AINearAtt);
        if (this.setNature() == AnimalData.EnumNature.AGGRESSIVE) {
            player.func_71029_a((StatBase)ZAWAAchievement.achievementRiskTame);
        }
        this.playTameEffect();
    }

    public void onFed(EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            --player.field_71071_by.func_70448_g().field_77994_a;
        }
    }

    public void onBreedAttempt(EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            --player.field_71071_by.func_70448_g().field_77994_a;
        }
    }

    public boolean canBeHeld() {
        return this.func_70047_e() <= 1.0f || this.func_70631_g_();
    }

    public int getAnimalType() {
        return this.field_70180_af.func_75683_a(24);
    }

    public void setAnimalType(int animalType) {
        this.field_70180_af.func_75692_b(24, (Object)((byte)animalType));
    }

    public void setAnimalType(byte animalType) {
        this.field_70180_af.func_75692_b(24, (Object)animalType);
    }

    public AnimalData.Traits getTrait() {
        return ZAWAUtils.getTraitFromValue(this.field_70180_af.func_75683_a(25));
    }

    public void setAnimalTrait(AnimalData.Traits trait) {
        this.field_70180_af.func_75692_b(25, (Object)((byte)trait.getID()));
    }

    public abstract AnimalData.EnumNature setNature();

    public String getOwnerId() {
        return this.field_70180_af.func_75681_e(17);
    }

    public void setOwnerId(String ownerUuid) {
        this.field_70180_af.func_75692_b(17, (Object)ownerUuid);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(29, (Object)0);
        this.field_70180_af.func_75682_a(24, (Object)0);
        this.field_70180_af.func_75682_a(31, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)"");
        this.field_70180_af.func_75682_a(25, (Object)0);
        this.setCurrFood(20.0);
        this.setMaxFood(20.0);
        this.setEnrichment(20.0);
        this.setMaxEnrichment(20.0);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("ZooAnimal", this.getIsZooAnimal());
        tagCompound.func_74768_a("Varient", this.getAnimalType());
        tagCompound.func_74778_a("Owner", this.getOwnerId());
        tagCompound.func_74780_a("CurrHunger", this.getCurrFood());
        tagCompound.func_74780_a("MaxFood", this.getMaxFood());
        tagCompound.func_74780_a("MaxEnrichment", this.getMaxEnrichment());
        tagCompound.func_74780_a("Enrichment", this.getEnrichment());
        tagCompound.func_74768_a("Gender", this.getGender().getValue());
        tagCompound.func_74768_a("Trait", this.getTrait().getID());
        tagCompound.func_74757_a("Spawned", this.getOriginSpawn());
        tagCompound.func_74757_a("Chested", this.isChested());
        for (EntityDisplayData d : displayData) {
            d.writeNBT(tagCompound);
        }
        this.animalInv.saveInventoryToNBT(tagCompound);
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        this.setAnimalType(tagCompound.func_74762_e("Varient"));
        this.setZooAnimal(tagCompound.func_74767_n("ZooAnimal"));
        this.setOwnerId(tagCompound.func_74779_i("Owner"));
        this.setCurrFood(tagCompound.func_74769_h("CurrHunger"));
        this.setMaxFood(tagCompound.func_74769_h("MaxFood"));
        this.setEnrichment(tagCompound.func_74769_h("Enrichment"));
        this.setMaxEnrichment(tagCompound.func_74769_h("MaxEnrichment"));
        this.setGender(ZAWAUtils.getGenderFromValue(tagCompound.func_74762_e("Gender")));
        this.setAnimalTrait(ZAWAUtils.getTraitFromValue(tagCompound.func_74762_e("Trait")));
        this.setOriginSpawn(tagCompound.func_74767_n("Spawned"));
        this.setChested(tagCompound.func_74767_n("Chested"));
        for (EntityDisplayData d : displayData) {
            d.readNBT(tagCompound);
        }
        int NBT_TYPE_COMPOUND = 10;
        NBTTagList dataForAllSlots = tagCompound.func_150295_c("Items", 10);
        this.animalInv.loadInventoryFromNBT(dataForAllSlots);
    }

    public Gender getGender() {
        return ZAWAUtils.getGenderFromValue(this.field_70180_af.func_75683_a(31));
    }

    public void setGender(Gender g) {
        this.field_70180_af.func_75692_b(31, (Object)((byte)g.getValue()));
    }

    public boolean getIsZooAnimal() {
        return this.field_70180_af.func_75683_a(29) != 0;
    }

    public void setZooAnimal(boolean f) {
        if (f) {
            this.field_70180_af.func_75692_b(29, (Object)1);
        } else {
            this.field_70180_af.func_75692_b(29, (Object)0);
        }
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (player.func_70093_af() && this.getIsZooAnimal() && !this.func_70631_g_() && this.hasAccessableInventory() && this.isChested()) {
            player.openGui((Object)ZAWAMain.instance, CommonProxy.GUI.ANIMAL_INV.id, this.field_70170_p, (int)Math.floor(this.field_70165_t), (int)this.field_70163_u, (int)Math.floor(this.field_70161_v));
        }
        if (stack != null && stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae) && this.hasAccessableInventory() && this.getIsZooAnimal()) {
            if (!this.isChested() && !player.field_71075_bZ.field_75098_d) {
                --player.field_71071_by.func_70448_g().field_77994_a;
            }
            this.setChested(true);
        }
        if (stack != null && ZAWABaseLand.getStatItem() != null && stack.func_77973_b() == ZAWABaseLand.getStatItem().func_77973_b() && player.field_70170_p.field_72995_K) {
            GuiAnimalData.animal = this;
            GuiAnimalData.player = player;
            GuiAnimalData.name = stack.func_82833_r();
            player.openGui((Object)ZAWAMain.instance, CommonProxy.GUI.DATA.id, player.field_70170_p, 0, 0, 0);
        }
        if (stack != null && this.setTameItem() != null && stack.func_77973_b() == this.setTameItem().func_77973_b() && !this.getIsZooAnimal() && !this.func_70631_g_()) {
            if (this.getTrait().equals((Object)AnimalData.Traits.NAIVE)) {
                if (this.func_70681_au().nextInt(2) == 1) {
                    this.onTame(player);
                } else {
                    this.playFailEffect();
                }
            } else if (this.getTrait().equals((Object)AnimalData.Traits.LONELY)) {
                if (this.func_70681_au().nextInt(10) == 1) {
                    this.onTame(player);
                } else {
                    this.playFailEffect();
                }
            } else if (this.getTrait().equals((Object)AnimalData.Traits.CAREFUL)) {
                if (this.func_70681_au().nextInt(12) == 1) {
                    this.onTame(player);
                } else {
                    this.playFailEffect();
                }
            } else if (this.func_70681_au().nextInt(4) == 1) {
                this.onTame(player);
            } else {
                this.playFailEffect();
            }
        }
        if (stack != null && this.isFoodItem(stack) && this.getIsZooAnimal() && this.getCurrFood() < this.getMaxFood()) {
            this.onFed(player);
            this.setCurrFood(this.getCurrFood() + 1.0);
            this.field_70170_p.func_72956_a((Entity)this, "random.eat", 1.0f, 1.0f);
            this.playFeedEffect();
        }
        if (stack != null && this.setVial() != null && stack.func_77973_b() == this.setVial().func_77973_b() && this.getIsZooAnimal()) {
            this.onBreedAttempt(player);
            this.func_146082_f(player);
        }
        if (stack != null && stack.func_77973_b() instanceof ZAWAEnrichmentItem && this.getIsZooAnimal()) {
            ZAWAEnrichmentItem item = (ZAWAEnrichmentItem)stack.func_77973_b();
            if (item.setAnimalsUsed() != null) {
                for (int i = 0; i < item.setAnimalsUsed().size(); ++i) {
                    if (item.setAnimalsUsed().get(i) != ((Object)((Object)this)).getClass()) continue;
                    item.setItemUse(this);
                    break;
                }
            } else {
                item.setItemUse(this);
                this.playLoveEffect();
            }
        }
        return super.func_70085_c(player);
    }

    public boolean isOwner(EntityPlayer player) {
        return player.func_110124_au().toString().equals(this.getOwnerId());
    }

    public boolean isFoodItem(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void playTameEffect() {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.NOTE;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, this.particle);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void playFailEffect() {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.SMOKE_NORMAL;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, this.particle);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void playSickEffect() {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.SPELL_WITCH;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, this.particle);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void playLoveEffect() {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.HEART;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, this.particle);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void playFeedEffect() {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.VILLAGER_HAPPY;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, this.particle);
        }
    }

    public void func_70636_d() {
        int c;
        Vec3 vec3;
        int a;
        int i;
        if (!this.getIsZooAnimal()) {
            if (this.field_70170_p.func_175659_aa().equals((Object)EnumDifficulty.PEACEFUL)) {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.AIFight);
                this.field_70715_bh.func_85156_a((EntityAIBase)this.AINearAtt);
            } else if (this.setNature() == AnimalData.EnumNature.AGGRESSIVE) {
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.AIFight);
                this.field_70715_bh.func_75776_a(7, (EntityAIBase)this.AINearAtt);
            } else if (this.field_70170_p.func_72890_a((Entity)this, 2.0) != null && (this.setNature() == AnimalData.EnumNature.TERRITORIAL || this.setNature() == AnimalData.EnumNature.PROTECTIVE)) {
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.AIFight);
                this.field_70715_bh.func_75776_a(7, (EntityAIBase)this.AINearAtt);
            }
        }
        if (this.canSleep()) {
            this.isSleeping = !this.flipSleep() ? !this.field_70170_p.func_72935_r() : this.field_70170_p.func_72935_r();
            if (this.isSleeping()) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
            } else {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.defaultSpeed);
            }
        }
        if (ZAWAConfig.deathFromStats && this.getIsZooAnimal() && !this.field_70170_p.func_175659_aa().equals((Object)EnumDifficulty.PEACEFUL)) {
            if (this.getCurrFood() <= 0.0) {
                this.func_70665_d(DamageSource.field_76366_f, 1.0f);
                this.playSickEffect();
            }
            if (this.getCurrFood() < this.getMaxFood()) {
                this.needFood = true;
            }
            if (this.func_70089_S()) {
                this.setCurrFood(this.getCurrFood() - 7.0E-4);
                this.setEnrichment(this.getEnrichment() - 9.0E-4);
            }
            if (this.getEnrichment() <= 1.0) {
                this.playSickEffect();
            }
            if (this.getEnrichment() <= 0.0) {
                this.func_70665_d(ZAWAMain.depression, 1.0f);
            }
        }
        if (this.getCurrFood() < this.getMaxFood() - 2.0 && this.getIsZooAnimal() && !this.field_70170_p.func_175659_aa().equals((Object)EnumDifficulty.PEACEFUL)) {
            for (i = -10; i < 10; ++i) {
                for (a = -10; a < 10; ++a) {
                    vec3 = RandomPositionGenerator.func_75464_a((EntityCreature)this, (int)16, (int)7, (Vec3)new Vec3(this.field_70165_t + (double)a, this.field_70163_u, this.field_70161_v + (double)i));
                    if (vec3 == null || !ZAWAUtils.blockAtPos(this.field_70170_p, ZAWABlocks.animal_feeder, vec3.field_72450_a, vec3.field_72448_b - 1.0, vec3.field_72449_c)) continue;
                    this.func_70661_as().func_75492_a(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, 1.26);
                }
            }
        }
        if (this.getCurrFood() < this.getMaxFood() - 1.0 && this.getIsZooAnimal() && !this.field_70170_p.func_175659_aa().equals((Object)EnumDifficulty.PEACEFUL)) {
            for (i = -3; i < 6; ++i) {
                block3: for (a = -3; a < 6; ++a) {
                    TileEntityFeeder feeder;
                    vec3 = RandomPositionGenerator.func_75464_a((EntityCreature)this, (int)16, (int)7, (Vec3)new Vec3(this.field_70165_t + (double)a, this.field_70163_u, this.field_70161_v + (double)i));
                    if (vec3 == null || this.field_70170_p.func_180495_p(new BlockPos(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c)).func_177230_c() != ZAWABlocks.animal_feeder || (feeder = (TileEntityFeeder)this.field_70170_p.func_175625_s(new BlockPos(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c))) == null) continue;
                    for (int spo = 0; spo < feeder.func_70302_i_(); ++spo) {
                        if (feeder.func_70301_a(spo) == null || !this.isFoodItem(feeder.func_70301_a(spo))) continue;
                        this.setCurrFood(this.getCurrFood() + 1.0);
                        feeder.func_70298_a(spo, 1);
                        feeder.func_70296_d();
                        this.field_70170_p.func_72956_a((Entity)this, "random.eat", 1.0f, 1.0f);
                        this.playFeedEffect();
                        continue block3;
                    }
                }
            }
        }
        if (this.socialInteraction()) {
            if (this.socialCount >= 200 && this.getEnrichment() < this.getMaxEnrichment() - 1.0 && this.getIsZooAnimal() && !this.field_70170_p.func_175659_aa().equals((Object)EnumDifficulty.PEACEFUL)) {
                double distance = 6.0;
                Entity entityFound = null;
                double d4 = -1.0;
                for (int i2 = 0; i2 < this.field_70170_p.field_72996_f.size(); ++i2) {
                    Entity currE = (Entity)this.field_70170_p.field_72996_f.get(i2);
                    if (currE.getClass() != ((Object)((Object)this)).getClass() || currE == this) continue;
                    double d5 = currE.func_70092_e(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    if (!(distance < 0.0) && !(d5 < distance * distance) || d4 != -1.0 && !(d5 < d4)) continue;
                    d4 = d5;
                    entityFound = currE;
                }
                if (entityFound != null) {
                    this.playLoveEffect();
                    this.setEnrichment(this.getEnrichment() + 1.0);
                    this.socialCount = 0;
                }
            }
            if (this.getIsZooAnimal() && !this.field_70170_p.func_175659_aa().equals((Object)EnumDifficulty.PEACEFUL)) {
                ++this.socialCount;
            }
        }
        if (this.getEnrichment() < this.getMaxEnrichment() - 2.0 && this.getIsZooAnimal() && !this.field_70170_p.func_175659_aa().equals((Object)EnumDifficulty.PEACEFUL)) {
            for (int i3 = -10; i3 < 10; ++i3) {
                block7: for (a = -10; a < 10; ++a) {
                    vec3 = RandomPositionGenerator.func_75464_a((EntityCreature)this, (int)16, (int)7, (Vec3)new Vec3(this.field_70165_t + (double)a, this.field_70163_u, this.field_70161_v + (double)i3));
                    if (vec3 == null || !(ZAWAUtils.getBlockAtPos(this.field_70170_p, vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c) instanceof ZAWAEnrichmentBlock)) continue;
                    ZAWAEnrichmentBlock block = (ZAWAEnrichmentBlock)ZAWAUtils.getBlockAtPos(this.field_70170_p, vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c);
                    if (block.setAnimalsUsed() != null) {
                        for (c = 0; c < block.setAnimalsUsed().size(); ++c) {
                            if (block.setAnimalsUsed().get(c) != ((Object)((Object)this)).getClass()) continue;
                            this.func_70661_as().func_75492_a(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, 1.26);
                            continue block7;
                        }
                        continue;
                    }
                    this.func_70661_as().func_75492_a(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, 1.26);
                }
            }
        }
        if (this.getEnrichment() < this.getMaxEnrichment() - 1.0 && this.getIsZooAnimal() && !this.field_70170_p.func_175659_aa().equals((Object)EnumDifficulty.PEACEFUL)) {
            for (int i4 = -3; i4 < 6; ++i4) {
                block10: for (a = -3; a < 6; ++a) {
                    vec3 = RandomPositionGenerator.func_75464_a((EntityCreature)this, (int)16, (int)7, (Vec3)new Vec3(this.field_70165_t + (double)a, this.field_70163_u, this.field_70161_v + (double)i4));
                    if (vec3 == null || !(ZAWAUtils.getBlockAtPos(this.field_70170_p, vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c) instanceof ZAWAEnrichmentBlock)) continue;
                    ZAWAEnrichmentBlock block = (ZAWAEnrichmentBlock)ZAWAUtils.getBlockAtPos(this.field_70170_p, vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c);
                    if (block.setAnimalsUsed() != null) {
                        for (c = 0; c < block.setAnimalsUsed().size(); ++c) {
                            if (block.setAnimalsUsed().get(c) != ((Object)((Object)this)).getClass()) continue;
                            if (this.getEnrichment() < this.getMaxEnrichment()) {
                                this.setEnrichment(this.getEnrichment() + (double)block.setEnrichment());
                            }
                            this.playLoveEffect();
                            continue block10;
                        }
                        continue;
                    }
                    if (this.getEnrichment() < this.getMaxEnrichment()) {
                        this.setEnrichment(this.getEnrichment() + (double)block.setEnrichment());
                    }
                    this.playLoveEffect();
                }
            }
        }
        super.func_70636_d();
    }

    public void func_70071_h_() {
        for (EntityDisplayData d : displayData) {
            d.onUpdate(this);
        }
        super.func_70071_h_();
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.getIsZooAnimal()) {
            try {
                if (this.getEnrichment() < this.getMaxEnrichment() - 2.0) {
                    this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.AIFightA);
                    this.field_70715_bh.func_75776_a(4, (EntityAIBase)this.AINearAttA);
                } else {
                    this.field_70714_bg.func_85156_a((EntityAIBase)this.AIFightA);
                    this.field_70715_bh.func_85156_a((EntityAIBase)this.AINearAttA);
                }
            }
            catch (Exception e) {
                ZAWAMain.logger.error("Failed to remove tasks, they probably didn't exist");
            }
        }
    }

    @Deprecated
    public boolean isKeeperFed() {
        return true;
    }

    public boolean canSleep() {
        return false;
    }

    public boolean flipSleep() {
        return false;
    }

    public boolean isSleeping() {
        return this.isSleeping;
    }

    public double getDefaultSpeed() {
        return this.defaultSpeed;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    private void dropItemsInChest(Entity entity, IInventory inventory) {
        if (inventory != null && !this.field_70170_p.field_72995_K) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack itemstack = inventory.func_70301_a(i);
                if (itemstack == null) continue;
                this.func_70099_a(itemstack, 0.0f);
            }
        }
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        this.dropItemsInChest((Entity)this, (IInventory)this.animalInv);
        super.func_70628_a(p_70628_1_, p_70628_2_);
    }

    public class AIFight
    extends EntityAIAttackOnCollide {
        public AIFight() {
            super((EntityCreature)ZAWABaseLand.this, EntityLivingBase.class, 1.9, true);
        }

        protected double func_179512_a(EntityLivingBase e) {
            return 4.0f + e.field_70130_N;
        }
    }

    public class AIAvoidEntity
    extends EntityAIAvoidEntity {
        private ZAWABaseLand entityInstance;

        public AIAvoidEntity(Predicate avoidPredicate, float f, double d, double d1) {
            super((EntityCreature)ZAWABaseLand.this, avoidPredicate, f, d, d1);
            this.entityInstance = ZAWABaseLand.this;
        }

        public void func_75246_d() {
            super.func_75246_d();
        }
    }
}

