/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.base;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.zawamod.entity.base.ZAWABaseLand;
import org.zawamod.util.ZAWAUtils;

public abstract class ZAWABaseWaterOld
extends ZAWABaseLand {
    public boolean landed = true;
    public int animalType;
    public float swimmingPitch;
    public float prevswimmingPitch;
    public float swimmingYaw;
    public float prevswimmingYaw;
    public float swimmingRotation;
    public float prevswimmingRotation;
    protected float randomMotionSpeed;
    protected float rotationVelocity;
    protected float field_70871_bB;
    protected float randomMotionVecX;
    protected float randomMotionVecY;
    protected float randomMotionVecZ;
    private boolean ridden;

    public ZAWABaseWaterOld(World worldIn, boolean ridden) {
        super(worldIn, 0.0, false);
        this.func_70105_a(0.35f, 0.45f);
        this.field_70146_Z.setSeed(1 + this.func_145782_y());
        this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIMoveRandom());
        this.field_70714_bg.func_85156_a((EntityAIBase)this.wanderAI);
        this.ridden = ridden;
    }

    @Override
    public boolean isTransportable() {
        return false;
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public abstract boolean hopToWater();

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        if (this.ridden && !this.field_70170_p.field_72995_K && this.field_70153_n == null) {
            player.func_70078_a((Entity)this);
        }
        return super.func_70085_c(player);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(5.0);
        if (this.hopToWater()) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
        }
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    protected boolean func_70041_e_() {
        return true;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.prevswimmingPitch = this.swimmingPitch;
        this.prevswimmingYaw = this.swimmingYaw;
        this.prevswimmingRotation = this.swimmingRotation;
        this.swimmingRotation += this.rotationVelocity;
        if ((double)this.swimmingRotation > Math.PI * 2) {
            if (this.field_70170_p.field_72995_K) {
                this.swimmingRotation = (float)Math.PI * 2;
            } else {
                this.swimmingRotation = (float)((double)this.swimmingRotation - Math.PI * 2);
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 6.0f) * 0.2f;
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)19);
            }
        }
        if (this.field_70171_ac && !this.func_70610_aX()) {
            float f;
            if (this.swimmingRotation < (float)Math.PI) {
                f = this.swimmingRotation / (float)Math.PI;
                if ((double)f > 0.75) {
                    this.randomMotionSpeed = 1.0f;
                    this.field_70871_bB = 1.0f;
                } else {
                    this.field_70871_bB *= 0.8f;
                }
            } else {
                this.randomMotionSpeed *= 0.9f;
                this.field_70871_bB *= 0.99f;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70159_w = (double)(this.randomMotionVecX * this.randomMotionSpeed) * 2.0;
                this.field_70181_x = this.randomMotionVecY * this.randomMotionSpeed;
                this.field_70179_y = (double)(this.randomMotionVecZ * this.randomMotionSpeed) * 2.0;
            }
            f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70761_aq += (-((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI - this.field_70761_aq) * 0.1f;
            this.field_70177_z = this.field_70761_aq;
            this.swimmingYaw = (float)((double)this.swimmingYaw + Math.PI * (double)this.field_70871_bB * 1.5);
            this.swimmingPitch += (-((float)Math.atan2(f, this.field_70181_x)) * 180.0f / (float)Math.PI - this.swimmingPitch) * 0.1f;
        } else {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70159_w = 0.0;
                this.field_70181_x -= 0.08;
                this.field_70181_x *= (double)0.98f;
                this.field_70179_y = 0.0;
            }
            this.swimmingPitch = (float)((double)this.swimmingPitch + (double)(-90.0f - this.swimmingPitch) * 0.02);
        }
        if (!this.func_70090_H() && this.hopToWater()) {
            if (this.field_70173_aa % 20 == 0) {
                this.func_70664_aZ();
            }
            int i = -10;
            int a = -10;
            while (i < 10) {
                Vec3 vec3 = RandomPositionGenerator.func_75464_a((EntityCreature)this, (int)16, (int)7, (Vec3)new Vec3(this.field_70165_t + (double)a, this.field_70163_u - 1.0, this.field_70161_v + (double)i));
                if (vec3 != null && ZAWAUtils.blockAtPos(this.field_70170_p, (Block)Blocks.field_150355_j, vec3.field_72450_a, vec3.field_72448_b - 1.0, vec3.field_72449_c)) {
                    this.func_70661_as().func_75492_a(vec3.field_72450_a, vec3.field_72448_b - 1.0, vec3.field_72449_c, 1.26);
                }
                ++i;
                ++a;
            }
        }
    }

    public void func_70612_e(float p_70612_1_, float p_70612_2_) {
        if (this.field_70171_ac) {
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        } else {
            super.func_70612_e(p_70612_1_, p_70612_2_);
        }
    }

    public void setMotionVec(float p_175568_1_, float p_175568_2_, float p_175568_3_) {
        this.randomMotionVecX = p_175568_1_;
        this.randomMotionVecY = p_175568_2_;
        this.randomMotionVecZ = p_175568_3_;
    }

    public boolean isMotionVecZero() {
        return this.randomMotionVecX != 0.0f || this.randomMotionVecY != 0.0f || this.randomMotionVecZ != 0.0f;
    }

    public float setYMotion() {
        return 0.2f;
    }

    @Override
    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.func_70027_ad()) {
            this.func_145779_a(Items.field_179566_aV, 1);
        } else {
            this.func_145779_a(Items.field_151115_aP, 1);
        }
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70601_bi() {
        return true;
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    public int func_70627_aG() {
        return 120;
    }

    @Override
    protected boolean func_70692_ba() {
        return false;
    }

    protected int func_70693_a(EntityPlayer player) {
        return 1 + this.field_70170_p.field_73012_v.nextInt(3);
    }

    public void func_70030_z() {
        int i = this.func_70086_ai();
        super.func_70030_z();
        if (!this.isLandBreather()) {
            if (this.func_70089_S() && !this.func_70090_H()) {
                this.func_70050_g(--i);
                if (this.func_70086_ai() == -20) {
                    this.func_70050_g(0);
                    this.func_70097_a(DamageSource.field_76369_e, 2.0f);
                }
            } else {
                this.func_70050_g(300);
            }
        }
    }

    public boolean isLandBreather() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    class AIMoveRandom
    extends EntityAIBase {
        private ZAWABaseWaterOld animal;

        AIMoveRandom() {
            this.animal = ZAWABaseWaterOld.this;
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            int i = this.animal.func_70654_ax();
            if (i > 100) {
                this.animal.setMotionVec(0.0f, 0.0f, 0.0f);
            } else if (this.animal.func_70681_au().nextInt(3) == 0 || !this.animal.field_70171_ac || !this.animal.isMotionVecZero()) {
                float f = this.animal.func_70681_au().nextFloat() * (float)Math.PI * 0.7f;
                float x = MathHelper.func_76134_b((float)f) * 0.2f;
                float z = -0.1f + this.animal.func_70681_au().nextFloat() * this.animal.setYMotion();
                float y = MathHelper.func_76126_a((float)f) * 0.2f;
                this.animal.setMotionVec(x, z, y);
            }
        }
    }
}

