/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import com.google.common.base.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import org.zawamod.entity.ai.EntityAIAttackEnts;
import org.zawamod.entity.base.ZAWABaseLand;
import org.zawamod.entity.data.AnimalData;
import org.zawamod.entity.data.BreedItems;
import org.zawamod.init.achieve.ZAWAAchievement;
import org.zawamod.init.items.ZAWAArmor;
import org.zawamod.init.items.ZAWAItems;
import org.zawamod.util.ZAWASounds;

public class EntityAmurLeopard
extends ZAWABaseLand {
    private EntityAILeapAtTarget AILeap = new EntityAILeapAtTarget((EntityLiving)this, 0.3f);

    public EntityAmurLeopard(World worldIn) {
        super(worldIn, 0.26, false);
        this.func_70105_a(1.0f, 1.3f);
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.AILeap);
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAIAttackEnts(this, EntityLiving.class, false, new Predicate(){

            public boolean func_180094_a(Entity e) {
                return e instanceof EntityWolf || e instanceof EntityRabbit || e instanceof EntityPig || e instanceof EntitySheep || e instanceof EntityChicken || e instanceof EntityPlayer;
            }

            public boolean apply(Object o) {
                return this.func_180094_a((Entity)o);
            }
        }));
        ZAWABaseLand.AIAvoidEntity avoidAI = new ZAWABaseLand.AIAvoidEntity(new Predicate(){

            public boolean func_180086_a(Entity ent) {
                return ent instanceof EntityVillager;
            }

            public boolean apply(Object o) {
                return this.func_180086_a((Entity)o);
            }
        }, 16.0f, 1.33, 1.33);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)avoidAI);
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return BreedItems.CarnivoreItems(stack);
    }

    @Override
    public void onBreedAttempt(EntityPlayer p) {
        p.func_71029_a((StatBase)ZAWAAchievement.achievementEndanger);
        super.onBreedAttempt(p);
    }

    protected String func_70639_aQ() {
        return ZAWASounds.AMURLEOPARD_AMBIENT.getSound();
    }

    protected String func_70621_aR() {
        return ZAWASounds.AMURLEOPARD_HURT.getSound();
    }

    @Override
    public void func_70071_h_() {
        if (this.getIsZooAnimal() || this.field_70170_p.func_175659_aa().equals((Object)EnumDifficulty.PEACEFUL)) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.AIFight);
            this.field_70715_bh.func_85156_a((EntityAIBase)this.AINearAtt);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.AILeap);
        }
        if (this.field_70170_p.func_72890_a((Entity)this, 10.0) != null) {
            EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, 10.0);
            if (player.field_71071_by.func_70440_f(3) != null && player.field_71071_by.func_70440_f(3).func_77973_b() == ZAWAArmor.tiger_hood && player.field_71071_by.func_70440_f(2) != null && player.field_71071_by.func_70440_f(2).func_77973_b() == ZAWAArmor.tiger_chest && player.field_71071_by.func_70440_f(1) != null && player.field_71071_by.func_70440_f(1).func_77973_b() == ZAWAArmor.tiger_legs) {
                if (player.field_71071_by.func_70440_f(0) != null && player.field_71071_by.func_70440_f(0).func_77973_b() == ZAWAArmor.tiger_boots) {
                    this.field_70715_bh.func_85156_a((EntityAIBase)this.AINearAtt);
                } else {
                    this.field_70715_bh.func_75776_a(0, (EntityAIBase)this.AINearAtt);
                }
            }
        }
        super.func_70071_h_();
    }

    @Override
    public ItemStack setVial() {
        return new ItemStack(ZAWAItems.bigcat_vial, 1);
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return new ItemStack(ZAWAItems.amur_leopard_egg, 1);
    }

    @Override
    public void func_70636_d() {
        if (this.field_70171_ac) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.06);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
        }
        super.func_70636_d();
    }

    @Override
    public ItemStack setTameItem() {
        return new ItemStack(ZAWAItems.big_cat_kibble, 1);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    @Override
    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.func_70027_ad()) {
            this.func_145779_a(ZAWAItems.carnivore_meat_cooked, 1);
        } else {
            this.func_145779_a(ZAWAItems.carnivore_meat_raw, 1);
        }
        this.func_145779_a(ZAWAItems.amur_leopard_hide, this.field_70146_Z.nextInt(3));
    }

    public boolean func_70652_k(Entity e) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        return e.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 7.0f);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76364_f() instanceof EntityLivingBase) {
            this.func_70604_c((EntityLivingBase)source.func_76364_f());
        }
        return super.func_70097_a(source, amount);
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        EntityAmurLeopard li = new EntityAmurLeopard(this.field_70170_p);
        if (this.func_70681_au().nextInt(5) != 1) {
            li.setAnimalTrait(this.getTrait());
        }
        if (this.func_70681_au().nextInt(5) != 1) {
            li.setAnimalType(this.getAnimalType());
        }
        return li;
    }

    @Override
    public int setVarients() {
        return 7;
    }

    @Override
    public AnimalData.EnumNature setNature() {
        return AnimalData.EnumNature.AGGRESSIVE;
    }

    class AIFight
    extends EntityAIAttackOnCollide {
        public AIFight() {
            super((EntityCreature)EntityAmurLeopard.this, EntityLivingBase.class, 1.8, true);
        }

        protected double func_179512_a(EntityLivingBase evb) {
            return 4.0f + evb.field_70130_N;
        }
    }
}

