/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import org.zawamod.entity.base.ZAWABaseLand;
import org.zawamod.entity.data.AnimalData;
import org.zawamod.entity.data.BreedItems;
import org.zawamod.init.items.ZAWAItems;
import org.zawamod.util.ZAWASounds;

public class EntityBlackSpiderMonkey
extends ZAWABaseLand {
    public EntityBlackSpiderMonkey(World worldIn) {
        super(worldIn, 0.29, true);
        this.func_70105_a(0.8f, 0.9f);
        ((PathNavigateGround)this.func_70661_as()).func_179690_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.54));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 0.43));
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return BreedItems.OmnivoreItems(stack);
    }

    @Override
    public int setVarients() {
        return 4;
    }

    protected String func_70621_aR() {
        return ZAWASounds.SPIDER_MONKEY_HURT.getSound();
    }

    protected String func_70639_aQ() {
        return ZAWASounds.SPIDER_MONKEY_AMBIENT.getSound();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return new ItemStack(ZAWAItems.black_spider_monkey_egg, 1);
    }

    @Override
    public ItemStack setTameItem() {
        return new ItemStack(ZAWAItems.monkey_kibble, 1);
    }

    @Override
    public ItemStack setVial() {
        return new ItemStack(ZAWAItems.monkey_vial, 1);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    public void setBesideClimbableBlock(boolean p_70839_1_) {
        byte b0 = this.field_70180_af.func_75683_a(16);
        b0 = p_70839_1_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_75692_b(16, (Object)b0);
    }

    public boolean isBesideClimbableBlock() {
        return (this.field_70180_af.func_75683_a(16) & 1) != 0;
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(17.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.39);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    @Override
    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.func_70027_ad()) {
            this.func_145779_a(ZAWAItems.bush_meat_cooked, 1);
        } else {
            this.func_145779_a(ZAWAItems.bush_meat_raw, 1);
        }
        this.func_145779_a(ZAWAItems.fur, this.field_70146_Z.nextInt(3));
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        EntityBlackSpiderMonkey li = new EntityBlackSpiderMonkey(this.field_70170_p);
        if (this.func_70681_au().nextInt(5) != 1) {
            li.setAnimalTrait(this.getTrait());
        }
        if (this.func_70681_au().nextInt(5) != 1) {
            li.setAnimalType(this.getAnimalType());
        }
        return li;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Byte(0));
    }

    @Override
    public AnimalData.EnumNature setNature() {
        return AnimalData.EnumNature.NEUTRAL;
    }
}

