/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import com.google.common.base.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIEatGrass;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import org.zawamod.entity.base.ZAWABaseLand;
import org.zawamod.entity.data.AnimalData;
import org.zawamod.entity.data.BreedItems;
import org.zawamod.entity.land.EntityAfricanLion;
import org.zawamod.entity.land.EntityBengalTiger;
import org.zawamod.init.items.ZAWAItems;
import org.zawamod.util.ZAWASounds;

public class EntityGaur
extends ZAWABaseLand {
    public int slowCounter = 0;

    public EntityGaur(World worldIn) {
        super(worldIn, 0.26, false);
        this.func_70105_a(1.6f, 1.6f);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIEatGrass((EntityLiving)this));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        ZAWABaseLand.AIAvoidEntity avoidAI = new ZAWABaseLand.AIAvoidEntity(new Predicate(){

            public boolean func_180086_a(Entity ent) {
                return ent instanceof EntityAfricanLion || ent instanceof EntityBengalTiger;
            }

            public boolean apply(Object o) {
                return this.func_180086_a((Entity)o);
            }
        }, 16.0f, 1.33, 1.33);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)avoidAI);
    }

    @Override
    public boolean hasAccessableInventory() {
        return true;
    }

    protected String func_70639_aQ() {
        return ZAWASounds.GAUR_AMBIENT.getSound();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.getIsZooAnimal()) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.AIFight);
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)this.AINearAtt);
        }
        if (source.func_76364_f() instanceof EntityLivingBase) {
            this.func_70604_c((EntityLivingBase)source.func_76364_f());
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return BreedItems.HerbivoreItems(stack);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return new ItemStack(ZAWAItems.gaur_egg, 1);
    }

    @Override
    public ItemStack setVial() {
        return new ItemStack(ZAWAItems.unglate_vial, 1);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(26, (Object)0);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("HasCart", this.getHasCart());
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setHasCart(tagCompund.func_74767_n("HasCart"));
    }

    public boolean getHasCart() {
        return this.field_70180_af.func_75683_a(26) != 0;
    }

    public void setHasCart(boolean f) {
        if (f) {
            this.field_70180_af.func_75692_b(26, (Object)1);
        } else {
            this.field_70180_af.func_75692_b(26, (Object)0);
        }
    }

    @Override
    public int setVarients() {
        return 4;
    }

    @Override
    public ItemStack setTameItem() {
        return new ItemStack(ZAWAItems.unglate_kibble, 1);
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (stack != null && stack.func_77973_b() == ZAWAItems.cart && this.getIsZooAnimal() && !this.func_70631_g_()) {
            this.setHasCart(true);
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
        } else if (this.getHasCart() && this.isOwner(player) && !player.func_70093_af() && this.field_70153_n == null && !this.field_70170_p.field_72995_K) {
            player.func_70078_a((Entity)this);
        }
        return super.func_70085_c(player);
    }

    public boolean canRiderInteract() {
        return true;
    }

    @Override
    public void func_70071_h_() {
        if (((int)this.field_70165_t != (int)this.field_70169_q || (int)this.field_70161_v != (int)this.field_70166_s) && this.field_70153_n != null) {
            ++this.slowCounter;
        }
        super.func_70071_h_();
    }

    @Override
    public void func_70636_d() {
        if (this.slowCounter >= 150) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.06);
            for (int i = 0; i < 7; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
            }
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
        }
        super.func_70636_d();
    }

    public void func_70612_e(float stafe, float forward) {
        if (this.field_70153_n != null) {
            this.field_70126_B = this.field_70177_z = this.field_70153_n.field_70177_z;
            this.field_70125_A = this.field_70153_n.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            stafe = ((EntityLivingBase)this.field_70153_n).field_70702_br * 0.1f;
            forward = ((EntityLivingBase)this.field_70153_n).field_70701_bs;
            this.field_70138_W = 1.0f;
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (!this.field_70170_p.field_72995_K) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_70612_e(stafe, forward);
            }
            this.field_70722_aY = this.field_70721_aZ;
            double d0 = this.field_70165_t - this.field_70169_q;
            double d1 = this.field_70161_v - this.field_70166_s;
            float f4 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1)) * 4.0f;
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
            this.field_70754_ba += this.field_70721_aZ;
        } else {
            this.field_70138_W = 1.0f;
            this.field_70747_aH = 0.02f;
            super.func_70612_e(stafe, forward);
        }
    }

    public void func_70043_V() {
        super.func_70043_V();
        if (this.field_70153_n != null) {
            this.field_70153_n.func_70107_b(this.field_70165_t, this.field_70163_u + this.func_70042_X() + 0.0 + this.field_70153_n.func_70033_W(), this.field_70161_v);
        }
    }

    @Override
    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.func_70027_ad()) {
            this.func_145779_a(ZAWAItems.large_meat_cooked, 1);
        } else {
            this.func_145779_a(ZAWAItems.large_meat_raw, 1);
        }
        if (this.getHasCart()) {
            this.func_145779_a(ZAWAItems.cart, 1);
        }
        this.func_145779_a(Items.field_151116_aA, this.field_70146_Z.nextInt(3));
    }

    public boolean func_70652_k(Entity p_70652_1_) {
        return p_70652_1_.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 7.0f);
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        EntityGaur li = new EntityGaur(this.field_70170_p);
        if (this.func_70681_au().nextInt(5) != 1) {
            li.setAnimalTrait(this.getTrait());
        }
        if (this.func_70681_au().nextInt(5) != 1) {
            li.setAnimalType(this.getAnimalType());
        }
        return li;
    }

    @Override
    public AnimalData.EnumNature setNature() {
        return AnimalData.EnumNature.TERRITORIAL;
    }

    class AIFight
    extends EntityAIAttackOnCollide {
        public AIFight() {
            super((EntityCreature)EntityGaur.this, EntityLivingBase.class, 1.8, true);
        }

        protected double func_179512_a(EntityLivingBase evb) {
            return 4.0f + evb.field_70130_N;
        }
    }
}

