/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIEatGrass;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import org.zawamod.entity.base.ZAWABaseLand;
import org.zawamod.entity.data.AnimalData;
import org.zawamod.entity.data.BreedItems;
import org.zawamod.entity.data.Gender;
import org.zawamod.init.achieve.ZAWAAchievement;
import org.zawamod.init.items.ZAWAItems;
import org.zawamod.util.ZAWASounds;

public class EntityLowlandGorilla
extends ZAWABaseLand {
    private ZAWABaseLand.AIFight AIFight = new ZAWABaseLand.AIFight();
    private EntityAINearestAttackableTarget AINearAtt = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true);
    private EntityAIPanic AIPanic = new EntityAIPanic((EntityCreature)this, 1.43);

    public EntityLowlandGorilla(World worldIn) {
        super(worldIn, 0.4, false);
        this.func_70105_a(1.5f, 1.5f);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIEatGrass((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
    }

    @Override
    public boolean sexualDimorphism() {
        return true;
    }

    protected String func_70639_aQ() {
        return ZAWASounds.GORILLA_AMBIENT.getSound();
    }

    protected String func_70621_aR() {
        return ZAWASounds.GORILLA_HURT.getSound();
    }

    @Override
    public void onTame(EntityPlayer p) {
        p.func_71029_a((StatBase)ZAWAAchievement.achievementTarzan);
        super.onTame(p);
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return BreedItems.LeafEaterItems(stack);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.getIsZooAnimal() && this.getGender() == Gender.MALE) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.AIFight);
            this.field_70715_bh.func_75776_a(7, (EntityAIBase)this.AINearAtt);
            if (source.func_76364_f() instanceof EntityLivingBase) {
                this.func_70604_c((EntityLivingBase)source.func_76364_f());
            }
        }
        if (!this.getIsZooAnimal() && this.getGender() == Gender.FEMALE) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.AIPanic);
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity p_70652_1_) {
        return p_70652_1_.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 4.0f);
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return new ItemStack(ZAWAItems.western_lowland_gorilla, 1);
    }

    @Override
    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.func_70027_ad()) {
            this.func_145779_a(ZAWAItems.bush_meat_cooked, 1);
        } else {
            this.func_145779_a(ZAWAItems.bush_meat_raw, 1);
        }
        this.func_145779_a(ZAWAItems.gorilla_hide, this.field_70146_Z.nextInt(3));
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        EntityLowlandGorilla li = new EntityLowlandGorilla(this.field_70170_p);
        if (this.func_70681_au().nextInt(5) != 1) {
            li.setAnimalTrait(this.getTrait());
        }
        if (this.func_70681_au().nextInt(5) != 1) {
            li.setAnimalType(this.getAnimalType());
        }
        return li;
    }

    @Override
    public ItemStack setVial() {
        return new ItemStack(ZAWAItems.ape_vial, 1);
    }

    @Override
    public ItemStack setTameItem() {
        return new ItemStack(ZAWAItems.ape_kibble, 1);
    }

    @Override
    public int setVarients() {
        return 3;
    }

    @Override
    public AnimalData.EnumNature setNature() {
        return AnimalData.EnumNature.PROTECTIVE;
    }
}

