/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIEatGrass;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import org.zawamod.entity.base.ZAWABaseLand;
import org.zawamod.entity.data.AnimalData;
import org.zawamod.entity.data.BreedItems;
import org.zawamod.init.achieve.ZAWAAchievement;
import org.zawamod.init.items.ZAWAItems;
import org.zawamod.util.ZAWASounds;

public class EntityNileHippo
extends ZAWABaseLand {
    boolean b = false;

    public EntityNileHippo(World worldIn) {
        super(worldIn, 0.26, false);
        this.func_70105_a(1.3f, 1.5f);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIEatGrass((EntityLiving)this));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
    }

    @Override
    public int setVarients() {
        return 5;
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return BreedItems.GrazzerItems(stack);
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return new ItemStack(ZAWAItems.nile_hippopotamus_egg, 1);
    }

    @Override
    public ItemStack setTameItem() {
        return new ItemStack(ZAWAItems.pachyderm_kibble, 1);
    }

    @Override
    public ItemStack setVial() {
        return new ItemStack(ZAWAItems.pachyderm_vial, 1);
    }

    @Override
    public void onTame(EntityPlayer p) {
        p.func_71029_a((StatBase)ZAWAAchievement.achievementMadagascar);
        super.onTame(p);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(42.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    protected String func_70639_aQ() {
        return ZAWASounds.NILE_HIPPO_AMBIENT.getSound();
    }

    protected String func_70621_aR() {
        return ZAWASounds.NILE_HIPPO_HURT.getSound();
    }

    @Override
    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.func_70027_ad()) {
            this.func_145779_a(ZAWAItems.large_meat_cooked, 1);
        } else {
            this.func_145779_a(ZAWAItems.large_meat_raw, 1);
        }
        this.func_145779_a(Items.field_151116_aA, this.field_70146_Z.nextInt(3));
        this.func_145779_a(ZAWAItems.ivory_tusk, this.field_70146_Z.nextInt(2));
    }

    @Override
    public void func_70636_d() {
        if (!(this.field_70170_p.func_72890_a((Entity)this, 5.0) == null || this.func_70631_g_() || this.func_70090_H() || this.getHasMelon())) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.AIFight);
            this.field_70715_bh.func_75776_a(7, (EntityAIBase)this.AINearAtt);
        }
        if (this.getHasMelon() || this.getIsZooAnimal() || this.field_70170_p.func_175659_aa().equals((Object)EnumDifficulty.PEACEFUL)) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.AIFight);
            this.field_70715_bh.func_85156_a((EntityAIBase)this.AINearAtt);
        }
        if (this.getHasMelon() && !this.b) {
            this.playTameEffect();
            for (int i = 0; i < 7; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.HEART, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
            }
            this.b = true;
        }
        if (!this.field_70170_p.field_72995_K) {
            int posZ = 0;
            int posX = 0;
            int posY = 0;
            posX = this.func_70681_au().nextInt(3) + 1;
            posZ = this.func_70681_au().nextInt(3) + 1;
            switch (posX) {
                default: {
                    posX = 0;
                    break;
                }
                case 1: {
                    posX = 0;
                    break;
                }
                case 2: {
                    posX = 1;
                    break;
                }
                case 3: {
                    posX = -1;
                }
            }
            switch (posZ) {
                default: {
                    posZ = 0;
                    break;
                }
                case 1: {
                    posZ = 0;
                    break;
                }
                case 2: {
                    posZ = 1;
                    break;
                }
                case 3: {
                    posZ = -1;
                }
            }
            Block block = this.field_70170_p.func_180495_p(this.func_180425_c().func_177982_a(posX, posY, posZ)).func_177230_c();
            if (block == Blocks.field_150440_ba) {
                this.field_70170_p.func_175698_g(this.func_180425_c().func_177982_a(posX, posY, posZ));
                this.setHasMelon(true);
            }
        }
        if (this.field_70171_ac) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(3.06);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
        }
        super.func_70636_d();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76364_f() instanceof EntityLivingBase) {
            this.func_70604_c((EntityLivingBase)source.func_76364_f());
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70652_k(Entity p_70652_1_) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        return p_70652_1_.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 12.0f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(26, (Object)0);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("Melon", this.getHasMelon());
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setHasMelon(tagCompund.func_74767_n("Melon"));
    }

    public boolean getHasMelon() {
        return this.field_70180_af.func_75683_a(26) != 0;
    }

    public void setHasMelon(boolean f) {
        if (f) {
            this.field_70180_af.func_75692_b(26, (Object)1);
        } else {
            this.field_70180_af.func_75692_b(26, (Object)0);
        }
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        EntityNileHippo li = new EntityNileHippo(this.field_70170_p);
        if (this.func_70681_au().nextInt(5) != 1) {
            li.setAnimalTrait(this.getTrait());
        }
        if (this.func_70681_au().nextInt(5) != 1) {
            li.setAnimalType(this.getAnimalType());
        }
        return li;
    }

    @Override
    public AnimalData.EnumNature setNature() {
        return AnimalData.EnumNature.TERRITORIAL;
    }

    class AIFight
    extends EntityAIAttackOnCollide {
        public AIFight() {
            super((EntityCreature)EntityNileHippo.this, EntityLivingBase.class, 1.4, true);
        }

        protected double func_179512_a(EntityLivingBase evb) {
            return 4.0f + evb.field_70130_N;
        }
    }
}

