/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import com.google.common.base.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import org.zawamod.entity.ai.EntityAIAttackEnts;
import org.zawamod.entity.base.ZAWABaseLand;
import org.zawamod.entity.data.AnimalData;
import org.zawamod.entity.data.BreedItems;
import org.zawamod.entity.water.EntityFish;
import org.zawamod.entity.water.EntityPacificWalrus;
import org.zawamod.init.items.ZAWAItems;
import org.zawamod.util.ZAWASounds;

public class EntityPolarBear
extends ZAWABaseLand {
    public boolean isRegular = true;
    public boolean isStanding = false;
    private boolean hasRisen = false;
    private ZAWABaseLand.AIFight AIFight = new ZAWABaseLand.AIFight();
    private EntityAINearestAttackableTarget AINearAtt = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true);

    public EntityPolarBear(World worldIn) {
        super(worldIn, 0.26, false);
        this.func_70105_a(1.3f, 1.5f);
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAIAttackEnts(this, EntityLiving.class, false, new Predicate(){

            public boolean func_180094_a(Entity e) {
                return e instanceof EntityWolf || e instanceof EntityRabbit || e instanceof EntityPig || e instanceof EntitySheep || e instanceof EntityChicken || e instanceof EntityFish || e instanceof EntityPacificWalrus;
            }

            public boolean apply(Object o) {
                return this.func_180094_a((Entity)o);
            }
        }));
    }

    @Override
    public int setVarients() {
        return 5;
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return new ItemStack(ZAWAItems.polar_bear_egg, 1);
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return BreedItems.CarnivoreItems(stack);
    }

    @Override
    public ItemStack setTameItem() {
        return new ItemStack(ZAWAItems.bear_kibble, 1);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76364_f() instanceof EntityLivingBase) {
            this.func_70604_c((EntityLivingBase)source.func_76364_f());
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public ItemStack setVial() {
        return new ItemStack(ZAWAItems.bear_vial, 1);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.24);
    }

    protected String func_70639_aQ() {
        return ZAWASounds.POLARBEAR_AMBIENT.getSound();
    }

    protected String func_70621_aR() {
        return ZAWASounds.POLARBEAR_HURT.getSound();
    }

    @Override
    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.func_70027_ad()) {
            this.func_145779_a(ZAWAItems.carnivore_meat_cooked, 1);
        } else {
            this.func_145779_a(ZAWAItems.carnivore_meat_raw, 1);
        }
        this.func_145779_a(ZAWAItems.fur, this.field_70146_Z.nextInt(3));
        this.func_145779_a(ZAWAItems.polar_bear_hide, this.field_70146_Z.nextInt(2));
    }

    @Override
    public void func_70636_d() {
        if (!(this.field_70170_p.func_72890_a((Entity)this, 5.0) == null || this.func_70631_g_() || this.func_70090_H() || this.hasRisen)) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.AIFight);
            this.field_70715_bh.func_75776_a(7, (EntityAIBase)this.AINearAtt);
            this.isRegular = true;
            this.isStanding = false;
            this.hasRisen = true;
        } else if (this.field_70170_p.func_72890_a((Entity)this, 6.0) != null && !this.func_70631_g_() && !this.func_70090_H()) {
            this.isRegular = false;
            this.isStanding = true;
        } else {
            this.isRegular = true;
            this.isStanding = false;
        }
        if (this.field_70171_ac) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.06);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.24);
        }
        super.func_70636_d();
    }

    public boolean func_70652_k(Entity p_70652_1_) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        return p_70652_1_.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 12.0f);
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        EntityPolarBear li = new EntityPolarBear(this.field_70170_p);
        if (this.func_70681_au().nextInt(5) != 1) {
            li.setAnimalTrait(this.getTrait());
        }
        if (this.func_70681_au().nextInt(5) != 1) {
            li.setAnimalType(this.getAnimalType());
        }
        return li;
    }

    @Override
    public AnimalData.EnumNature setNature() {
        return AnimalData.EnumNature.AGGRESSIVE;
    }

    class AIFight
    extends EntityAIAttackOnCollide {
        public AIFight() {
            super((EntityCreature)EntityPolarBear.this, EntityLivingBase.class, 1.4, true);
        }

        protected double func_179512_a(EntityLivingBase evb) {
            return 4.0f + evb.field_70130_N;
        }
    }
}

