/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import org.zawamod.entity.base.ZAWABaseLand;
import org.zawamod.entity.data.AnimalData;
import org.zawamod.entity.data.BreedItems;
import org.zawamod.init.items.ZAWAItems;

public class EntityRedKangaroo
extends ZAWABaseLand {
    private ZAWABaseLand.AIFight AIFight = new ZAWABaseLand.AIFight();
    private EntityAINearestAttackableTarget AINearAtt = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true);
    private AISlimeFaceRandom AIFaceRandom = new AISlimeFaceRandom();
    private AISlimeHop AIHop = new AISlimeHop();

    public EntityRedKangaroo(World worldIn) {
        super(worldIn, 0.29, false);
        this.func_70105_a(0.8f, 0.9f);
        this.field_70765_h = new SlimeMoveHelper();
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.AIHop);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.AIFaceRandom);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.setChildH(false);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(23.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.29);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(26, (Object)0);
        this.field_70180_af.func_75682_a(27, (Object)0);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("HasChild", this.getChildH());
        tagCompound.func_74768_a("Timer", this.getHoldTime());
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setChildH(tagCompund.func_74767_n("HasChild"));
        this.setHoldTime(tagCompund.func_74762_e("Timer"));
    }

    public int getHoldTime() {
        return this.field_70180_af.func_75679_c(27);
    }

    public void setHoldTime(int f) {
        this.field_70180_af.func_75692_b(27, (Object)f);
    }

    public boolean getChildH() {
        return this.field_70180_af.func_75683_a(26) != 0;
    }

    public void setChildH(boolean f) {
        if (f) {
            this.field_70180_af.func_75692_b(26, (Object)1);
        } else {
            this.field_70180_af.func_75692_b(26, (Object)0);
        }
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return BreedItems.GrazzerItems(stack);
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return new ItemStack(ZAWAItems.red_kangaroo_egg, 1);
    }

    @Override
    public ItemStack setTameItem() {
        return new ItemStack(ZAWAItems.unglate_kibble, 1);
    }

    @Override
    public ItemStack setVial() {
        if (this.getChildH()) {
            return null;
        }
        return new ItemStack(ZAWAItems.unglate_vial, 1);
    }

    @Override
    public void func_70636_d() {
        if (this.getChildH()) {
            this.setHoldTime(this.getHoldTime() + 1);
        }
        if (this.getHoldTime() >= 1200 && this.getChildH()) {
            this.setChildH(false);
            EntityRedKangaroo child = new EntityRedKangaroo(this.field_70170_p);
            child.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            child.setAnimalTrait(this.getTrait());
            child.setAnimalType(this.getAnimalType());
            child.func_70873_a(-24000);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)child);
            }
        }
        super.func_70636_d();
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    @Override
    public int setVarients() {
        return 4;
    }

    public boolean func_70652_k(Entity p_70652_1_) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        return p_70652_1_.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 3.0f);
    }

    @Override
    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.func_70027_ad()) {
            this.func_145779_a(ZAWAItems.bush_meat_cooked, 1);
        } else {
            this.func_145779_a(ZAWAItems.bush_meat_raw, 1);
        }
        this.func_145779_a(ZAWAItems.fur, this.field_70146_Z.nextInt(3));
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        this.setChildH(true);
        this.func_70875_t();
        return null;
    }

    protected int getJumpDelay() {
        return 0;
    }

    @Override
    public void setAnimalType(int animalType) {
        this.field_70180_af.func_75692_b(24, (Object)((byte)animalType));
    }

    @Override
    public AnimalData.EnumNature setNature() {
        return AnimalData.EnumNature.NEUTRAL;
    }

    class AISlimeFaceRandom
    extends EntityAIBase {
        private EntityRedKangaroo kangarooo;
        private float f;
        private int i;

        public AISlimeFaceRandom() {
            this.kangarooo = EntityRedKangaroo.this;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return this.kangarooo.func_70638_az() == null && (this.kangarooo.field_70122_E || this.kangarooo.func_70090_H() || this.kangarooo.func_180799_ab());
        }

        public void func_75246_d() {
            if (--this.i <= 0) {
                this.i = 40 + this.kangarooo.func_70681_au().nextInt(60);
                this.f = this.kangarooo.func_70681_au().nextInt(360);
            }
            ((SlimeMoveHelper)this.kangarooo.func_70605_aq()).func_179920_a(this.f, false);
        }
    }

    class SlimeMoveHelper
    extends EntityMoveHelper {
        private float angle;
        private int jmpDelay;
        private EntityRedKangaroo kangaroo;
        private boolean field_179923_j;

        public SlimeMoveHelper() {
            super((EntityLiving)EntityRedKangaroo.this);
            this.kangaroo = EntityRedKangaroo.this;
        }

        public void func_179920_a(float angle, boolean p_179920_2_) {
            this.angle = angle;
            this.field_179923_j = p_179920_2_;
        }

        public void func_179921_a(double p_179921_1_) {
            this.field_75645_e = p_179921_1_;
            this.field_75643_f = true;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.angle, 30.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (!this.field_75643_f) {
                this.field_75648_a.func_70657_f(0.0f);
            } else {
                this.field_75643_f = false;
                if (this.field_75648_a.field_70122_E) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                    if (this.jmpDelay-- <= 0) {
                        this.jmpDelay = this.kangaroo.getJumpDelay();
                        if (this.field_179923_j) {
                            this.jmpDelay /= 3;
                        }
                        this.kangaroo.func_70683_ar().func_75660_a();
                    } else {
                        this.kangaroo.field_70701_bs = 0.0f;
                        this.kangaroo.field_70702_br = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                }
            }
        }
    }

    class AISlimeHop
    extends EntityAIBase {
        private EntityRedKangaroo kangaroo;

        public AISlimeHop() {
            this.kangaroo = EntityRedKangaroo.this;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            ((SlimeMoveHelper)this.kangaroo.func_70605_aq()).func_179921_a(1.0);
        }
    }
}

