/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.zawamod.entity.base.ZAWABaseLand;
import org.zawamod.entity.data.AnimalData;
import org.zawamod.entity.data.BreedItems;
import org.zawamod.init.achieve.ZAWAAchievement;
import org.zawamod.init.items.ZAWAItems;
import org.zawamod.util.ZAWAUtils;

public class EntityReticulatedGiraffe
extends ZAWABaseLand {
    public EntityReticulatedGiraffe(World worldIn) {
        super(worldIn, 0.08, false);
        this.func_70105_a(2.0f, 4.2f);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 0.23));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return new ItemStack(ZAWAItems.reticulated_giraffe_egg, 1);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(52.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    @Override
    public boolean isTransportable() {
        return false;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        EntityReticulatedGiraffe li = new EntityReticulatedGiraffe(this.field_70170_p);
        if (this.func_70681_au().nextInt(5) != 1) {
            li.setAnimalTrait(this.getTrait());
        }
        if (this.func_70681_au().nextInt(5) != 1) {
            li.setAnimalType(this.getAnimalType());
        }
        return li;
    }

    @Override
    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        this.func_145779_a(ZAWAItems.giraffe_hide, this.field_70146_Z.nextInt(3));
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return BreedItems.LeafEaterItems(stack);
    }

    @Override
    public void onTame(EntityPlayer p) {
        super.onTame(p);
        p.func_71029_a((StatBase)ZAWAAchievement.achievementMadagascar);
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (stack != null && stack.func_77973_b() == Items.field_151141_av && this.getIsZooAnimal() && !this.func_70631_g_()) {
            this.setHasSaddle(true);
        }
        if (this.getIsZooAnimal() && this.getHasSaddle() && this.field_70153_n == null && this.isOwner(player) && !this.field_70170_p.field_72995_K) {
            player.func_70078_a((Entity)this);
        }
        return super.func_70085_c(player);
    }

    @Override
    public void func_70636_d() {
        for (int i = -3; i < 6; ++i) {
            for (int a = -3; a < 6; ++a) {
                Block block;
                Vec3 vec3 = RandomPositionGenerator.func_75464_a((EntityCreature)this, (int)3, (int)4, (Vec3)new Vec3(this.field_70165_t + (double)a, this.field_70163_u, this.field_70161_v + (double)i));
                if (vec3 == null || ZAWAUtils.getBlockAtPos(this.field_70170_p, vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c) == Blocks.field_150350_a || (block = ZAWAUtils.getBlockAtPos(this.field_70170_p, vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c)) != Blocks.field_150362_t && block != Blocks.field_150361_u) continue;
                if (this.getIsZooAnimal() && this.getCurrFood() < this.getMaxFood()) {
                    this.setCurrFood(this.getCurrFood() + 0.5);
                }
                if (this.field_70153_n != null) continue;
                this.field_70170_p.func_175698_g(new BlockPos(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c));
            }
        }
        super.func_70636_d();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(26, (Object)0);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("Saddle", this.getHasSaddle());
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setHasSaddle(tagCompund.func_74767_n("Saddle"));
    }

    public boolean getHasSaddle() {
        return this.field_70180_af.func_75683_a(26) != 0;
    }

    public void setHasSaddle(boolean f) {
        if (f) {
            this.field_70180_af.func_75692_b(26, (Object)1);
        } else {
            this.field_70180_af.func_75692_b(26, (Object)0);
        }
    }

    public void func_70612_e(float stafe, float forward) {
        if (this.field_70153_n != null) {
            this.field_70126_B = this.field_70177_z = this.field_70153_n.field_70177_z;
            this.field_70125_A = this.field_70153_n.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            stafe = ((EntityLivingBase)this.field_70153_n).field_70702_br * 0.1f;
            forward = ((EntityLivingBase)this.field_70153_n).field_70701_bs;
            this.field_70138_W = 1.0f;
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (!this.field_70170_p.field_72995_K) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_70612_e(stafe, forward);
            }
            this.field_70722_aY = this.field_70721_aZ;
            double d0 = this.field_70165_t - this.field_70169_q;
            double d1 = this.field_70161_v - this.field_70166_s;
            float f4 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1)) * 4.0f;
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
            this.field_70754_ba += this.field_70721_aZ;
        } else {
            this.field_70138_W = 1.0f;
            this.field_70747_aH = 0.02f;
            super.func_70612_e(stafe, forward);
        }
    }

    public void func_70043_V() {
        super.func_70043_V();
        if (this.field_70153_n != null) {
            this.field_70153_n.func_70107_b(this.field_70165_t, this.field_70163_u + this.func_70042_X() - 0.4 + this.field_70153_n.func_70033_W(), this.field_70161_v);
        }
    }

    @Override
    public ItemStack setTameItem() {
        return new ItemStack(ZAWAItems.unglate_kibble);
    }

    @Override
    public int setVarients() {
        return 3;
    }

    @Override
    public AnimalData.EnumNature setNature() {
        return AnimalData.EnumNature.PASSIVE;
    }

    @Override
    public ItemStack setVial() {
        return new ItemStack(ZAWAItems.unglate_vial, 1);
    }
}

