/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import org.zawamod.entity.base.ZAWABaseLand;
import org.zawamod.entity.data.AnimalData;
import org.zawamod.entity.data.BreedItems;
import org.zawamod.init.items.ZAWAItems;
import org.zawamod.util.ZAWASounds;

public class EntityTreeFrog
extends ZAWABaseLand {
    private ZAWABaseLand.AIFight AIFight = new ZAWABaseLand.AIFight();
    private EntityAINearestAttackableTarget AINearAtt = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true);
    private AISlimeFaceRandom AIFaceRandom = new AISlimeFaceRandom();
    private AISlimeHop AIHop = new AISlimeHop();
    private float swimmingPitch;
    private float prevswimmingPitch;
    private float swimmingYaw;
    private float prevswimmingYaw;
    private float swimmingRotation;
    private float prevswimmingRotation;
    private float randomMotionSpeed;
    private float rotationVelocity;
    private float field_70871_bB;
    private float randomMotionVecX;
    private float randomMotionVecY;
    private float randomMotionVecZ;

    public EntityTreeFrog(World worldIn) {
        super(worldIn, 0.29, true);
        this.func_70105_a(0.8f, 0.9f);
        this.field_70765_h = new SlimeMoveHelper();
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.AIHop);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.AIFaceRandom);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIMoveRandom());
    }

    @Override
    public boolean socialInteraction() {
        return false;
    }

    @Override
    public boolean isTransportable() {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return BreedItems.InsectivoreItems(stack);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(23.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.29);
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return new ItemStack(ZAWAItems.tree_frog_egg, 1);
    }

    @Override
    public ItemStack setTameItem() {
        return new ItemStack(ZAWAItems.frog_kibble, 1);
    }

    @Override
    public ItemStack setVial() {
        return new ItemStack(ZAWAItems.frog_vial, 1);
    }

    protected String func_70639_aQ() {
        return ZAWASounds.FROG_AMBIENT.getSound();
    }

    protected String func_70621_aR() {
        return ZAWASounds.FROG_HURT.getSound();
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    @Override
    public int setVarients() {
        return 8;
    }

    @Override
    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.func_70027_ad()) {
            this.func_145779_a(ZAWAItems.cooked_frog_leg, 1);
        } else {
            this.func_145779_a(ZAWAItems.raw_frog_leg, 1);
        }
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        EntityTreeFrog li = new EntityTreeFrog(this.field_70170_p);
        if (this.func_70681_au().nextInt(5) != 1) {
            li.setAnimalTrait(this.getTrait());
        }
        if (this.func_70681_au().nextInt(5) != 1) {
            li.setAnimalType(this.getAnimalType());
        }
        return li;
    }

    protected int getJumpDelay() {
        return this.field_70146_Z.nextInt(8);
    }

    @Override
    public void setAnimalType(int animalType) {
        this.field_70180_af.func_75692_b(24, (Object)((byte)animalType));
    }

    @Override
    public AnimalData.EnumNature setNature() {
        return AnimalData.EnumNature.SKITTISH;
    }

    public void func_70612_e(float p_70612_1_, float p_70612_2_) {
        if (this.func_70631_g_()) {
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        } else {
            super.func_70612_e(p_70612_1_, p_70612_2_);
        }
    }

    public void setMotionVec(float p_175568_1_, float p_175568_2_, float p_175568_3_) {
        this.randomMotionVecX = p_175568_1_;
        this.randomMotionVecY = p_175568_2_;
        this.randomMotionVecZ = p_175568_3_;
    }

    public boolean isMotionVecZero() {
        return this.randomMotionVecX != 0.0f || this.randomMotionVecY != 0.0f || this.randomMotionVecZ != 0.0f;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70631_g_()) {
            this.prevswimmingPitch = this.swimmingPitch;
            this.prevswimmingYaw = this.swimmingYaw;
            this.prevswimmingRotation = this.swimmingRotation;
            this.swimmingRotation += this.rotationVelocity;
            if ((double)this.swimmingRotation > Math.PI * 2) {
                if (this.field_70170_p.field_72995_K) {
                    this.swimmingRotation = (float)Math.PI * 2;
                } else {
                    this.swimmingRotation = (float)((double)this.swimmingRotation - Math.PI * 2);
                    if (this.field_70146_Z.nextInt(10) == 0) {
                        this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
                    }
                    this.field_70170_p.func_72960_a((Entity)this, (byte)19);
                }
            }
            if (this.field_70171_ac && !this.func_70610_aX()) {
                float f;
                if (this.swimmingRotation < (float)Math.PI) {
                    f = this.swimmingRotation / (float)Math.PI;
                    if ((double)f > 0.75) {
                        this.randomMotionSpeed = 1.0f;
                        this.field_70871_bB = 1.0f;
                    } else {
                        this.field_70871_bB *= 0.5f;
                    }
                } else {
                    this.randomMotionSpeed *= 0.6f;
                    this.field_70871_bB *= 0.99f;
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70159_w = this.randomMotionVecX * this.randomMotionSpeed;
                    this.field_70181_x = this.randomMotionVecY * this.randomMotionSpeed;
                    this.field_70179_y = this.randomMotionVecZ * this.randomMotionSpeed;
                }
                f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
                this.field_70761_aq += (-((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI - this.field_70761_aq) * 0.1f;
                this.field_70177_z = this.field_70761_aq;
                this.swimmingYaw = (float)((double)this.swimmingYaw + Math.PI * (double)this.field_70871_bB * 1.5);
                this.swimmingPitch += (-((float)Math.atan2(f, this.field_70181_x)) * 180.0f / (float)Math.PI - this.swimmingPitch) * 0.1f;
            } else {
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70159_w = 0.0;
                    this.field_70181_x -= 0.08;
                    this.field_70181_x *= 0.5800000190734863;
                    this.field_70179_y = 0.0;
                }
                this.swimmingPitch = (float)((double)this.swimmingPitch + (double)(-90.0f - this.swimmingPitch) * 0.02);
            }
        }
    }

    class AIMoveRandom
    extends EntityAIBase {
        private EntityTreeFrog animal;

        AIMoveRandom() {
            this.animal = EntityTreeFrog.this;
        }

        public boolean func_75250_a() {
            return this.animal.func_70631_g_();
        }

        public void func_75246_d() {
            int i = this.animal.func_70654_ax();
            if (i > 100) {
                this.animal.setMotionVec(0.0f, 0.0f, 0.0f);
            } else if (this.animal.func_70681_au().nextInt(50) == 0 || !this.animal.field_70171_ac || !this.animal.isMotionVecZero()) {
                float f = this.animal.func_70681_au().nextFloat() * (float)Math.PI * 2.0f;
                float x = MathHelper.func_76134_b((float)f) * 0.2f;
                float z = -0.1f + this.animal.func_70681_au().nextFloat() * 0.2f;
                float y = MathHelper.func_76126_a((float)f) * 0.2f;
                this.animal.setMotionVec(x, z, y);
            }
        }
    }

    class AISlimeFaceRandom
    extends EntityAIBase {
        private EntityTreeFrog frogo;
        private float f;
        private int i;

        public AISlimeFaceRandom() {
            this.frogo = EntityTreeFrog.this;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return !this.frogo.func_70631_g_() && this.frogo.func_70638_az() == null && (this.frogo.field_70122_E || this.frogo.func_70090_H() || this.frogo.func_180799_ab());
        }

        public void func_75246_d() {
            if (--this.i <= 0) {
                this.i = 40 + this.frogo.func_70681_au().nextInt(60);
                this.f = this.frogo.func_70681_au().nextInt(360);
            }
            ((SlimeMoveHelper)this.frogo.func_70605_aq()).func_179920_a(this.f, false);
        }
    }

    class SlimeMoveHelper
    extends EntityMoveHelper {
        private float angle;
        private int jmpDelay;
        private EntityTreeFrog frog;
        private boolean field_179923_j;

        public SlimeMoveHelper() {
            super((EntityLiving)EntityTreeFrog.this);
            this.frog = EntityTreeFrog.this;
        }

        public void func_179920_a(float angle, boolean p_179920_2_) {
            this.angle = angle;
            this.field_179923_j = p_179920_2_;
        }

        public void func_179921_a(double p_179921_1_) {
            this.field_75645_e = p_179921_1_;
            this.field_75643_f = true;
        }

        public void func_75641_c() {
            if (!this.field_75648_a.func_70631_g_()) {
                this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.angle, 30.0f);
                this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
                if (!this.field_75643_f) {
                    this.field_75648_a.func_70657_f(0.0f);
                } else {
                    this.field_75643_f = false;
                    if (this.field_75648_a.field_70122_E) {
                        this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                        if (this.jmpDelay-- <= 0) {
                            this.jmpDelay = this.frog.getJumpDelay();
                            if (this.field_179923_j) {
                                this.jmpDelay /= 3;
                            }
                            this.frog.func_70683_ar().func_75660_a();
                        } else {
                            this.frog.field_70701_bs = 0.0f;
                            this.frog.field_70702_br = 0.0f;
                            this.field_75648_a.func_70659_e(0.0f);
                        }
                    } else {
                        this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                    }
                }
            }
        }
    }

    class AISlimeHop
    extends EntityAIBase {
        private EntityTreeFrog frog;

        public AISlimeHop() {
            this.frog = EntityTreeFrog.this;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            return !this.frog.func_70631_g_();
        }

        public void func_75246_d() {
            ((SlimeMoveHelper)this.frog.func_70605_aq()).func_179921_a(1.0);
        }
    }
}

