/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.water;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.zawamod.entity.base.ZAWABaseWaterOld;
import org.zawamod.entity.data.AnimalData;
import org.zawamod.entity.egg.EntityHawksbillSeaTurtleEgg;
import org.zawamod.init.achieve.ZAWAAchievement;
import org.zawamod.init.items.ZAWAItems;
import org.zawamod.util.ZAWAUtils;

public class EntityHawksbillSeaTurtle
extends ZAWABaseWaterOld {
    public EntityHawksbillSeaTurtle(World worldIn) {
        super(worldIn, false);
        this.func_70105_a(1.0f, 0.7f);
        this.setFlipped(false);
        this.setLastFlip(1000);
    }

    @Override
    public boolean hopToWater() {
        return false;
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return new ItemStack(ZAWAItems.hawksbill_sea_turtle_egg, 1);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(23, (Object)0);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Eggs", this.getEggsLayed());
        tagCompound.func_74768_a("LastFlip", this.getLastFlip());
        tagCompound.func_74757_a("Flipped", this.getFlipped());
    }

    @Override
    public boolean isTransportable() {
        return true;
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setEggsLayed(tagCompund.func_74762_e("Eggs"));
        this.setLastFlip(tagCompund.func_74762_e("LastFlip"));
        this.setFlipped(tagCompund.func_74767_n("Flipped"));
    }

    public int getEggsLayed() {
        return this.field_70180_af.func_75683_a(23);
    }

    public void setEggsLayed(int value) {
        this.field_70180_af.func_75692_b(23, (Object)((byte)value));
    }

    public int getLastFlip() {
        return this.getEntityData().func_74762_e("LastFlip");
    }

    public void setLastFlip(int value) {
        this.getEntityData().func_74768_a("LastFlip", value);
    }

    public boolean getFlipped() {
        return this.getEntityData().func_74767_n("Flipped");
    }

    public void setFlipped(boolean value) {
        this.getEntityData().func_74757_a("Flipped", value);
    }

    @Override
    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        if (this.getFlipped()) {
            this.setFlipped(false);
            player.func_71029_a((StatBase)ZAWAAchievement.achievementTurtle);
        }
        return super.func_70085_c(player);
    }

    @Override
    public ItemStack setTameItem() {
        return new ItemStack(ZAWAItems.tortoise_kibble, 1);
    }

    @Override
    public int setVarients() {
        return 6;
    }

    @Override
    public AnimalData.EnumNature setNature() {
        return AnimalData.EnumNature.UNDEFINED;
    }

    @Override
    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        this.func_145779_a(ZAWAItems.reptile_meat_raw, 1);
        super.func_70628_a(p_70628_1_, p_70628_2_);
    }

    @Override
    public void func_70636_d() {
        int a;
        super.func_70636_d();
        this.prevswimmingPitch = this.swimmingPitch;
        this.prevswimmingYaw = this.swimmingYaw;
        this.prevswimmingRotation = this.swimmingRotation;
        this.swimmingRotation += this.rotationVelocity;
        if ((double)this.swimmingRotation > Math.PI * 2) {
            if (this.field_70170_p.field_72995_K) {
                this.swimmingRotation = (float)Math.PI * 2;
            } else {
                this.swimmingRotation = (float)((double)this.swimmingRotation - Math.PI * 2);
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)19);
            }
        }
        if (this.field_70171_ac && !this.func_70610_aX()) {
            float f;
            this.landed = false;
            if (this.swimmingRotation < (float)Math.PI) {
                f = this.swimmingRotation / (float)Math.PI;
                if ((double)f > 0.75) {
                    this.randomMotionSpeed = 1.0f;
                    this.field_70871_bB = 1.0f;
                } else {
                    this.field_70871_bB *= 0.8f;
                }
            } else {
                this.randomMotionSpeed *= 0.9f;
                this.field_70871_bB *= 0.99f;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70159_w = this.randomMotionVecX * this.randomMotionSpeed;
                this.field_70181_x = this.randomMotionVecY * this.randomMotionSpeed;
                this.field_70179_y = this.randomMotionVecZ * this.randomMotionSpeed;
            }
            f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70761_aq += (-((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI - this.field_70761_aq) * 0.1f;
            this.field_70177_z = this.field_70761_aq;
            this.swimmingYaw = (float)((double)this.swimmingYaw + Math.PI * (double)this.field_70871_bB * 1.5);
            this.swimmingPitch += (-((float)Math.atan2(f, this.field_70181_x)) * 180.0f / (float)Math.PI - this.swimmingPitch) * 0.1f;
        } else {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70159_w = 0.0;
                this.field_70181_x -= 0.08;
                this.field_70181_x *= (double)0.98f;
                this.field_70179_y = 0.0;
            }
            this.swimmingPitch = (float)((double)this.swimmingPitch + (double)(-90.0f - this.swimmingPitch) * 0.02);
        }
        if (!this.func_70090_H()) {
            int i = -10;
            int a2 = -10;
            while (i < 10) {
                Vec3 vec3 = RandomPositionGenerator.func_75464_a((EntityCreature)this, (int)16, (int)7, (Vec3)new Vec3(this.field_70165_t + (double)a2, this.field_70163_u - 1.0, this.field_70161_v + (double)i));
                if (vec3 != null && ZAWAUtils.blockAtPos(this.field_70170_p, (Block)Blocks.field_150355_j, vec3.field_72450_a, vec3.field_72448_b - 1.0, vec3.field_72449_c)) {
                    this.func_70661_as().func_75492_a(vec3.field_72450_a, vec3.field_72448_b - 1.0, vec3.field_72449_c, 1.26);
                }
                ++i;
                ++a2;
            }
        }
        if (!(this.getEggsLayed() >= 3 || this.func_70631_g_() || this.getFlipped() || this.field_70171_ac || this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v)).func_177230_c() != Blocks.field_150354_m || this.field_70170_p.field_72995_K || this.func_70681_au().nextInt(100) != 5)) {
            EntityHawksbillSeaTurtleEgg egg = new EntityHawksbillSeaTurtleEgg(this.field_70170_p);
            egg.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
            this.field_70170_p.func_72838_d((Entity)egg);
            this.setEggsLayed(this.getEggsLayed() + 1);
        }
        if (this.getFlipped() && this.field_70171_ac) {
            this.setFlipped(false);
        }
        if (this.getFlipped()) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
        }
        if (!this.func_70090_H() && this.getLastFlip() >= 600 && (a = this.func_70681_au().nextInt(200) + 1) == 2) {
            this.setFlipped(true);
            this.setLastFlip(0);
        }
        if (!this.getFlipped()) {
            this.setLastFlip(this.getLastFlip() + 1);
        }
    }

    @Override
    public boolean isLandBreather() {
        return true;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(25.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    @Override
    public ItemStack setVial() {
        return null;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }
}

