/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.water;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.zawamod.entity.base.ZAWABaseWaterOld;
import org.zawamod.entity.data.AnimalData;
import org.zawamod.init.items.ZAWAItems;
import org.zawamod.util.ZAWAUtils;

public class EntityPacificWalrus
extends ZAWABaseWaterOld {
    private boolean inSearch = false;

    public EntityPacificWalrus(World worldIn) {
        super(worldIn, false);
        this.func_70105_a(2.9f, 1.0f);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.wanderAI);
        this.field_70138_W = 1.0f;
    }

    @Override
    public boolean hopToWater() {
        return false;
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return new ItemStack(ZAWAItems.walrus_egg, 1);
    }

    @Override
    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_70652_k(Entity e) {
        e.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 10.0f);
        return super.func_70652_k(e);
    }

    @Override
    public boolean isTransportable() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.getIsZooAnimal()) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.AIFight);
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)this.AINearAtt);
        }
        if (source.func_76364_f() instanceof EntityLivingBase) {
            this.func_70604_c((EntityLivingBase)source.func_76364_f());
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public ItemStack setTameItem() {
        return new ItemStack(ZAWAItems.pinniped_kibble, 1);
    }

    @Override
    public int setVarients() {
        return 4;
    }

    @Override
    public AnimalData.EnumNature setNature() {
        return AnimalData.EnumNature.NEUTRAL;
    }

    @Override
    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        this.func_145779_a(ZAWAItems.blubber, this.field_70146_Z.nextInt(5));
        super.func_70628_a(p_70628_1_, p_70628_2_);
    }

    @Override
    public void func_70636_d() {
        this.prevswimmingPitch = this.swimmingPitch;
        this.prevswimmingYaw = this.swimmingYaw;
        this.prevswimmingRotation = this.swimmingRotation;
        this.swimmingRotation += this.rotationVelocity;
        if ((double)this.swimmingRotation > Math.PI * 2 && this.func_70090_H()) {
            if (this.field_70170_p.field_72995_K) {
                this.swimmingRotation = (float)Math.PI * 2;
            } else {
                this.swimmingRotation = (float)((double)this.swimmingRotation - Math.PI * 2);
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)19);
            }
        }
        if (this.field_70171_ac && !this.func_70610_aX()) {
            float f;
            this.landed = false;
            if (this.swimmingRotation < (float)Math.PI) {
                f = this.swimmingRotation / (float)Math.PI;
                if ((double)f > 0.75) {
                    this.randomMotionSpeed = 1.0f;
                    this.field_70871_bB = 1.0f;
                } else {
                    this.field_70871_bB *= 0.8f;
                }
            } else {
                this.randomMotionSpeed *= 0.9f;
                this.field_70871_bB *= 0.99f;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70159_w = this.randomMotionVecX * this.randomMotionSpeed;
                this.field_70181_x = this.randomMotionVecY * this.randomMotionSpeed;
                this.field_70179_y = this.randomMotionVecZ * this.randomMotionSpeed;
            }
            f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70761_aq += (-((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI - this.field_70761_aq) * 0.1f;
            this.field_70177_z = this.field_70761_aq;
            this.swimmingYaw = (float)((double)this.swimmingYaw + Math.PI * (double)this.field_70871_bB * 1.5);
            this.swimmingPitch += (-((float)Math.atan2(f, this.field_70181_x)) * 180.0f / (float)Math.PI - this.swimmingPitch) * 0.1f;
        } else {
            this.swimmingPitch = (float)((double)this.swimmingPitch + (double)(-90.0f - this.swimmingPitch) * 0.02);
        }
        if (this.func_70090_H() && !this.inSearch) {
            int i = -10;
            int a = -10;
            while (i < 10) {
                Vec3 vec3 = RandomPositionGenerator.func_75464_a((EntityCreature)this, (int)16, (int)7, (Vec3)new Vec3(this.field_70165_t + (double)a, this.field_70163_u + 1.0, this.field_70161_v + (double)i));
                if (vec3 != null && ZAWAUtils.getBlockAtPos(this.field_70170_p, vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c) != Blocks.field_150355_j) {
                    this.inSearch = true;
                    this.func_70661_as().func_75492_a(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, 1.26);
                }
                ++i;
                ++a;
            }
        }
        if (!this.func_70090_H() && this.inSearch) {
            this.inSearch = false;
        }
        super.func_70636_d();
    }

    @Override
    public boolean isLandBreather() {
        return true;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.16);
    }

    @Override
    public ItemStack setVial() {
        return new ItemStack(ZAWAItems.pinniped_vial, 1);
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityPacificWalrus(this.field_70170_p);
    }
}

