/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.gui.type.mixture.container.craftmanager;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.world.World;
import org.zawamod.gui.type.mixture.container.craftmanager.MixtureCreatorRecipeSorter;
import org.zawamod.gui.type.mixture.container.craftmanager.MixtureCreatorShapedRecipes;
import org.zawamod.gui.type.mixture.container.craftmanager.MixtureCreatorShapelessRecipes;

public class MixtureCreatorManager {
    private static final MixtureCreatorManager instance = new MixtureCreatorManager();
    private List recipes = new ArrayList();

    public static MixtureCreatorManager getInstance() {
        return instance;
    }

    private MixtureCreatorManager() {
        this.addShapelessRecipe(new ItemStack(Items.field_151168_bH, 1), Items.field_151082_bd);
        Collections.sort(this.recipes, new MixtureCreatorRecipeSorter(this){

            public int compare(IRecipe p_compare_1_, IRecipe p_compare_2_) {
                return p_compare_1_ instanceof ShapelessRecipes && p_compare_2_ instanceof ShapedRecipes ? 1 : (p_compare_2_ instanceof ShapelessRecipes && p_compare_1_ instanceof ShapedRecipes ? -1 : (p_compare_2_.func_77570_a() < p_compare_1_.func_77570_a() ? -1 : (p_compare_2_.func_77570_a() > p_compare_1_.func_77570_a() ? 1 : 0)));
            }

            @Override
            public int compare(Object p_compare_1_, Object p_compare_2_) {
                return this.compare((IRecipe)p_compare_1_, (IRecipe)p_compare_2_);
            }
        });
    }

    public MixtureCreatorShapedRecipes addRecipe(ItemStack stack, Object ... recipeComponents) {
        String s = "";
        int i = 0;
        int j = 0;
        int k = 0;
        if (recipeComponents[i] instanceof String[]) {
            String[] astring = (String[])recipeComponents[i++];
            for (int l = 0; l < astring.length; ++l) {
                String s1 = astring[l];
                ++k;
                j = s1.length();
                s = s + s1;
            }
        } else {
            while (recipeComponents[i] instanceof String) {
                String s2 = (String)recipeComponents[i++];
                ++k;
                j = s2.length();
                s = s + s2;
            }
        }
        HashMap hashmap = Maps.newHashMap();
        while (i < recipeComponents.length) {
            Character character = (Character)recipeComponents[i];
            ItemStack itemstack1 = null;
            if (recipeComponents[i + 1] instanceof Item) {
                itemstack1 = new ItemStack((Item)recipeComponents[i + 1]);
            } else if (recipeComponents[i + 1] instanceof Block) {
                itemstack1 = new ItemStack((Block)recipeComponents[i + 1], 1, Short.MAX_VALUE);
            } else if (recipeComponents[i + 1] instanceof ItemStack) {
                itemstack1 = (ItemStack)recipeComponents[i + 1];
            }
            hashmap.put(character, itemstack1);
            i += 2;
        }
        ItemStack[] aitemstack = new ItemStack[j * k];
        for (int i1 = 0; i1 < j * k; ++i1) {
            char c0 = s.charAt(i1);
            aitemstack[i1] = hashmap.containsKey(Character.valueOf(c0)) ? ((ItemStack)hashmap.get(Character.valueOf(c0))).func_77946_l() : null;
        }
        MixtureCreatorShapedRecipes shapedrecipes = new MixtureCreatorShapedRecipes(j, k, aitemstack, stack);
        this.recipes.add(shapedrecipes);
        return shapedrecipes;
    }

    public void addShapelessRecipe(ItemStack stack, Object ... recipeComponents) {
        ArrayList arraylist = Lists.newArrayList();
        Object[] aobject = recipeComponents;
        int i = recipeComponents.length;
        for (int j = 0; j < i; ++j) {
            Object object1 = aobject[j];
            if (object1 instanceof ItemStack) {
                arraylist.add(((ItemStack)object1).func_77946_l());
                continue;
            }
            if (object1 instanceof Item) {
                arraylist.add(new ItemStack((Item)object1));
                continue;
            }
            if (!(object1 instanceof Block)) {
                throw new IllegalArgumentException("Invalid shapeless recipe: unknown type " + object1.getClass().getName() + "!");
            }
            arraylist.add(new ItemStack((Block)object1));
        }
        this.recipes.add(new MixtureCreatorShapelessRecipes(stack, arraylist));
    }

    public void addRecipe(IRecipe recipe) {
        this.recipes.add(recipe);
    }

    public ItemStack findMatchingRecipe(InventoryCrafting p_82787_1_, World worldIn) {
        IRecipe irecipe;
        Iterator iterator = this.recipes.iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!(irecipe = (IRecipe)iterator.next()).func_77569_a(p_82787_1_, worldIn));
        return irecipe.func_77572_b(p_82787_1_);
    }

    public ItemStack[] func_180303_b(InventoryCrafting p_180303_1_, World worldIn) {
        for (IRecipe irecipe : this.recipes) {
            if (!irecipe.func_77569_a(p_180303_1_, worldIn)) continue;
            return irecipe.func_179532_b(p_180303_1_);
        }
        ItemStack[] aitemstack = new ItemStack[p_180303_1_.func_70302_i_()];
        for (int i = 0; i < aitemstack.length; ++i) {
            aitemstack[i] = p_180303_1_.func_70301_a(i);
        }
        return aitemstack;
    }

    public List getRecipeList() {
        return this.recipes;
    }
}

