/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.init.blocks.type;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import org.zawamod.ZAWAMain;
import org.zawamod.init.blocks.type.te.foodbarrel.TileEntityFeeder;

public class BlockFeeder
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private final Random rand = new Random();
    public final int chestType;

    public BlockFeeder(int type) {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.chestType = type;
        this.func_149647_a(ZAWAMain.zawaTabDecor);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return 2;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.checkForSurroundingChests(worldIn, pos, state);
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockpos1 = pos.func_177972_a(enumfacing);
            IBlockState iblockstate1 = worldIn.func_180495_p(blockpos1);
            if (iblockstate1.func_177230_c() != this) continue;
            this.checkForSurroundingChests(worldIn, blockpos1, iblockstate1);
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        boolean flag3;
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
        state = state.func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        BlockPos blockpos1 = pos.func_177978_c();
        BlockPos blockpos2 = pos.func_177968_d();
        BlockPos blockpos3 = pos.func_177976_e();
        BlockPos blockpos4 = pos.func_177974_f();
        boolean flag = this == worldIn.func_180495_p(blockpos1).func_177230_c();
        boolean flag1 = this == worldIn.func_180495_p(blockpos2).func_177230_c();
        boolean flag2 = this == worldIn.func_180495_p(blockpos3).func_177230_c();
        boolean bl = flag3 = this == worldIn.func_180495_p(blockpos4).func_177230_c();
        if (!(flag || flag1 || flag2 || flag3)) {
            worldIn.func_180501_a(pos, state, 3);
        } else if (enumfacing.func_176740_k() == EnumFacing.Axis.X && (flag || flag1)) {
            if (flag) {
                worldIn.func_180501_a(blockpos1, state, 3);
            } else {
                worldIn.func_180501_a(blockpos2, state, 3);
            }
            worldIn.func_180501_a(pos, state, 3);
        } else if (enumfacing.func_176740_k() == EnumFacing.Axis.Z && (flag2 || flag3)) {
            if (flag2) {
                worldIn.func_180501_a(blockpos3, state, 3);
            } else {
                worldIn.func_180501_a(blockpos4, state, 3);
            }
            worldIn.func_180501_a(pos, state, 3);
        }
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityFeeder) {
            ((TileEntityFeeder)tileentity).func_145976_a(stack.func_82833_r());
        }
    }

    public IBlockState checkForSurroundingChests(World worldIn, BlockPos pos, IBlockState state) {
        if (worldIn.field_72995_K) {
            return state;
        }
        IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177978_c());
        IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177968_d());
        IBlockState iblockstate3 = worldIn.func_180495_p(pos.func_177976_e());
        IBlockState iblockstate4 = worldIn.func_180495_p(pos.func_177974_f());
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        Block block = iblockstate1.func_177230_c();
        Block block1 = iblockstate2.func_177230_c();
        Block block2 = iblockstate3.func_177230_c();
        Block block3 = iblockstate4.func_177230_c();
        if (block != this && block1 != this) {
            boolean flag = block.func_149730_j();
            boolean flag1 = block1.func_149730_j();
            if (block2 == this || block3 == this) {
                BlockPos blockpos2 = block2 == this ? pos.func_177976_e() : pos.func_177974_f();
                IBlockState iblockstate7 = worldIn.func_180495_p(blockpos2.func_177978_c());
                IBlockState iblockstate8 = worldIn.func_180495_p(blockpos2.func_177968_d());
                enumfacing = EnumFacing.SOUTH;
                EnumFacing enumfacing2 = block2 == this ? (EnumFacing)iblockstate3.func_177229_b((IProperty)FACING) : (EnumFacing)iblockstate4.func_177229_b((IProperty)FACING);
                if (enumfacing2 == EnumFacing.NORTH) {
                    enumfacing = EnumFacing.NORTH;
                }
                Block block6 = iblockstate7.func_177230_c();
                Block block7 = iblockstate8.func_177230_c();
                if ((flag || block6.func_149730_j()) && !flag1 && !block7.func_149730_j()) {
                    enumfacing = EnumFacing.SOUTH;
                }
                if ((flag1 || block7.func_149730_j()) && !flag && !block6.func_149730_j()) {
                    enumfacing = EnumFacing.NORTH;
                }
            }
        } else {
            BlockPos blockpos1 = block == this ? pos.func_177978_c() : pos.func_177968_d();
            IBlockState iblockstate5 = worldIn.func_180495_p(blockpos1.func_177976_e());
            IBlockState iblockstate6 = worldIn.func_180495_p(blockpos1.func_177974_f());
            enumfacing = EnumFacing.EAST;
            EnumFacing enumfacing1 = block == this ? (EnumFacing)iblockstate1.func_177229_b((IProperty)FACING) : (EnumFacing)iblockstate2.func_177229_b((IProperty)FACING);
            if (enumfacing1 == EnumFacing.WEST) {
                enumfacing = EnumFacing.WEST;
            }
            Block block4 = iblockstate5.func_177230_c();
            Block block5 = iblockstate6.func_177230_c();
            if ((block2.func_149730_j() || block4.func_149730_j()) && !block3.func_149730_j() && !block5.func_149730_j()) {
                enumfacing = EnumFacing.EAST;
            }
            if ((block3.func_149730_j() || block5.func_149730_j()) && !block2.func_149730_j() && !block4.func_149730_j()) {
                enumfacing = EnumFacing.WEST;
            }
        }
        state = state.func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        worldIn.func_180501_a(pos, state, 3);
        return state;
    }

    public IBlockState correctFacing(World worldIn, BlockPos pos, IBlockState state) {
        EnumFacing enumfacing = null;
        for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177972_a(enumfacing1));
            if (iblockstate1.func_177230_c() == this) {
                return state;
            }
            if (!iblockstate1.func_177230_c().func_149730_j()) continue;
            if (enumfacing != null) {
                enumfacing = null;
                break;
            }
            enumfacing = enumfacing1;
        }
        if (enumfacing != null) {
            return state.func_177226_a((IProperty)FACING, (Comparable)enumfacing.func_176734_d());
        }
        EnumFacing enumfacing2 = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (worldIn.func_180495_p(pos.func_177972_a(enumfacing2)).func_177230_c().func_149730_j()) {
            enumfacing2 = enumfacing2.func_176734_d();
        }
        if (worldIn.func_180495_p(pos.func_177972_a(enumfacing2)).func_177230_c().func_149730_j()) {
            enumfacing2 = enumfacing2.func_176746_e();
        }
        if (worldIn.func_180495_p(pos.func_177972_a(enumfacing2)).func_177230_c().func_149730_j()) {
            enumfacing2 = enumfacing2.func_176734_d();
        }
        return state.func_177226_a((IProperty)FACING, (Comparable)enumfacing2);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        int i = 0;
        BlockPos blockpos1 = pos.func_177976_e();
        BlockPos blockpos2 = pos.func_177974_f();
        BlockPos blockpos3 = pos.func_177978_c();
        BlockPos blockpos4 = pos.func_177968_d();
        if (worldIn.func_180495_p(blockpos1).func_177230_c() == this) {
            if (this.isDoubleChest(worldIn, blockpos1)) {
                return false;
            }
            ++i;
        }
        if (worldIn.func_180495_p(blockpos2).func_177230_c() == this) {
            if (this.isDoubleChest(worldIn, blockpos2)) {
                return false;
            }
            ++i;
        }
        if (worldIn.func_180495_p(blockpos3).func_177230_c() == this) {
            if (this.isDoubleChest(worldIn, blockpos3)) {
                return false;
            }
            ++i;
        }
        if (worldIn.func_180495_p(blockpos4).func_177230_c() == this) {
            if (this.isDoubleChest(worldIn, blockpos4)) {
                return false;
            }
            ++i;
        }
        return i <= 1;
    }

    private boolean isDoubleChest(World worldIn, BlockPos pos) {
        return true;
    }

    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        super.func_176204_a(worldIn, pos, state, neighborBlock);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityFeeder) {
            tileentity.func_145836_u();
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof IInventory) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        ILockableContainer ilockablecontainer = this.getLockableContainer(worldIn, pos);
        if (ilockablecontainer != null) {
            playerIn.func_71007_a((IInventory)ilockablecontainer);
        }
        return true;
    }

    public ILockableContainer getLockableContainer(World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (!(tileentity instanceof TileEntityFeeder)) {
            return null;
        }
        TileEntityFeeder object = (TileEntityFeeder)tileentity;
        if (this.isBlocked(worldIn, pos)) {
            return null;
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockpos1 = pos.func_177972_a(enumfacing);
            Block block = worldIn.func_180495_p(blockpos1).func_177230_c();
            if (block != this) continue;
            if (this.isBlocked(worldIn, blockpos1)) {
                return null;
            }
            TileEntity tileentity1 = worldIn.func_175625_s(blockpos1);
            if (!(tileentity1 instanceof TileEntityFeeder)) continue;
            if (enumfacing != EnumFacing.WEST && enumfacing != EnumFacing.NORTH) {
                object = new InventoryLargeChest("Animal Feeder", (ILockableContainer)object, (ILockableContainer)((TileEntityFeeder)tileentity1));
                continue;
            }
            object = new InventoryLargeChest("Animal Feeder", (ILockableContainer)((TileEntityFeeder)tileentity1), (ILockableContainer)object);
        }
        return (ILockableContainer)object;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityFeeder();
    }

    public boolean func_149744_f() {
        return false;
    }

    public int func_180656_a(IBlockAccess worldIn, BlockPos pos, IBlockState state, EnumFacing side) {
        if (!this.func_149744_f()) {
            return 0;
        }
        int i = 0;
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityFeeder) {
            i = ((TileEntityFeeder)tileentity).field_145987_o;
        }
        return MathHelper.func_76125_a((int)i, (int)0, (int)15);
    }

    public int func_176211_b(IBlockAccess worldIn, BlockPos pos, IBlockState state, EnumFacing side) {
        return side == EnumFacing.UP ? this.func_180656_a(worldIn, pos, state, side) : 0;
    }

    private boolean isBlocked(World worldIn, BlockPos pos) {
        return this.isBelowSolidBlock(worldIn, pos);
    }

    private boolean isBelowSolidBlock(World worldIn, BlockPos pos) {
        return worldIn.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN, false);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_180641_l(World worldIn, BlockPos pos) {
        return Container.func_94526_b((IInventory)this.getLockableContainer(worldIn, pos));
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{FACING});
    }
}

