/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.DataWatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.zawamod.ZAWAAddonHandler;
import org.zawamod.client.render.RenderNone;
import org.zawamod.client.render.base.RenderLivingZAWA;
import org.zawamod.entity.data.AnimalData;
import org.zawamod.entity.data.Gender;
import org.zawamod.entity.vehicle.ZAWABaseVehicle;

public class ZAWAUtils {
    public static final int ENDANGERED = 679;
    public static final int GLOBAL_NO_VALUE = -1;

    public static Gender getGenderFromValue(int i) {
        switch (i) {
            default: {
                return Gender.FEMALE;
            }
            case 1: 
        }
        return Gender.MALE;
    }

    public static String splitCamelCase(String s) {
        return s.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " ");
    }

    public static Entity getClosestEntityToEntity(Entity target, Entity e, double distance) {
        return ZAWAUtils.getClosestEntity2(target.getClass(), e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, distance);
    }

    public static Entity getClosestEntityToPlayer(EntityPlayer entityIn, double distance) {
        return ZAWAUtils.getClosestEntity(entityIn.field_70170_p, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, distance);
    }

    public static Entity getClosestEntity2(Class search, World world, double x, double y, double z, double distance) {
        double d4 = -1.0;
        Entity entityFound = null;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity currE = (Entity)world.field_72996_f.get(i);
            if (currE.getClass() == search) continue;
            double d5 = currE.func_70092_e(x, y, z);
            if (!(distance < 0.0) && !(d5 < distance * distance) || d4 != -1.0 && !(d5 < d4)) continue;
            d4 = d5;
            entityFound = currE;
        }
        return entityFound;
    }

    public static Entity getClosestEntity(World world, double x, double y, double z, double distance) {
        double d4 = -1.0;
        Entity entityFound = null;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity currE = (Entity)world.field_72996_f.get(i);
            if (currE instanceof EntityPlayer) continue;
            double d5 = currE.func_70092_e(x, y, z);
            if (!(distance < 0.0) && !(d5 < distance * distance) || d4 != -1.0 && !(d5 < d4)) continue;
            d4 = d5;
            entityFound = currE;
        }
        return entityFound;
    }

    public static boolean isEntityMoving(Entity e) {
        return e.field_70165_t != e.field_70169_q && e.field_70161_v != e.field_70166_s;
    }

    public static String getTraitName(int traitID) {
        switch (traitID) {
            default: {
                return "None";
            }
            case 1: {
                return "Hardy";
            }
            case 2: {
                return "Lonely";
            }
            case 3: {
                return "Brave";
            }
            case 4: {
                return "Adamant";
            }
            case 5: {
                return "Naughty";
            }
            case 6: {
                return "Bold";
            }
            case 7: {
                return "Docile";
            }
            case 8: {
                return "Relaxed";
            }
            case 9: {
                return "Impish";
            }
            case 10: {
                return "Lax";
            }
            case 11: {
                return "Timid";
            }
            case 12: {
                return "Hasty";
            }
            case 13: {
                return "Serious";
            }
            case 14: {
                return "Jolly";
            }
            case 15: {
                return "Naive";
            }
            case 16: {
                return "Modest";
            }
            case 17: {
                return "Mild";
            }
            case 18: {
                return "Quite";
            }
            case 19: {
                return "Bashful";
            }
            case 20: {
                return "Rash";
            }
            case 21: {
                return "Calm";
            }
            case 22: {
                return "Gentle";
            }
            case 23: {
                return "Sassy";
            }
            case 24: {
                return "Careful";
            }
            case 25: 
        }
        return "Quirky";
    }

    public static AnimalData.Traits getTraitFromValue(int traitID) {
        switch (traitID) {
            default: {
                return AnimalData.Traits.NONE;
            }
            case 1: {
                return AnimalData.Traits.HARDY;
            }
            case 2: {
                return AnimalData.Traits.LONELY;
            }
            case 3: {
                return AnimalData.Traits.BRAVE;
            }
            case 4: {
                return AnimalData.Traits.ADAMANT;
            }
            case 5: {
                return AnimalData.Traits.NAUGHTY;
            }
            case 6: {
                return AnimalData.Traits.BOLD;
            }
            case 7: {
                return AnimalData.Traits.DOCILE;
            }
            case 8: {
                return AnimalData.Traits.RELAXED;
            }
            case 9: {
                return AnimalData.Traits.IMPISH;
            }
            case 10: {
                return AnimalData.Traits.LAX;
            }
            case 11: {
                return AnimalData.Traits.TIMID;
            }
            case 12: {
                return AnimalData.Traits.HASTY;
            }
            case 13: {
                return AnimalData.Traits.SERIOUS;
            }
            case 14: {
                return AnimalData.Traits.JOLLY;
            }
            case 15: {
                return AnimalData.Traits.NAIVE;
            }
            case 16: {
                return AnimalData.Traits.MODEST;
            }
            case 17: {
                return AnimalData.Traits.MILD;
            }
            case 18: {
                return AnimalData.Traits.QUIET;
            }
            case 19: {
                return AnimalData.Traits.BASHFUL;
            }
            case 20: {
                return AnimalData.Traits.RASH;
            }
            case 21: {
                return AnimalData.Traits.CALM;
            }
            case 22: {
                return AnimalData.Traits.GENTLE;
            }
            case 23: {
                return AnimalData.Traits.SASSY;
            }
            case 24: {
                return AnimalData.Traits.CAREFUL;
            }
            case 25: 
        }
        return AnimalData.Traits.QUIRKY;
    }

    public static int getAgeTForDays(int days) {
        return days * 23960 - days * 23960 * 2;
    }

    public static boolean blockAtPos(World worldObj, Block block, double posX, double posY, double posZ) {
        Block blockAt = worldObj.func_180495_p(new BlockPos((int)posX, (int)posY, (int)posZ)).func_177230_c();
        return blockAt == block;
    }

    public static Block getBlockAtPos(World worldObj, double posX, double posY, double posZ) {
        return worldObj.func_180495_p(new BlockPos((int)posX, (int)posY, (int)posZ)).func_177230_c();
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelBase getModel(ZAWABaseVehicle entity) {
        String nm = entity.getHeldModel();
        try {
            if (nm.toLowerCase().contains("none") || nm.length() <= (ZAWAAddonHandler.getAddonFromAnimal((Entity)entity).getModelPath() + ".").length()) {
                return null;
            }
            Object model = Class.forName(nm).newInstance();
            return (ModelBase)model;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static RenderLivingZAWA getRender(ZAWABaseVehicle entity) {
        if (!ZAWAAddonHandler.getAddonFromAnimal((Entity)entity).getModID().equals("minecraft")) {
            String nm = entity.getHeldRender();
            try {
                if (nm.toLowerCase().contains("none") || nm.length() <= (ZAWAAddonHandler.getAddonFromAnimal((Entity)entity).getRenderPath() + ".").length()) {
                    return null;
                }
                Object model = Class.forName(nm).newInstance();
                return (RenderLivingZAWA)((Object)model);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return new RenderNone();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelBase getModel(TileEntity entity) {
        String nm = entity.getTileData().func_74779_i("Model");
        try {
            if (nm.toLowerCase().contains("none") || nm.length() <= "org.zawamod.client.model.".length()) {
                return null;
            }
            Object model = Class.forName(nm).newInstance();
            return (ModelBase)model;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static RenderLivingZAWA getRender(TileEntity entity) {
        if (!entity.getTileData().func_74779_i("Render").toLowerCase().contains("None")) {
            String nm = "org.zawamod.client.render." + entity.getTileData().func_74779_i("Render");
            try {
                if (nm.toLowerCase().contains("none") || nm.length() <= "org.zawamod.client.render.".length()) {
                    return null;
                }
                Object model = Class.forName(nm).newInstance();
                return (RenderLivingZAWA)((Object)model);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            return new RenderNone();
        }
        return null;
    }

    public static void putEntityDataInNBT(Entity entity) {
        HashMap<Integer, Object> data = new HashMap<Integer, Object>();
        for (Object d : entity.func_70096_w().func_75685_c()) {
            if (!(d instanceof DataWatcher.WatchableObject)) continue;
            DataWatcher.WatchableObject de = (DataWatcher.WatchableObject)d;
            if (de.func_75669_b() instanceof Byte) {
                data.put(de.func_75672_a(), entity.func_70096_w().func_75683_a(de.func_75672_a()));
            }
            if (de.func_75669_b() instanceof Float) {
                data.put(de.func_75672_a(), Float.valueOf(entity.func_70096_w().func_111145_d(de.func_75672_a())));
            }
            if (de.func_75669_b() instanceof Integer) {
                data.put(de.func_75672_a(), entity.func_70096_w().func_75679_c(de.func_75672_a()));
            }
            if (de.func_75669_b() instanceof Short) {
                data.put(de.func_75672_a(), entity.func_70096_w().func_75693_b(de.func_75672_a()));
            }
            if (!(de.func_75669_b() instanceof String)) continue;
            data.put(de.func_75672_a(), entity.func_70096_w().func_75681_e(de.func_75672_a()));
        }
        for (Map.Entry pair : data.entrySet()) {
            if (pair.getValue() instanceof Byte) {
                entity.getEntityData().func_74774_a("ZAWA" + pair.getKey(), ((Byte)pair.getValue()).byteValue());
                continue;
            }
            if (pair.getValue() instanceof Float) {
                entity.getEntityData().func_74776_a("ZAWA" + pair.getKey(), ((Float)pair.getValue()).floatValue());
                continue;
            }
            if (pair.getValue() instanceof Integer) {
                entity.getEntityData().func_74768_a("ZAWA" + pair.getKey(), ((Integer)pair.getValue()).intValue());
                continue;
            }
            if (pair.getValue() instanceof Short) {
                entity.getEntityData().func_74777_a("ZAWA" + pair.getKey(), ((Short)pair.getValue()).shortValue());
                continue;
            }
            if (!(pair.getValue() instanceof String)) continue;
            entity.getEntityData().func_74778_a("ZAWA" + pair.getKey(), (String)pair.getValue());
        }
    }

    public static void putEntityDataInEntityNBT(Entity entity, Entity toTransfer) {
        HashMap<Integer, Object> data = new HashMap<Integer, Object>();
        for (Object d : entity.func_70096_w().func_75685_c()) {
            if (!(d instanceof DataWatcher.WatchableObject)) continue;
            DataWatcher.WatchableObject de = (DataWatcher.WatchableObject)d;
            if (de.func_75669_b() instanceof Byte) {
                data.put(de.func_75672_a(), entity.func_70096_w().func_75683_a(de.func_75672_a()));
            }
            if (de.func_75669_b() instanceof Float) {
                data.put(de.func_75672_a(), Float.valueOf(entity.func_70096_w().func_111145_d(de.func_75672_a())));
            }
            if (de.func_75669_b() instanceof Integer) {
                data.put(de.func_75672_a(), entity.func_70096_w().func_75679_c(de.func_75672_a()));
            }
            if (de.func_75669_b() instanceof Short) {
                data.put(de.func_75672_a(), entity.func_70096_w().func_75693_b(de.func_75672_a()));
            }
            if (!(de.func_75669_b() instanceof String)) continue;
            data.put(de.func_75672_a(), entity.func_70096_w().func_75681_e(de.func_75672_a()));
        }
        for (Map.Entry pair : data.entrySet()) {
            if (pair.getValue() instanceof Byte) {
                toTransfer.getEntityData().func_74774_a("ZAWA" + pair.getKey(), ((Byte)pair.getValue()).byteValue());
                continue;
            }
            if (pair.getValue() instanceof Float) {
                toTransfer.getEntityData().func_74776_a("ZAWA" + pair.getKey(), ((Float)pair.getValue()).floatValue());
                continue;
            }
            if (pair.getValue() instanceof Integer) {
                toTransfer.getEntityData().func_74768_a("ZAWA" + pair.getKey(), ((Integer)pair.getValue()).intValue());
                continue;
            }
            if (pair.getValue() instanceof Short) {
                toTransfer.getEntityData().func_74777_a("ZAWA" + pair.getKey(), ((Short)pair.getValue()).shortValue());
                continue;
            }
            if (!(pair.getValue() instanceof String)) continue;
            toTransfer.getEntityData().func_74778_a("ZAWA" + pair.getKey(), (String)pair.getValue());
        }
    }

    public static Map<Integer, Object> pullNBTToMap(Entity entity) {
        HashMap<Integer, Object> data = new HashMap<Integer, Object>();
        Map NBT2 = ZAWAUtils.toMap(entity.getEntityData().func_150296_c());
        for (Map.Entry pair : NBT2.entrySet()) {
            if (!String.valueOf(pair.getKey()).contains("ZAWA")) continue;
            data.put(Integer.valueOf(String.valueOf(pair.getKey()).substring("ZAWA".length())), pair.getValue());
        }
        return data;
    }

    public static void putMapToEntityData(Map<Integer, Object> data, Entity entity) {
        for (Map.Entry<Integer, Object> pair : data.entrySet()) {
            entity.func_70096_w().func_75692_b(pair.getKey().intValue(), pair.getValue());
        }
    }

    public static <T> Map<T, T> toMap(Set<T> set) {
        ConcurrentHashMap<T, T> map = new ConcurrentHashMap<T, T>();
        for (T st : set) {
            map.put(st, st);
        }
        return map;
    }
}

