/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.common;

import com.github.ipixeli.gender.Gender;
import com.github.ipixeli.gender.References;
import com.github.ipixeli.gender.common.PacketHandler;
import com.github.ipixeli.gender.common.PlayerSettingsManager;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.server.FMLServerHandler;

public class CommandListenerGender
extends CommandBase {
    private static final String errHelpInfo = "\u00ef\u00bf\u00bdcUse /gender for command info.";
    private static final String errPerms = "\u00ef\u00bf\u00bdcYou do not have permission to use this command.";
    private static final String errInvalid = "\u00ef\u00bf\u00bdcYour command contains an invalid argument.";
    private static final String errNotOnline = "\u00ef\u00bf\u00bdcThe target user is not online.";
    private static final List<String> alias = Arrays.asList("g", "gender");

    private static void sendChatServerWide(String s) {
        FMLServerHandler.instance().getServer().func_184103_al().func_148539_a((ITextComponent)new TextComponentString(s));
    }

    private static void sendChat(ICommandSender sender, String s) {
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00ef\u00bf\u00bd5[Gender] \u00ef\u00bf\u00bdr" + s));
    }

    private EntityPlayerMP getConnectedUser(String name) {
        return FMLServerHandler.instance().getServer().func_184103_al().func_152612_a(name);
    }

    public String func_71517_b() {
        return "Gender";
    }

    public List<String> func_71514_a() {
        return alias;
    }

    public int compareTo(ICommand o) {
        return 0;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return null;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/gender - Display commands & information.";
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        boolean succeed = false;
        try {
            if (args == null || args.length == 0 || args[0].equalsIgnoreCase("help")) {
                this.sendHelpToSender(sender);
                succeed = true;
            } else if (args[0].equalsIgnoreCase("sync")) {
                if (sender instanceof EntityPlayer && server.func_110455_j() < 3) {
                    PacketHandler.sendFromServerBroadcastAll();
                    CommandListenerGender.sendChat(sender, "Syncing player settings to connected gender clients...");
                    succeed = true;
                } else {
                    CommandListenerGender.sendChat(sender, errPerms);
                    succeed = false;
                }
            } else if (args[0].equalsIgnoreCase("set") && args.length >= 3 && args.length <= 5) {
                String target = args[1];
                EntityPlayerMP user = this.getConnectedUser(target);
                if (user != null) {
                    succeed = this.processAttributes(args, sender, target);
                } else {
                    CommandListenerGender.sendChat(sender, errNotOnline);
                }
            } else if (!args[0].equalsIgnoreCase("set")) {
                succeed = this.processAttributes(args, sender, sender.func_70005_c_());
            }
        }
        catch (Exception e) {
            Gender.logErr("Error when processing command. Sender: " + sender.func_174793_f() + " Exception: " + e.getLocalizedMessage());
        }
        if (!succeed) {
            CommandListenerGender.sendChat(sender, errHelpInfo);
        }
    }

    private boolean processAttributes(String[] args, ICommandSender sender, String target) {
        boolean success = true;
        byte f = -1;
        byte c = -1;
        int m = -1;
        for (String s : args) {
            if (s.equals("male")) {
                f = 0;
                continue;
            }
            if (s.equals("female")) {
                f = 1;
                continue;
            }
            if (s.equals("adult")) {
                c = 0;
                continue;
            }
            if (s.equals("child")) {
                c = 1;
                continue;
            }
            if (s.equals("0") || s.equals("none")) {
                m = 0;
                continue;
            }
            if (s.equals("1") || s.equals("cynthia")) {
                m = 1;
                continue;
            }
            if (s.equals("2") || s.equals("stephanie")) {
                m = 2;
                continue;
            }
            CommandListenerGender.sendChat(sender, errInvalid);
            success = false;
        }
        if (success) {
            PlayerSettingsManager.PlayerSettingKeeper k = PlayerSettingsManager.getInstance().getOrCreateForServerWithDefaultSettings(target);
            String s = "Set settings for " + target + ": ";
            String settings = "";
            if (f > -1) {
                k.getServer().setF(f);
                settings = settings + (k.getServer().isFemale() == 1 ? "female " : "male ");
            }
            if (c > -1) {
                k.getServer().setC(c);
                settings = settings + (k.getServer().isChild() == 1 ? "child " : "adult ");
            }
            if (m > -1) {
                k.getServer().setM((byte)m);
                settings = settings + m + References.getModelName((byte)m);
            }
            PacketHandler.sendFromServerBroadcastOne(k);
            CommandListenerGender.sendChat(sender, s + settings + " (" + f + " " + c + "  " + m + ")");
            if (sender.func_70005_c_() != target) {
                CommandListenerGender.sendChat(sender, sender.func_70005_c_() + " set your settings to: " + settings);
            }
        }
        return success;
    }

    private void sendHelpToSender(ICommandSender sender) {
        CommandListenerGender.sendChat(sender, "\u00ef\u00bf\u00bdd\u00ef\u00bf\u00bd6Gender v1.2.7 Command information");
        CommandListenerGender.sendChat(sender, "/gender [attributes]\u00ef\u00bf\u00bdo\u00ef\u00bf\u00bd7 - Set your settings");
        CommandListenerGender.sendChat(sender, "/gender set [username] [attributes]\u00ef\u00bf\u00bdo\u00ef\u00bf\u00bd7 - Set a player");
        CommandListenerGender.sendChat(sender, "/gender sync\u00ef\u00bf\u00bdo\u00ef\u00bf\u00bd7 - Force a resyncronization to clients");
        CommandListenerGender.sendChat(sender, "/gender\u00ef\u00bf\u00bdo\u00ef\u00bf\u00bd7 - Display command information");
        CommandListenerGender.sendChat(sender, "\u00ef\u00bf\u00bdl\u00ef\u00bf\u00bdo\u00ef\u00bf\u00bd6Attributes:");
        CommandListenerGender.sendChat(sender, "\u00ef\u00bf\u00bdo\u00ef\u00bf\u00bd6\u00ef\u00bf\u00bdlGender:\u00ef\u00bf\u00bdr\u00ef\u00bf\u00bdo\u00ef\u00bf\u00bd7 male, female \u00ef\u00bf\u00bdo\u00ef\u00bf\u00bd6\u00ef\u00bf\u00bdlAge:\u00ef\u00bf\u00bdr\u00ef\u00bf\u00bd7 adult, child \u00ef\u00bf\u00bdo\u00ef\u00bf\u00bd6\u00ef\u00bf\u00bdlModel:\u00ef\u00bf\u00bdr\u00ef\u00bf\u00bd7 0, 1, 2");
        CommandListenerGender.sendChat(sender, "\u00ef\u00bf\u00bd7\u00ef\u00bf\u00bd6Example: \u00ef\u00bf\u00bdr\u00ef\u00bf\u00bd7/gender Notchkins female child");
        CommandListenerGender.sendChat(sender, "\u00ef\u00bf\u00bd5Visit http://bit.ly/gendermod/ for updates");
    }
}

