/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.common;

import com.github.ipixeli.gender.Gender;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public abstract class FlatList {
    private File suchFile;

    public FlatList(File veryDir, String suchName) {
        this.suchFile = new File(veryDir, suchName);
        if (!this.suchFile.exists()) {
            try {
                this.suchFile.createNewFile();
            }
            catch (IOException e) {
                Gender.logErr("Failed to create or locate file " + suchName + " with error: " + e.getMessage());
            }
        }
    }

    public void readList() {
        try {
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.suchFile));
            String s = "";
            while ((s = bufferedreader.readLine()) != null) {
                if (s == "") continue;
                this.doReadEachLine(s);
            }
            bufferedreader.close();
        }
        catch (Exception e) {
            Gender.logErr("Failed to load flat-list" + this.suchFile.getName() + "with error: " + e.getMessage() + " Recreating...");
            e.printStackTrace();
        }
    }

    public void saveList() {
        try {
            PrintWriter printwriter = new PrintWriter((Writer)new FileWriter(this.suchFile), false);
            this.doWriteLines(printwriter);
            printwriter.close();
        }
        catch (Exception e) {
            Gender.logErr("Failed to save flat-list" + this.suchFile.getName() + "with error");
            e.printStackTrace();
        }
    }

    protected abstract void doReadEachLine(String var1);

    protected abstract void doWriteLines(PrintWriter var1);
}

