/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.gui;

import com.ringosham.gui.GuiInfo;
import com.ringosham.gui.TextButton;
import com.ringosham.translate.ChatTranslator;
import com.ringosham.translate.Log;
import com.ringosham.translate.Main;
import com.ringosham.translate.Reference;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class RegexGui
extends GuiScreen
implements GuiYesNoCallback {
    private final ResourceLocation texture1 = new ResourceLocation("TranslateMod".toLowerCase(), "textures/gui/LanguageSelectGui.png");
    private final ResourceLocation texture2 = new ResourceLocation("TranslateMod".toLowerCase(), "textures/gui/LanguageSelectGui.png");
    private final ResourceLocation texture3 = new ResourceLocation("TranslateMod".toLowerCase(), "textures/gui/LanguageSelectGui.png");
    private final int guiWidth = 400;
    private final int guiHeight = 200;
    private GuiInfo guiinfo;
    private int index;
    private LinkedList<String> regex = new LinkedList();
    private static final String regexTutorial = "http://regexone.com";
    private static final String regexTest = "http://regexr.com";
    private static final String nameRegex = "%name%";
    private boolean openTutorial = false;
    private boolean openTest = false;
    private GuiTextField textbox;

    public void func_73863_a(int x, int y, float tick) {
        int imgWidth = 256;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_146276_q_();
        this.field_146297_k.field_71446_o.func_110577_a(this.texture1);
        this.func_73729_b(this.guiinfo.getGuiX(), this.guiinfo.getGuiY(), 0, 0, 400, 200);
        this.field_146297_k.field_71446_o.func_110577_a(this.texture2);
        this.func_73729_b(this.guiinfo.getGuiX() + imgWidth - 10, this.guiinfo.getGuiY(), 20, 0, 400 - imgWidth, 200);
        this.field_146297_k.field_71446_o.func_110577_a(this.texture3);
        this.func_73729_b(this.guiinfo.getGuiX() + 400, this.guiinfo.getGuiY(), imgWidth - 10, 0, 10, 200);
        this.field_146289_q.func_78276_b("Real-time translation mod - Chat Regex", this.guiinfo.getGuiX() + 5, this.guiinfo.getGuiY() + 5, 0x555555);
        this.field_146289_q.func_78276_b("Regex(Regular expression) are search patterns and used to detect messages.", this.guiinfo.getGuiX() + 5, this.guiinfo.getGuiY() + 15, 0x555555);
        this.field_146289_q.func_78276_b("If you have no idea what are those, click the link below for a tutorial.", this.guiinfo.getGuiX() + 5, this.guiinfo.getGuiY() + 25, 0x555555);
        this.field_146289_q.func_78276_b("You can also use this tool to test your regex before you apply here.", this.guiinfo.getGuiX() + 5, this.guiinfo.getGuiY() + 45, 0x555555);
        this.field_146289_q.func_78276_b("Chat Regex - " + (this.index + 1) + " of " + this.regex.size(), this.guiinfo.getGuiX() + 5, this.guiinfo.getGuiY() + 65, 0x555555);
        this.field_146289_q.func_78276_b("NOTE 1: The regex only need to match the prefix of the message", this.guiinfo.getGuiX() + 5, this.guiinfo.getGuiY() + 100, 0x555555);
        this.field_146289_q.func_78276_b("NOTE 2: Regex that matches the translation messages will be deleted.", this.guiinfo.getGuiX() + 5, this.guiinfo.getGuiY() + 110, 0x555555);
        this.field_146289_q.func_78276_b("NOTE 3: You must add %name% for specifying the sender's name.", this.guiinfo.getGuiX() + 5, this.guiinfo.getGuiY() + 120, 0x555555);
        this.field_146289_q.func_78276_b("TIP: The regex should be as specific as possible to prevent sending too ", this.guiinfo.getGuiX() + 5, this.guiinfo.getGuiY() + 130, 0x555555);
        this.field_146289_q.func_78276_b("many requests to the server. Click \"Previous regex\" for examples.", this.guiinfo.getGuiX() + 5, this.guiinfo.getGuiY() + 140, 0x555555);
        this.textbox.func_146194_f();
        super.func_73863_a(x, y, tick);
    }

    public void func_73866_w_() {
        this.guiinfo = new GuiInfo(this.field_146294_l, this.field_146295_m, 400, 200);
        this.regex.clear();
        this.regex.addAll(Arrays.asList(ChatTranslator.chatRegex));
        this.regex.add("");
        this.index = this.regex.size() - 1;
        this.textbox = new GuiTextField(0, this.field_146289_q, this.guiinfo.buttonAlignLeft(), this.guiinfo.getGuiY() + 80, 390, 15);
        this.textbox.func_146205_d(false);
        this.textbox.func_146203_f(200);
        this.textbox.func_146185_a(true);
        this.textbox.func_146180_a(this.regex.get(this.index));
        this.textbox.func_146195_b(true);
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.add(new TextButton(0, this.guiinfo.buttonAlignLeft(), this.guiinfo.getGuiY() + 35, this.guiinfo.getTextGuiLength(regexTutorial), regexTutorial));
        this.field_146292_n.add(new TextButton(1, this.guiinfo.buttonAlignLeft(), this.guiinfo.getGuiY() + 55, this.guiinfo.getTextGuiLength(regexTest), regexTest));
        this.field_146292_n.add(new GuiButton(2, this.guiinfo.buttonAlignRight(), this.guiinfo.getGuiY() + 200 - 5 - 20, 100, 20, "Add Regex"));
        this.field_146292_n.add(new GuiButton(3, this.guiinfo.buttonAlignRight() - 5 - 100, this.guiinfo.getGuiY() + 200 - 5 - 20, 100, 20, "Save and close"));
        this.field_146292_n.add(new GuiButton(4, this.guiinfo.buttonAlignRight() - 10 - 200, this.guiinfo.getGuiY() + 200 - 5 - 20, 100, 20, "Previous regex"));
        this.field_146292_n.add(new GuiButton(5, this.guiinfo.buttonAlignRight() - 5 - 100, this.guiinfo.getGuiY() + 200 - 10 - 40, 100, 20, "Reset to default"));
    }

    public void func_146284_a(GuiButton button) {
        Keyboard.enableRepeatEvents((boolean)false);
        switch (button.field_146127_k) {
            case 0: {
                this.openTutorial = true;
                this.field_146297_k.func_147108_a((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, regexTutorial, 0, false));
                break;
            }
            case 1: {
                this.openTest = true;
                this.field_146297_k.func_147108_a((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, regexTest, 0, false));
                break;
            }
            case 2: {
                this.regex.set(this.index, this.textbox.func_146179_b());
                ++this.index;
                if (this.regex.size() == this.index) {
                    this.regex.add("");
                }
                this.textbox.func_146180_a(this.regex.get(this.index));
                ((GuiButton)this.field_146292_n.get((int)2)).field_146126_j = this.regex.size() - 1 == this.index ? "Add Regex" : "Next Regex";
                ((GuiButton)this.field_146292_n.get((int)4)).field_146124_l = true;
                this.textbox.func_146195_b(true);
                this.textbox.func_146202_e();
                Keyboard.enableRepeatEvents((boolean)true);
                break;
            }
            case 3: {
                if (!this.textbox.func_146179_b().trim().isEmpty()) {
                    this.regex.set(this.index, this.textbox.func_146179_b());
                } else {
                    this.regex.remove(this.index);
                }
                this.applySettings();
                this.field_146297_k.func_147108_a(null);
                break;
            }
            case 4: {
                if (!this.textbox.func_146179_b().trim().isEmpty()) {
                    this.regex.set(this.index, this.textbox.func_146179_b());
                } else {
                    this.regex.remove(this.index);
                }
                --this.index;
                if (this.index == 0) {
                    ((GuiButton)this.field_146292_n.get((int)4)).field_146124_l = false;
                }
                ((GuiButton)this.field_146292_n.get((int)2)).field_146126_j = this.regex.size() - 1 == this.index ? "Add Regex" : "Next Regex";
                this.textbox.func_146180_a(this.regex.get(this.index));
                this.textbox.func_146195_b(true);
                this.textbox.func_146202_e();
                Keyboard.enableRepeatEvents((boolean)true);
                break;
            }
            case 5: {
                ((GuiButton)this.field_146292_n.get((int)4)).field_146124_l = true;
                ((GuiButton)this.field_146292_n.get((int)2)).field_146126_j = "Add Regex";
                this.regex.clear();
                this.regex.addAll(Arrays.asList(Reference.defaultConfig.chatRegex));
                this.regex.add("");
                this.textbox.func_146180_a("");
                this.index = this.regex.size() - 1;
                this.textbox.func_146195_b(true);
                this.textbox.func_146202_e();
                Keyboard.enableRepeatEvents((boolean)true);
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73869_a(char typedchar, int keycode) throws IOException {
        this.textbox.func_146201_a(typedchar, keycode);
        if (keycode == 18 && !this.textbox.func_146206_l()) {
            this.field_146297_k.func_147108_a(null);
        } else {
            super.func_73869_a(typedchar, keycode);
        }
    }

    public void func_73864_a(int x, int y, int state) throws IOException {
        super.func_73864_a(x, y, state);
        this.textbox.func_146192_a(x, y, state);
    }

    public void func_73878_a(boolean userClicked, int userResponse) {
        if (userResponse == 0) {
            if (userClicked) {
                this.openLink();
            }
            this.openTutorial = false;
            this.openTest = false;
            this.field_146297_k.func_147108_a((GuiScreen)this);
        }
    }

    private void openLink() {
        Desktop desktop = Desktop.getDesktop();
        if (!Desktop.isDesktopSupported()) {
            Log.log(Level.ERROR, "Cannot open link");
            return;
        }
        if (this.openTutorial) {
            try {
                desktop.browse(new URI(regexTutorial));
            }
            catch (IOException | URISyntaxException e) {
                Log.log(Level.ERROR, "Cannot open link");
            }
        }
        if (this.openTest) {
            try {
                desktop.browse(new URI(regexTest));
            }
            catch (IOException | URISyntaxException e) {
                Log.log(Level.ERROR, "Cannot open link");
            }
        }
    }

    private boolean validateRegex(String regex) {
        Pattern translatePattern;
        if (regex.trim().isEmpty()) {
            return false;
        }
        try {
            translatePattern = Pattern.compile("^" + regex.replace(nameRegex, "\\w+"));
        }
        catch (PatternSyntaxException e) {
            Log.log(Level.INFO, "Regex invalid. Discarded");
            ChatTranslator.sendChatMessage("Invalid regex. Discarded: " + regex, true, TextFormatting.RED);
            return false;
        }
        Matcher matcher1 = translatePattern.matcher("Translated(Language): Testing");
        if (matcher1.find()) {
            ChatTranslator.sendChatMessage("Invalid regex. Discarded: " + regex, true, TextFormatting.RED);
        }
        if (StringUtils.countMatches((CharSequence)regex, (CharSequence)nameRegex) != 1) {
            ChatTranslator.sendChatMessage("Chat regex requires exactly 1 name identifier. Discarded: " + regex, true, TextFormatting.RED);
        }
        return !matcher1.find() && StringUtils.countMatches((CharSequence)regex, (CharSequence)nameRegex) == 1;
    }

    private void applySettings() {
        for (int i = 0; i < this.regex.size(); ++i) {
            if (!this.regex.get(i).trim().isEmpty() && this.validateRegex(this.regex.get(i))) continue;
            this.regex.remove(i);
            --i;
        }
        LinkedHashSet<String> regexSet = new LinkedHashSet<String>(this.regex);
        if (ChatTranslator.loggingLevel.equals("debug")) {
            Log.log(Level.INFO, "Chat regex count: " + regexSet.size());
        }
        Reference.configGet.chatRegex.set(regexSet.toArray(new String[regexSet.size()]));
        Reference.config.save();
        Main.syncConfig();
        ChatTranslator.sendChatMessage("Chat regex updated", true, TextFormatting.RESET);
    }
}

