/*
 * Decompiled with CFR 0.152.
 */
package com.rmtheis.yandtran;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public abstract class YandexTranslatorAPI {
    private static int responseCode;
    protected static final String ENCODING = "UTF-8";
    protected static String apiKey;
    private static String referrer;
    protected static final String PARAM_API_KEY = "key=";
    protected static final String PARAM_LANG_PAIR = "&lang=";
    protected static final String PARAM_TEXT = "&text=";

    public static void setKey(String pKey) {
        apiKey = pKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String retrieveResponse(URL url) throws Exception {
        HttpsURLConnection uc = (HttpsURLConnection)url.openConnection();
        if (referrer != null) {
            uc.setRequestProperty("referer", referrer);
        }
        uc.setRequestProperty("Content-Type", "text/plain; charset=UTF-8");
        uc.setRequestProperty("Accept-Charset", ENCODING);
        uc.setRequestMethod("GET");
        responseCode = uc.getResponseCode();
        try {
            String string = YandexTranslatorAPI.inputStreamToString(uc.getInputStream());
            return string;
        }
        finally {
            uc.disconnect();
        }
    }

    protected static String retrievePropString(URL url, String jsonValProperty) throws Exception {
        String response = YandexTranslatorAPI.retrieveResponse(url);
        JSONObject jsonObj = (JSONObject)JSONValue.parse(response);
        return jsonObj.get(jsonValProperty).toString();
    }

    protected static String retrievePropArrString(URL url, String jsonValProperty) throws Exception {
        String response = YandexTranslatorAPI.retrieveResponse(url);
        String[] translationArr = YandexTranslatorAPI.jsonObjValToStringArr(response, jsonValProperty);
        StringBuilder combinedTranslations = new StringBuilder();
        for (String s : translationArr) {
            combinedTranslations.append(s);
        }
        return combinedTranslations.toString().trim();
    }

    private static String[] jsonObjValToStringArr(String inputString, String subObjPropertyName) throws Exception {
        JSONObject jsonObj = (JSONObject)JSONValue.parse(inputString);
        JSONArray jsonArr = (JSONArray)jsonObj.get(subObjPropertyName);
        return YandexTranslatorAPI.jsonArrToStringArr(jsonArr.toJSONString());
    }

    private static String[] jsonArrToStringArr(String inputString) throws Exception {
        JSONArray jsonArr = (JSONArray)JSONValue.parse(inputString);
        String[] values = new String[jsonArr.size()];
        int i = 0;
        for (Object obj : jsonArr) {
            values[i] = obj.toString();
            ++i;
        }
        return values;
    }

    private static String inputStreamToString(InputStream inputStream) throws Exception {
        StringBuilder outputBuilder = new StringBuilder();
        try {
            if (inputStream != null) {
                String string;
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, ENCODING));
                while (null != (string = reader.readLine())) {
                    outputBuilder.append(string.replaceAll("\ufeff", ""));
                }
            }
        }
        catch (Exception ex) {
            throw new Exception("[yandex-translator-api] Error reading translation stream.", ex);
        }
        return outputBuilder.toString();
    }

    protected static void validateServiceState() throws Exception {
        if (apiKey == null || apiKey.length() < 27) {
            throw new RuntimeException("INVALID_API_KEY - Please set the API Key with your Yandex API Key");
        }
    }

    public static int getResponseCode() {
        return responseCode;
    }
}

